\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's 
\ DESCRIPTION : Create logfiles 
\ CATEGORY    : Debugging 
\ AUTHOR      : Coos Haak 
\ LAST CHANGE : August 24, 1994, Coos Haak. Allow BIOS-IO, disallow STATUS
\ LAST CHANGE : 08 mar 94, Coos Haak. Automatic logging off at program end. 
\ LAST CHANGE : 27 jan 94, Coos Haak 
\ LAST CHANGE : 04 dec 93, Coos Haak 
\ ----------------------------------------------------------------------



        MARKER -log


DOC
  27 jan 94, log the command line after <enter> key, otherwise
  the backspaces show up in the logfile, boring!
  /BUFFER is made large, so timing of short programs is not delayed
  because of writing the logfile.

  OPEN-LOG   opens the logfile
  CLOSE-LOG  closes the logfile
  LOGFILE    contains normally the string "forth.log"
ENDDOC

        privates

also internal

0 value log?                            private \ logging on?
#10 #1024 * constant /logbuffer         private \ size of buffer

\G Contains the name of the logfile.
CREATE LOGFILE          ( -- c-addr )                   \ LOG
        here #64 dup allot erase
        s" forth.log" logfile place

/logbuffer #paragraphs segment logseg   private \ create buffer segment

0 value oldlog                          private \ save logging flag
0 value oldstatus                       private \ save statusline flag

variable logpointer                     private \ character pointer

variable loghandle                      private \ file handle

variable firsttime                      private \ flag for header

: flush-log             ( -- )                  \ save whole buffer
        logseg @ 0 logpointer @ loghandle @
        writex-file throw                               \ special write-file
        logpointer off                                  \ buffer empty again
        ;  private

: putlog                ( char -- )             \ write one character
        logpointer @ /logbuffer =                       \ if buffer is full
        if      flush-log                               \ write it
        then
        logseg @ logpointer @ c!x                       \ store character
        logpointer incr                                 \ increment pointer
        ;  private

' putlog is log-emit

: open-logfile          ( -- )                  \ open logfile
        logfile count 2dup file-status nip              \ does it exist?
        if      w/o create-file throw loghandle !       \ no, create it
                firsttime on                            \ flag for header
        else    r/w open-file throw loghandle !         \ else reopen it
                loghandle @ file-size throw             \ get size and
                loghandle @ reposition-file throw       \ go to the end
                firsttime off                           \ no header
        then
        true to log?                                    \ for log-toggle
        ;  private

: (open-log)            ( -- )                  \ primitive open
        open-logfile                                    \ open file
        logpointer off                                  \ buffer empty
        logging? to oldlog true to logging?             \ logging on
        status? to oldstatus clear status?              \ statusline off
        silent                                          \ screen echo off
        firsttime @
        if      ." Filename: " logfile count type       \ type the filename
                .signon                                 \ write some info
                firsttime off                           \ not new anymore
        then
        cr ." Log from: "                               \ intro for new log
        (date) type ." , " .time cr cr                  \ date and time
        video                                           \ echo on
        ;  private

\G Open the logfile.
: OPEN-LOG              ( -- )                          \ LOG
        logging?
        if      exit                                    \ is already opened
        then
        ['] (open-log) catch ?dup                       \ something wrong?
        if      loghandle @ close-file drop
                throw
        then
        ;

\G Close the logfile.
: CLOSE-LOG             ( -- )                          \ LOG
        logging? invert
        if      exit                                    \ is already closed
        then
        silent cr video
        flush-log                                       \ write remaining
        oldlog to logging?                              \ restore flag
        oldstatus to status?                            \ restore flag
        loghandle @ close-file throw                    \ close file
        clear log?                                      \ for log-toggle
        ;

: F2-key
[ editor ?def escape ] [if]
        escape
[then]
[ internal ]
        log?                                            \ log open?
        if      ." Log closed" ['] close-log            \ close it
        else    ." Log open" ['] open-log               \ else open it
        then
        is log-toggle cr
        ;  private

' f2-key $3C00 []key !                                  \ F2 key

deprive

:noname
        chain atexit                                    \ extend vector
        close-log                                       \ automatic close
        ;  is atexit

previous

                            \ (* End of Source *) /
