\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's
\ DESCRIPTION : iForth graphic words
\ CATEGORY    : Incompatibilities
\ AUTHOR      : Coos Haak
\ LAST CHANGE : November 12, 1994, Coos Haak
\ ----------------------------------------------------------------------



        MARKER -igraph


#15 CONSTANT white
#14 CONSTANT yellow
#13 CONSTANT magenta
#12 CONSTANT red
#11 CONSTANT cyan
#10 CONSTANT green
 #9 CONSTANT blue
  0 CONSTANT black

: GETXY     ( -- x y )
        XPIX YPIX
    ;

: limited       ( x1 y2 -- x2 y2 )
        ymax circular swap
        xmax circular swap
    ;

: V+        ( x1 y1 x2 y2 -- x3 y3 )
        LOCALS| y2 x2 y1 x1 |
        x1 x2 +
        y1 y2 +
        limited
    ;

: IMOVETO               ( dx dy -- )
        GETXY V+ limited MOVETO
    ;

: RECTANGLE         ( x1 y1 x2 y2 color -- )
        TO color LOCALS| dy dx y x |
        x y limited
        x dx + y dy + limited
        BOX 
    ;

: GETCOLOR              ( -- color )
        COLOR
    ;

: SETCOLOR              ( color -- )
        TO COLOR
    ;

' TEXT? ALIAS TEXTMODE?

' NOOP ALIAS PUT!

: CENTER
        XMAX 2/
        YMAX 2/
        MOVETO
    ;

                            \ (* End of Source *) /
