\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's 
\ DESCRIPTION : Fixed point logarithmic functions 
\ CATEGORY    : Fixed point routines 
\ AUTHOR      : Coos Haak 
\ LAST CHANGE : May 16, 1994, Coos Haak 
\ ----------------------------------------------------------------------



        NEEDS -fixed

        MARKER -fixlog



base @ decimal

   45426 0 fconstant fln2
   19830 2 fconstant fln10

privates

create lntab    private
   45426 0 2,  26573 0 2,  14624 0 2,   7719 0 2,
    3973 0 2,   2017 0 2,   1016 0 2,    510 0 2,
     256 0 2,    128 0 2,     64 0 2,     32 0 2,
      16 0 2,      8 0 2,      4 0 2,      2 0 2,

: fexp
        0.0e flocal fx
        fdup f0< >r fabs fdup fln2 f/ f>s >r fln2 fmod 16 0
        do      begin   fdup i lntab []float f@ f>
                while   i lntab []float f@ f- 1.0e fx f+ i fshr +to fx
                repeat
        loop
        fdrop fx 1.0e f+ r> fshl r>
        if      1.0e fswap f/
        then ;
        ans

: fln
        0.0e flocal fx
        fdup f0> invert
        if      fdrop maxfloat exit
        then
        0 >r
        begin   fdup 1.0e f<
        while   f2* r> 1- >r
        repeat
        begin   fdup 2.0e f< invert
        while   f2/ r> 1+ >r
        repeat
        1.0e f- to fx fln2 16 0
        do      begin   fx 1.0e f+ i fshr fx f+ fdup 1.0e f<
                while   to fx i lntab []float f@ f-
                repeat
                fdrop
        loop
        r> s>f fln2 f* f+ ;
        ans

: f**
        fswap fln f* fexp ;
        ans

: falog
        fln10 f* fexp ;
        ans

: flog
        fln fln10 f/ ;
        ans

deprive

base !

                            \ (* End of Source *) /
