\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's 
\ DESCRIPTION : Expert system 
\ CATEGORY    : Utilities 
\ AUTHOR      : Coos Haak 
\ LAST CHANGE : May 16, 1994, Coos Haak 
\ ----------------------------------------------------------------------



        NEEDS -classes

        MARKER -expert



DOC
   Een expertsysteem met classes, zie FD XI, 2 pag 23
ENDDOC

: j/n
        false local vlag false local antwoord
        begin   ?at key dup emit >upc dup 'J' = over 'N' = or to vlag
                'J' = to antwoord vlag invert
        while   at-xy
        repeat
        2drop space antwoord
        ;

class row
        128 constant maxarr     private
        maxarr var data         private

        : adres
                abs maxarr 1- min data +
                ;  private

        : b>s
                dup $80 and
                if      $FF00 or
                then
                ;  private

        : init
                data maxarr erase
                ;

        : get
                adres c@ b>s
                ;

        : put
                adres c!
                ;
endclass

row flags

variable nq

class string
        int thestr      private

        : get
                thestr @ count
                ;

        : put
                thestr !
                ;
endclass

: $,
        '"' parse 2drop ",
        ;

class question
        int nummer      private
        string vraag    private

        : init
                here $, vraag put nq @ nummer ! nq incr
                ;

        : ?
                nummer @ flags get ?dup
                if      1+
                else    cr vraag get type j/n dup 1- nummer @ flags put
                then
                ;
endclass

class rule
        int proc        private
        string uitvoer  private

        : init
                proc ! here $, uitvoer put
                ;

        : !
                proc @ execute
                if      cr uitvoer get type r>drop
                then
                ;
endclass

: setup
        flags init
        ;

: newsystem
        nq off
        ;

' :noname alias {
' ;     alias   }       compile-only    immediate

: |         ( x -- | true )
        if      true r>drop
        then
    ;  compile-only

: &         ( x -- | false )
        0=
        if      false r>drop
        then
    ;  compile-only

                            \ (* End of Source *) /
