\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's 
\ DESCRIPTION : Environment strings in ANS Forth 
\ CATEGORY    : Verification, extension of the kernel 
\ AUTHOR      : Coos Haak 
\ LAST CHANGE : February 04, 1994, Coos Haak 
\ ----------------------------------------------------------------------



        MARKER -environ



DOC
\ 
\ All environment strings mentioned in dpANS 6 are defined.
\ BLOCK and BLOCK-EXT exist, but their value is false because they
\ are not fully implemented.
\ 
ENDDOC




warning @ warning off

get only set-current

also internal

wordlist constant environment-wordlist

environment-wordlist set-current

\ ANS
#255            constant /counted-string
#80             constant /hold
#256            constant /pad
8               constant address-unit-bits
true            constant core
true            constant core-ext
false           constant floored
$FF             constant max-char
#2147483647.    2constant max-d
#32767          constant max-n
$FFFF           constant max-u
$FFFFFFFF.      2constant max-ud
rp0 #cells #8 - constant return-stack-cells
sp0 rp0 - #cells #16 - constant stack-cells
false           value block
false           value block-ext
true            constant double
true            constant double-ext
true            constant exception
true            constant exception-ext
true            constant facility
true            constant facility-ext
true            constant file
true            constant file-ext
#256            constant #locals
true            constant locals
true            constant locals-ext
                        ( floating )
                        ( floating-ext )
                        ( max-float )
false           value memory-alloc
false           value memory-alloc-ext
true            constant tools
true            constant tools-ext
true            constant search-order
true            constant search-order-ext
#vocs           constant wordlists
true            constant string
true            constant string-ext

\ non-ANS
version         constant ver
true            constant chforth
lsp0 sp0 - #cells #16 - constant local-stack-cells
: /data-space unused #cells ;
true            constant error-handling-ext
true            constant error-handling

forth definitions

: environment?
        environment-wordlist search-wordlist
        if      execute true
        else    false
        then ;
        ans

warning !

previous
                            \ (* End of Source *) /
