\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's 
\ DESCRIPTION : Editor interface 
\ CATEGORY    : Utilities 
\ AUTHOR      : Coos Haak 
\ LAST CHANGE : May 16, 1994, Coos Haak 
\ ----------------------------------------------------------------------



        NEEDS -screensv

        MARKER -editor


privates

create cmdbuf       ( -- c-addr )       private \ place for command string
       here #64 dup allot erase

: (edit)            ( -- )                      \ execute command string
        ?at 2>r save-screen getmode >r 3 setmode        \ set text mode
        cmdbuf count system                             \ call editor
        r> setmode restore-screen 2r> at-xy             \ restore screen mode
        ;   private

: libname           ( "name" -- )                       \ prepare filename
        libpath count cmdbuf append                     \ prepare path
        '\' cmdbuf append-char                          \ place backslash
        bl word count cmdbuf append                     \ append filename
        cmdbuf count '.' scan nip 0=                    \ if needed,
        if      fext$ count cmdbuf append               \ append extension
        then
        ;  private

: helpname          ( "name" -- )                       \ prepare filename
        helppath count cmdbuf append                    \ prepare path
        '\' cmdbuf append-char                          \ place backslash
        bl word count cmdbuf append                     \ append filename
        cmdbuf count '.' scan nip 0=                    \ if needed,
        if      hext$ count cmdbuf append               \ append extension
        then
        ;  private

?def ne [if]

\G Skip leading space delimiters. Parse name delimited by a space.
\G Open file name with the editor program and place the cursor at
\G line u. When name is omitted, the last opened file by this
\G command or EDIT LIST or WHAT is opened and name is displayed on
\G the right of the status line. The default extension is taken from
\G FEXT$ .
: ,EDIT         ( u "name" -- )                         \ EDITOR
        s" NE " cmdbuf place                            \ start command line
        ?dup                                            \ not first line?
        if      push base decimal                       \ save
                u>d <# bl hold #s '+' hold #>           \ convert to string
                pop base                                \ restore
                cmdbuf append                           \ append "+x"
        then
        getname cmdbuf append                           \ append name
        (edit)                                          \ execute
        ;

\G Skip leading space delimiters. Parse name delimited by a space.
\G Open file name in the directory given in LIBPATH with the editor
\G program and place the cursor at the first line. The default
\G extension is taken from FEXT$ .
: EDLIB         ( "name" -- )                           \ EDITOR
        s" NE " cmdbuf place                            \ start command line
        libname                                         \ append full filename
        (edit)                                          \ execute
        ;

[else]

: ,EDIT         ( u "name" -- )                         \ EDITOR
        s" SZ " cmdbuf place                            \ start command line
        getname cmdbuf append                           \ append name
        ?dup                                            \ not first line?
        if      push base decimal                       \ save
                u>d <# #s bl hold #>                    \ convert to string
                pop base                                \ restore
                cmdbuf append                           \ append " xxx"
        then
        (edit)                                          \ execute
        ;

: EDLIB         ( "name" -- )                           \ EDITOR
        s" SZ " cmdbuf place                            \ start command line
        libname                                         \ append full filename
        (edit)                                          \ execute
        ;

[then]

\G Skip leading space delimiters. Parse name delimited by a space.
\G Open file name with the editor program and place the cursor at
\G the first line. When name is omitted, the last opened file by
\G this command or ,EDIT LIST or WHAT is opened and name is
\G displayed on the right of the status line. The default extension
\G is taken from FEXT$ .
: EDIT          ( "name" -- )                           \ EDITOR
        0 ,edit                                         \ start at first line
        ;

\G Open file name with the editor program and place the cursor at
\G the line number stored in ERRLINE . name is stored at the address
\G stored in ERRNAME . ERRNAME and ERRLINE are valid after an
\G exception that occured during loading of file name. name is
\G displayed on the right of the status line.
: WHAT          ( -- )                                  \ EDITOR
        errname @
        if      errname @ count thefile place errline @ ,edit
        then ;

?def l [if]

\G Skip leading space delimiters. Parse name delimited by a space.
\G Open file name with list program. When name is omitted, the last
\G opened file by this command or ,EDIT EDIT or WHAT is opened and
\G name is displayed on the right of the status line. The default
\G extension is taken from FEXT$ .
: SHOW          ( "name" -- )                           \ EDITOR
        [ ' l >body count ] sliteral cmdbuf place
        bl cmdbuf append-char                           \ Insert a space
        getname cmdbuf append (edit) ;

\G Skip leading space delimiters. Parse name delimited by a space.
\G Open file name in the directory given in LIBPATH with the list
\G program. The default extension is taken from FEXT$ .
: SHOWLIB       ( "name" -- )                           \ EDITOR
        [ ' l >body count ] sliteral cmdbuf place
        bl cmdbuf append-char                           \ Insert a space
        libname                                         \ append full filename
        (edit)
        ;

\G Skip leading space delimiters. Parse name delimited by a space.
\G Open file name in the directory given in HELPPATH with the list
\G program. The default extension is taken from HEXT$ .
: SHOWHELP      ( "name" -- )                           \ EDITOR
        [ ' l >body count ] sliteral cmdbuf place
        bl cmdbuf append-char                           \ Insert a space
        helpname                                        \ append full filename
        (edit)
        ;

[then]

deprive
                            \ (* End of Source *) /
