\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's 
\ DESCRIPTION : A clock in the upper right corner of the screen 
\ CATEGORY    : Utilities 
\ AUTHOR      : Coos Haak 
\ LAST CHANGE : May 16, 1994, Coos Haak 
\ ----------------------------------------------------------------------


        NEEDS -assembler
        NEEDS -intvec

        MARKER -clock

DOC
   CLOCKON  puts a digital clock in the corner of the screen.
   CLOCKOFF switches it off.
ENDDOC

internal also extra definitions

privates

$1C intvec clk.int      private

variable clocktext      private

$123A dup , dup , dup , dup , dup , dup , dup , ,       -- color
$013A dup , dup , dup , dup , dup , dup , dup , ,       -- monochrome

create counter 3 ,      private

code handler
                pushf
                dec     cs: counter
                jnz     0 $
$if386
                pusha
$else
                push    ax
                push    bx
                push    cx
                push    dx
                push    si
                push    di
$then
                push    ds
                push    es
                mov     ax, cs
                mov     ds, ax
                mov     counter # #18
                mov     ah, # 2
                int     $1A
                mov     si, clocktext
                mov     al, ch
                aam     # $10
                add     ax, # $3030
                mov     0 [si], ah
                mov     2 [si], al
                mov     al, cl
                aam     # $10
                add     ax, # $3030
                mov     6 [si], ah
                mov     8 [si], al
                mov     al, dh
                aam     # $10
                add     ax, # $3030
                mov     #12 [si], ah
                mov     #14 [si], al
                cld
                mov     es, ' sbase >body
                mov     di, adr c/l
                sub     di, # 8
                shl     di, # 1
                mov     cx, # 8
                rep     movsw
                pop     es
                pop     ds
$if386
                popa
$else
                pop     di
                pop     si
                pop     dx
                pop     cx
                pop     bx
                pop     ax
$then
        0 $:    popf
\               jmp     far clk.int             \ Dit mag eigenlijk niet
                jmp     far cs: adr clk.int []  \ Dit kan altijd
end-code  private

\G Display a clock in the upper right corner of the screen.
: CLOCKON               ( -- )                          \ CLOCK
        ['] handler to clk.int
        ;

\G Do not show a clock on the screen.
: CLOCKOFF              ( -- )                          \ CLOCK
        clear clk.int
        ;

:noname
        chain start
        $1C get-interrupt adr clk.int 2!
        getmode 7 =
        if      [ clocktext 9 cells + ] literal
        else    [ clocktext cell+ ] literal
        then
        clocktext ! clockon
        ;  is start

getmode 7 = [if]
        clocktext 9 cells +
[else]
        clocktext cell+
[then]
        clocktext !

deprive

previous forth definitions

                            \ (* End of Source *) /
