\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's 
\ DESCRIPTION : Arrays in Object Oriented Forth 
\ CATEGORY    : Utilities 
\ AUTHOR      : Coos Haak 
\ LAST CHANGE : May 16, 1994, Coos Haak 
\ ----------------------------------------------------------------------


        NEEDS -classes


        MARKER -classarr


warning off

class array
        1 cells var .seg        private
        1 cells var .par        private
        1 cells var .max        private
        : dealloc .seg @ 0=
                if      exit
                then
                .seg @ dealloc abort" can't clear array"
                .seg off .par off .max off ;
        : realloc cells #paragraphs dup .seg @ realloc
                if      dup alloc abort" can't resize array"
                        >r .seg @ r@ .par @ movep dealloc r> .seg !
                then
                dup .par ! paragraphs #cells .max ! ;     private
        : at dup .max @ u< invert
                if      dup 1+ realloc
                then
                cells .seg @ swap ;     private
        : size .max @ ;
        : @ at @x ;
        : ! at !x ;
        : +! at +!x ;
endclass

class 2array
        1 cells var .seg        private
        1 cells var .par        private
        1 cells var .max        private
        : dealloc .seg @ 0=
                if      exit
                then
                .seg @ dealloc abort" can't clear array"
                .seg off .par off .max off ;
        : realloc 2* cells #paragraphs dup .seg @ realloc
                if      dup alloc abort" can't resize array"
                        >r .seg @ r@ .par @ movep dealloc r> .seg !
                then
                dup .par ! paragraphs #cells u2/ .max ! ; private
        : at dup .max @ u< invert
                if      dup 1+ realloc
                then
                2* cells .seg @ swap ;  private
        : size .max @ ;
        : @ at 2@x ;
        : ! at 2!x ;
        : +! at d+!x ;
endclass

?def floats [if]
        1 floats 4 = [if]
                ' 2array alias farray
        [then]
[then]

warning on
                            \ (* End of Source *) /
