\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's 
\ DESCRIPTION : Buffered character input and output 
\ CATEGORY    : Utilities 
\ AUTHOR      : Coos Haak 
\ LAST CHANGE : May 16, 1994, Coos Haak 
\ ----------------------------------------------------------------------


        MARKER -cio


variable mill   mill off                        \ optional keep spectator busy

privates

variable counter-1      private
variable counter-2      private
4 constant kb   private
kb #1024 * constant /charbuffer private

: show-1        ( -- )                                  \ input file show
        push base decimal ?at
        counter-1 incr counter-1 @ kb * 5 .r
        at-xy
        pop base
        ;  private

: show-2        ( -- )                                  \ output file show
        push base decimal ?at over 5 + over at-xy
        counter-2 incr counter-2 @ kb * 5 .r
        #100 counter-1 @ counter-2 @ min counter-1 @ counter-2 @ max */
        4 u.r '%' emit
        at-xy
        pop base
        ;  private

variable inptr  private
variable outptr private
variable input  private         input off
variable output private         output off
variable read-in        private
create inbuffer     /charbuffer allot   private
create outbuffer    /charbuffer allot   private

: flush-output      ( -- )                              \ Write pending output
        mill @
        if      show-2
        then
        outbuffer outptr @ output @ write-file throw outptr off
    ;  private

: getch         ( -- char | true )                      \ Read one character
        read-in @ inptr @ =                             \ End of file: -1
        if      mill @
                if      show-1
                then
                inptr off
                inbuffer /charbuffer input @ read-file throw
                dup read-in ! 0= ?dup
                if      exit
                then
        then
        inbuffer inptr @ + c@ inptr incr
    ;

\ Name c-addr u, return n1 time, n2 date and ud file-size.
: openr         ( c-addr u -- n1 n2 ud )                \ Open input file
        input @ abort" already an inputfile open"
        counter-1 off inptr off read-in off
        r/o bin open-file throw input !
        input @ get-file-time throw
        input @ file-size throw
    ;

: closer        ( -- )                                  \ Close input file
        input @ close-file throw input off
    ;

: putch         ( char -- )                             \ Write one character
        outptr @ /charbuffer =
        if      flush-output
        then
        outbuffer outptr @ + c! outptr incr
    ;

: openw         ( c-addr u -- )                         \ Open output file
        output @ abort" already an outputfile open"
        counter-2 off outptr off
        w/o bin create-file throw output !
    ;

\ Set n1 time and n2 date, close output file
: closew        ( n1 n2 -- )                            \ Close output file
        flush-output
        output @ set-file-time throw
        output @ close-file throw
        output off
    ;

deprive
                            \ (* End of Source *) /
