\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's 
\ DESCRIPTION : Bit manipulation 
\ CATEGORY    : Utilities 
\ AUTHOR      : Coos Haak 
\ LAST CHANGE : May 16, 1994, Coos Haak 
\ ----------------------------------------------------------------------


        MARKER -bits


extra definitions

?def assembler [if]

\G Set bit n on addr to one. If the value of n lies outside the
\G number of bits in a cell, the address is extended to the adjacent
\G memory.
CODE SETBIT     ( n addr -- )                           \ BITS
$IF386
                POP     CX
                BTS     0 [BX], CX
$ELSE
                POP     DI
                MOV     CX, DI
                AND     CL, # 7
                MOV     AL, # 1
                ROL     AL, CL
                MOV     CL, # 3
                SAR     DI, CL
                OR      0 [BX+DI], AL
$THEN
                POP     BX
                NEXT
END-CODE

\G Set bit n on addr to zero. If the value of n lies outside the
\G number of bits in a cell, the address is extended to the adjacent
\G memory.
CODE CLEARBIT     ( n addr -- )                         \ BITS
$IF386
                POP     CX
                BTR     0 [BX], CX
$ELSE
                POP     DI
                MOV     CX, DI
                AND     CL, # 7
                MOV     AL, # FE
                ROL     AL, CL
                MOV     CL, # 3
                SAR     DI, CL
                AND     0 [BX+DI], AL
$THEN
                POP     BX
                NEXT
END-CODE

\G Set bit n on addr to its complement. If the value of n lies
\G outside the number of bits in a cell, the address is extended to
\G the adjacent memory.
CODE CHANGEBIT  ( n addr -- )                           \ BITS
$IF386
                POP     CX
                BTC     0 [BX], CX
$ELSE
                POP     DI
                MOV     CX, DI
                AND     CL, # 7
                MOV     AL, # 1
                ROL     AL, CL
                MOV     CL, # 3
                SAR     DI, CL
                XOR     0 [BX+DI], AL
$THEN
                POP     BX
                NEXT
END-CODE

\G Flag is true if and only if bit n on addr is one. If the value of
\G n lies outside the number of bits in a cell, the address is
\G extended to the adjacent memory.
CODE TESTBIT     ( n addr -- flag )                     \ BITS
$IF386
                POP     CX
                BT      0 [BX], CX
                SBB     BX, BX
$ELSE
                POP     DI
                MOV     CX, DI
                AND     CL, # 7
                MOV     AL, # 1
                ROL     AL, CL
                MOV     CL, # 3
                SAR     DI, CL
                AND     AL, 0 [BX+DI]
                MOV     BX, # 0
        0<> IF
                DEC     BX
        THEN
$THEN
                NEXT
END-CODE

code ctoggle            ( char addr -- )                \ flip bits
                pop     ax
                xor     0 [bx], al
                pop     bx
                next
end-code

code cset               ( char addr -- )                \ set bits
                pop     ax
                or      0 [bx], al
                pop     bx
                next
end-code

code creset             ( char addr -- )                \ clear bits
                pop     ax
                not     al
                and     0 [bx], al
                pop     bx
                next
end-code

[else]

INTERNAL ALSO DEFINITIONS

: BITPATTERN    ( n addr1 -- addr2 mask )
        SWAP S>D $10 FM/MOD ROT []CELL 1 ROT LSHIFT
    ;

EXTRA DEFINITIONS

: SETBIT        ( n addr -- )
        BITPATTERN OVER @ OR SWAP !
    ;

: CLEARBIT      ( n addr -- )
        BITPATTERN INVERT OVER @ AND SWAP !
    ;

: CHANGEBIT     ( n addr -- )
        BITPATTERN OVER @ XOR SWAP !
    ;

: TESTBIT       ( n addr -- )
        BITPATTERN SWAP @ AND 0<>
    ;

PREVIOUS

EXTRA DEFINITIONS

\G Complement the bits at c-addr that correspond with ones in char.
: CTOGGLE       ( char c-addr -- )                      \ BITS
        dup c@ rot xor swap c!
        ;

\G Set the bits at c-addr that correspond with ones in char.
: CSET          ( char c-addr -- )                      \ BITS
        dup c@ rot or swap c!
        ;

\G Clear the bits at c-addr that correspond with ones in char.
: CRESET        ( char c-addr -- )                      \ BITS
        dup c@ rot invert and swap c!
        ;

[then]

forth definitions

                            \ (* End of Source *) /
