\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's 
\ DESCRIPTION : Arrays with memory allocation by MS-DOS 
\ CATEGORY    : Utilities 
\ AUTHOR      : Coos Haak 
\ LAST CHANGE : May 16, 1994, Coos Haak 
\ ----------------------------------------------------------------------


        NEEDS -paragraphs


        MARKER -arrays


prefix reset

: 0!x
        0 -rot !x
        ;

: d0!x
        0. 2swap 2!x
        ;

privates

: double+
        cell+ cell+
        ;

: (clear-array)
        local pointer
        pointer @
        if      pointer @ dealloc abort" can't clear array"
                pointer 3 cells erase
        then
        ;  private

: (realloc)
        local pointer
        cells #paragraphs dup pointer @ realloc
        if      dup alloc abort" can't make array longer"
                pointer @ over pointer cell+ @ movep pointer (clear-array)
                pointer !
        then
        dup pointer cell+ ! paragraphs #cells pointer double+ !
        ;  private

: (adres)
        local pointer
        dup pointer double+ @ u< invert
        if      dup 1+ pointer (realloc)
        then
        cells pointer @ swap
        ;  private

: array
        create  0 , 0 , 0 ,
        does>   (adres) @x
        ;

' (clear-array) is-forget array

methods array

: to
        postpone literal postpone (adres) postpone !x
        ;

: +to
        postpone literal postpone (adres) postpone +!x
        ;

: clear
        postpone literal postpone (adres) postpone 0!x
        ;

: reset
        postpone literal postpone (clear-array)
        ;

end-methods

: (2realloc)
        local pointer
        2* cells #paragraphs dup pointer @ realloc
        if      dup alloc abort" can't make array longer"
                pointer @ over pointer cell+ @ movep pointer (clear-array)
                pointer !
        then
        dup pointer cell+ ! paragraphs #cells u2/ pointer double+ !
        ;  private

: (2adres)
        local pointer
        dup pointer double+ @ u< invert
        if      dup 1+ pointer (2realloc)
        then
        2* cells pointer @ swap
        ;  private

: 2array
        create  0 , 0 , 0 ,
        does>   (2adres) 2@x
        ;

' (clear-array) is-forget 2array

methods 2array

: to
        postpone literal postpone (2adres) postpone 2!x
        ;

: +to
        postpone literal postpone (2adres) postpone d+!x
        ;

: clear
        postpone literal postpone (2adres) postpone d0!x
        ;

: reset
        postpone literal postpone (clear-array)
        ;

end-methods

: (crealloc)
        local pointer
        #paragraphs dup pointer @ realloc
        if      dup alloc abort" can't make array longer"
                pointer @ over pointer cell+ @ movep pointer (clear-array)
                pointer !
        then
        dup pointer cell+ ! paragraphs pointer double+ !
        ;  private

: (cadres)
        local pointer
        dup pointer double+ @ u< invert
        if      dup 1+ pointer (crealloc)
        then
        pointer @ swap
        ;  private

: c0!x
        0 -rot c!x
        ;

: carray
        create  0 , 0 , 0 ,
        does>   (cadres) c@x
        ;

' (clear-array) is-forget carray

methods carray

: to
        postpone literal postpone (cadres) postpone c!x
        ;

: +to
        postpone literal postpone (cadres) postpone c+!x
        ;

: clear
        postpone literal postpone (cadres) postpone c0!x
        ;

: reset
        postpone literal postpone (clear-array)
        ;

end-methods

' 2array alias darray

?def floats [if]
1 floats 4 = [if]
' 2array alias farray
[then]
[then]

deprive
                            \ (* End of Source *) /
