\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's 
\ DESCRIPTION : Arrays with memory allocation in code/data segment 
\ CATEGORY    : Utilities 
\ AUTHOR      : Coos Haak 
\ LAST CHANGE : May 16, 1994, Coos Haak 
\ ----------------------------------------------------------------------


        NEEDS -memory

        MARKER -array


privates

: cindex
        @ @ +
        ;  private

: resize-carray
        dup @ rot resize ?allocate swap !
        ;  private

prefix newsize

: carray
        create  dup allocate ?allocate dup , @ swap erase
        does>   cindex c@
        ;

:noname
        @ free ?allocate
    ;  is-forget carray

methods carray

: to
        postpone literal postpone cindex postpone c!
        ;

: +to
        postpone literal postpone cindex postpone c+!
        ;

: clear
        postpone literal postpone cindex postpone c0!
        ;

: newsize
        postpone literal postpone resize-carray
        ;

end-methods

: index
        @ @ []cell
        ;  private

: resize-array
        dup @ rot cells resize ?allocate swap !
        ;  private

: array
        create  cells dup allocate ?allocate dup , @ swap erase
        does>   index @
        ;

:noname
        @ free ?allocate
    ;  is-forget array

methods array

: to
        postpone literal postpone index postpone !
        ;

: +to
        postpone literal postpone index postpone +!
        ;

: clear
        postpone literal postpone index postpone off
        ;

: newsize
        postpone literal postpone resize-array
        ;

end-methods

: 2index
        @ @ []double
        ;  private

: resize-2array
        dup @ rot cells 2* resize ?allocate swap !
        ;  private

: 2array
        create  2* cells dup allocate ?allocate dup , @ swap erase
        does>   cindex 2@
        ;

:noname
        @ free ?allocate
    ;  is-forget 2array

methods 2array

: to
        postpone literal postpone 2index postpone 2!
        ;

: +to
        postpone literal postpone 2index postpone d+!
        ;

: clear
        postpone literal postpone 2index postpone d0!
        ;

: newsize
        postpone literal postpone resize-2array
        ;

end-methods

deprive

?def floats [if]
1 floats 4 = [if]
' 2array alias farray
[then]
[then]

                            \ (* End of Source *) /
