\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's 
\ DESCRIPTION : RCA Cosmac 1802 assembler, disassembler and emulator 
\ CATEGORY    : Simulation 
\ AUTHOR      : Coos Haak 
\ LAST CHANGE : May 16, 1994, Coos Haak 
\ ----------------------------------------------------------------------


        NEEDS -paragraphs

        NEEDS -stack

        MARKER -1802lib


warning off

hex

' or alias or'
' and alias and'
' xor alias xor'

1000 segment trgseg

: ts:
        trgseg @ swap ;

: c@-t
        ts: c@x ;

: c!-t
        ts: c!x ;

: @-t
        dup 1+ c@-t swap c@-t join ;

: !-t
        >r split r@ c!-t r> 1+ c!-t ;

: dump-t
        bounds 0 local counter
        ?do     cr i h. space i 10 bounds
                do      i c@-t b. counter 1+ dup to counter 3 and' 0=
                        if      space
                        then
                loop
                trgseg @ i 10 stypex stop? ?leave
        10 +loop
        ;

0 value adres

0 constant dma:
1 constant int:
2 constant rp:
3 constant sp:
4 constant pc:
5 constant ip:
6 constant nxt:
7 constant nst:
8 constant jsr:
9 constant rts:
A constant tmp:

variable symbolic       symbolic on

vector .label   ' noop is .label
vector label?   ' false is label?

vocabulary 1802dis

1802dis definitions

: nextb
        adres c@-t 1 +to adres ;

: shortlabel
        adres c@-t adres $FF00 and or label?
        if      adres c@-t adres $FF00 and or .label
        else    adres c@-t b.
        then
        1 +to adres ;

: nextw
        adres @-t 2 +to adres ;

: longlabel
        adres @-t label?
        if      adres @-t .label
        else    adres @-t h.
        then
        2 +to adres ;

: name
        F and' symbolic @
        if  case
                dma: of ." DMA" endof
                int: of ." INT" endof
                rp: of  ." RP " endof
                sp: of  ." SP " endof
                pc: of  ." PC " endof
                ip: of  ." IP " endof
                nxt: of ." NXT" endof
                nst: of ." NST" endof
                jsr: of ." JSR" endof
                rts: of ." RTS" endof
                tmp: of ." TMP" endof
                dup push base hex . space pop base
            endcase
        else    'R' emit dup 9 >
                if      7 +
                then
                '0' + emit space space
        then
    ;

: self.l
        create
        does>   body> >head (.head) tuck type 8 swap - spaces ;

: .self
        create
        does>   body> >head .head ;

: .inlb
        nextb b. ;

.self ???

self.l br       self.l bq       self.l bz       self.l bdf
self.l b1       self.l b2       self.l b3       self.l b4
.self skp       self.l bnq      self.l bnz      self.l bnf
self.l bn1      self.l bn2      self.l bn3      self.l bn4

: .br
        F &exec:
        br bq bz bdf b1 b2 b3 b4 noop bnq bnz bnf bn1 bn2 bn3 bn4 ;

: 30s
        dup 8 =
        if      drop skp exit
        then
        .br shortlabel ;

.self irx       self.l out      self.l inp

: 60s
        dup 0=
        if      drop irx exit
        then
        dup 1 8 within
        if      out . exit
        then
        dup 8 >
        if      inp 7 and' . exit
        then
        drop ??? ;

.self ret       .self dis       .self ldxa      .self stxd
.self adc       .self sdb       .self shrc      .self smb
.self sav       .self mark      .self req       .self seq
self.l adci     self.l sdbi     .self shlc      self.l smbi

: 70s
        case
                0 of    ret     endof
                1 of    dis     endof
                2 of    ldxa    endof
                3 of    stxd    endof
                4 of    adc     endof
                5 of    sdb     endof
                6 of    shrc    endof
                7 of    smb     endof
                8 of    sav     endof
                9 of    mark    endof
                0A of   req     endof
                0B of   seq     endof
                0C of   adci nextb b.   endof
                0D of   sdbi nextb b.   endof
                0E of   shlc    endof
                0F of   smbi nextb b.   endof
        endcase ;

self.l lbr      self.l lbq      self.l lbz      self.l lbdf
.self nop       .self lsnq      .self lsnz      .self lsnf
self.l lskp     self.l lbnq     self.l lbnz     self.l lbnf
.self lsie      .self lsq       .self lsz       .self lsdf

: c0s
        case
                0 of    lbr longlabel   endof
                1 of    lbq longlabel   endof
                2 of    lbz longlabel   endof
                3 of    lbdf longlabel  endof
                4 of    nop     endof
                5 of    lsnq    endof
                6 of    lsnz    endof
                7 of    lsnf    endof
                8 of    lskp    endof
                9 of    lbnq longlabel  endof
                0A of   lbnz longlabel  endof
                0B of   lbnf longlabel  endof
                0C of   lsie    endof
                0D of   lsq     endof
                0E of   lsz     endof
                0F of   lsdf    endof
        endcase ;

self.l jsr      .self rts       self.l sep

: d0s
        symbolic @
        if      dup jsr: =
                if      drop jsr longlabel exit
                then
                dup rts: =
                if      drop rts exit
                then
        then
        sep name
    ;

.self ldx       .self or        .self and       .self xor
.self add       .self sd        .self shr       .self sm
self.l ldi      self.l ori      self.l ani      self.l xri
self.l adi      self.l sdi      .self shl       self.l smi

: f0s
        case
                0 of    ldx     endof
                1 of    or      endof
                2 of    and     endof
                3 of    xor     endof
                4 of    add     endof
                5 of    sd      endof
                6 of    shr     endof
                7 of    sm      endof
                8 of    ldi nextb b.    endof
                9 of    ori nextb b.    endof
                0A of   ani nextb b.    endof
                0B of   xri nextb b.    endof
                0C of   adi nextb b.    endof
                0D of   sdi nextb b.    endof
                0E of   shl     endof
                0F of   smi nextb b.    endof
        endcase ;

.self idl       self.l ldn
self.l inc      self.l dec
self.l lda      self.l str
self.l glo      self.l ghi      self.l plo      self.l phi
self.l sex

forth definitions

: .inst
        [ 1802dis ]
        cr adres h. space adres label?
        if      adres .label
        then
        #16 htab adres >r nextb 10 /mod
        case
                0 of    ?dup
                        if      ldn name
                        else    idl
                        then    endof
                1 of    inc name        endof
                2 of    dec name        endof
                3 of    30s     endof
                4 of    lda name        endof
                5 of    str name        endof
                6 of    60s     endof
                7 of    70s     endof
                8 of    glo name        endof
                9 of    ghi name        endof
                0A of   plo name        endof
                0B of   phi name        endof
                0C of   c0s     endof
                0D of   d0s             endof
                0E of   sex name        endof
                0F of   f0s     endof
        endcase
        #40 htab r> adres over - 2dup bounds
        do      i c@-t b.
        loop
        space trgseg @ -rot #64 htab stypex space
        eol ;   forth

: disasm
        to adres
        begin   .inst key ^[ =
        until ;

vocabulary 1802sim

1802sim definitions

: array
        create  0
                do      random ,
                loop
        does>   []cell @ ;

methods array

: to
        postpone literal postpone []cell postpone !
        ;

: +to
        postpone literal postpone []cell postpone +!
        ;

: clear
        postpone literal postpone []cell postpone off
        ;

end-methods

: 4bit
        create  random c,
        does>   c@ $F and' ;

methods 4bit

: to
        postpone literal postpone c!
        ;

: +to
        postpone literal postpone c+!
        ;

: clear
        postpone literal postpone c0!
        ;

end-methods

: byte
        create  random c,
        does>   c@ ;

inherit 4bit byte

: 1bit
        create  random ,
        does>   @ 1 and' ;

methods 1bit

: to
        postpone 0<> postpone literal postpone !
        ;

: set
        postpone literal postpone on
        ;

: clear
        postpone literal postpone off
        ;

end-methods

prefix set

1bit speed

forth definitions

: slow
        [ 1802sim ] clear speed ;

: fast
        [ 1802sim ] set speed ;

1802sim definitions

byte opcode
10 array regs
4bit p
4bit x
byte t
byte d
1bit df
1bit ie
1bit q
1bit serviced

: mx
        x regs c@-t ;

: mp
        p regs c@-t ;

-- Register Operations

: inc   ( n -- )
        1 swap +to regs ;

: dec   ( n -- )
        -1 swap +to regs ;

: irx
        x inc ;

: glo   ( n -- )
        regs to d ;

: plo   ( n -- )
        d over regs FF00 and' or' swap to regs ;

: ghi   ( n -- )
        regs 8 rshift to d ;

: phi   ( n -- )
        d 8 lshift over regs FF and' or' swap to regs ;

-- Memory Reference

: ldn   ( n -- )
        regs c@-t to d ;

: lda   ( n -- )
        dup ldn inc ;

: ldx
        mx to d ;

: ldxa
        ldx irx ;

: ldi
        mp to d p inc ;

: str   ( n -- )
        d swap regs c!-t ;

: stxd
        x str x dec ;

-- Logic Operation

: or
        mx d or' to d ;

: ori
        mp d or' to d p inc ;

: xor
        mx d xor' to d ;

: xri
        mp d xor' to d p inc ;

: and
        mx d and' to d ;

: ani
        mp d and' to d p inc ;

: shr
        d to df d 2/ to d ;

: shrc
        df d to df flip d or' 2/ to d ;

: shl
        d 2* dup to d flip to df ;

: shlc
        df 7 lshift d 7 rshift to df d flip or' 2* flip to d ;

: add
        mx d + split to df to d ;

: adi
        mp d + split to df to d p inc ;

: adc
        mx d df + + split to df to d ;

: adci
        mp d df + + split to df to d p inc ;

: sd
        mx d - split 1 xor' to df to d ;

: sdi
        mp d - split 1 xor' to df to d p inc ;

: sdb
        mx d - df 1 xor' - split 1 xor' to df to d ;

: sdbi
        mp d - df 1 xor' - split 1 xor' to df to d p inc ;

: sm
        d mx - split 1 xor' to df to d ;

: smi
        d mp - split 1 xor' to df to d p inc ;

: smb
        d mx - df 1 xor' - split 1 xor' to df to d ;

: smbi
        d mp - df 1 xor' - split 1 xor' to df to d p inc ;

-- Branching

: br
        mp p regs FF00 and' or' p to regs ;

: skp
        p inc ;

: !br
        if      br
        else    skp
        then ;

: bz
        d 0= !br ;

: bnz
        d !br ;

: bdf
        df !br ;

: bnf
        df 0= !br ;

: bq
        q !br ;

: bnq
        q 0= !br ;

: b1    true abort" Not implemented" ;

' b1 alias b2
' b1 alias b3
' b1 alias b4
' b1 alias bn1
' b1 alias bn2
' b1 alias bn3
' b1 alias bn4

: lbr
        p regs @-t p to regs ;

: lskp
        2 p +to regs ;

: !lbr
        if      lbr
        else    lskp
        then ;

: lbz
        d 0= !lbr ;

: lbnz
        d !lbr ;

: lbq
        q !lbr ;

: lbnq
        q 0= !lbr ;

: lbdf
        df !lbr ;

: lbnf
        df 0= !lbr ;

: !lskp
        if      lskp
        then ;

: lsz
        d 0= !lskp ;

: lsnz
        d !lskp ;

: lsq
        q !lskp ;

: lsnq
        q 0= !lskp ;

: lsdf
        df !lskp ;

: lsnf
        df 0= !lskp ;

: lsie
        ie !lskp ;

-- Control instructions

: idl
        serviced clear serviced 0=
        if      -1 p +to regs
        then ;

: nop ;

: sep   ( n -- )
        to p ;

: sex   ( n -- )
        to x ;

: seq
        set q [ beepl 4 / ] literal [ beeph 9 * ] literal tone ;

: req
        clear q [ beepl 4 / ] literal [ beeph #11 * ] literal tone ;

-- Interrupt and Subroutine Handling

: sav
        t x regs c!-t ;

: mark
        x 4 lshift p F and' or' dup to t 2 regs c!-t p to x 2 dec ;

: ret
        mx irx dup F and' to p 4 rshift to x set ie ;

: dis
        ret clear ie ;

: out
        mx b. irx ;

: inp
        key 10 digit drop 4 lshift key 10 digit drop or'
        dup x regs c!-t to d ;

-- Pseudo instructions

: jsr
        pc: regs tmp: to regs
        tmp: regs @-t pc: to regs       2 tmp: +to regs
        -2 sp: +to regs         tmp: regs sp: regs !-t ;

: rts
        sp: regs @-t pc: to regs        2 sp: +to regs ;

: fetch
        mp to opcode p inc ;

: onereg
        dup [ 1802dis ] name [ 1802sim ] dup x =
        if      bright 'X' emit bright
        else    space
        then
        dup p =
        if      bright 'P' emit bright
        else    space
        then
        regs ':' emit h. space ;

: .show
        dup push base hex . pop base regs dup h. 10 bounds
        do      i c@-t b.
        loop ;

forth definitions

: reset
        [ 1802sim ]
        clear x clear p clear q set ie 0 clear regs clear serviced ;

: interrupt
        [ 1802sim ]
        ie
        if      x 4 lshift p F and' or' to t
                1 to p 2 to x clear ie set serviced
        then ;

: .regs
        [ 1802sim ]
        cr 10 0
        do      cr i 4 + i
                do      i onereg
                loop
        4 +loop
        cr ." Q=" q . ."  IE=" ie . ."  D=" d b. ."  DF=" df .
        cr ." P =" p .show
        cr ." X =" x .show
        cr ." IP=" ip: .show
        cr ." SP=" sp: .show
        cr ." RP=" rp: .show ;

1802sim definitions

: 30s
        case
                0 of    br      endof
                1 of    bq      endof
                2 of    bz      endof
                3 of    bdf     endof
                4 of    b1      endof
                5 of    b2      endof
                6 of    b3      endof
                7 of    b4      endof
                8 of    skp     endof
                9 of    bnq     endof
                0A of   bnz     endof
                0B of   bnf     endof
                0C of   bn1     endof
                0D of   bn2     endof
                0E of   bn3     endof
                0F of   bn4     endof
        endcase ;

: 60s
        dup 1 8 within
        if      out
        else    dup 8 >
                if      7 and' inp
                else    abort" Not implemented opcode: 68"
                        irx
                then
        then ;

: 70s
        case
                0 of    ret     endof
                1 of    dis     endof
                2 of    ldxa    endof
                3 of    stxd    endof
                4 of    adc     endof
                5 of    sdb     endof
                6 of    shrc    endof
                7 of    smb     endof
                8 of    sav     endof
                9 of    mark    endof
                0A of   req     endof
                0B of   seq     endof
                0C of   adci    endof
                0D of   sdbi    endof
                0E of   shlc    endof
                0F of   smbi    endof
        endcase ;

: c0s
        case
                0 of    lbr     endof
                1 of    lbq     endof
                2 of    lbz     endof
                3 of    lbdf    endof
                4 of    nop     endof
                5 of    lsnq    endof
                6 of    lsnz    endof
                7 of    lsnf    endof
                8 of    lskp    endof
                9 of    lbnq    endof
                0A of   lbnz    endof
                0B of   lbnf    endof
                0C of   lsie    endof
                0D of   lsq     endof
                0E of   lsz     endof
                0F of   lsdf    endof
        endcase ;

: d0s
        speed
        if      dup jsr: =
                if      drop jsr exit
                then
                dup rts: =
                if      drop rts exit
                then
        then
        sep ;

: f0s
        case
                0 of    ldx     endof
                1 of    or      endof
                2 of    and     endof
                3 of    xor     endof
                4 of    add     endof
                5 of    sd      endof
                6 of    shr     endof
                7 of    sm      endof
                8 of    ldi     endof
                9 of    ori     endof
                0A of   ani     endof
                0B of   xri     endof
                0C of   adi     endof
                0D of   sdi     endof
                0E of   shl     endof
                0F of   smi     endof
        endcase ;

: exec
        opcode 10 /mod
        case
                0 of    ?dup
                        if      ldn
                        else    idl
                        then    endof
                1 of    inc     endof
                2 of    dec     endof
                3 of    30s     endof
                4 of    lda     endof
                5 of    str     endof
                6 of    60s     endof
                7 of    70s     endof
                8 of    glo     endof
                9 of    ghi     endof
                0A of   plo     endof
                0B of   phi     endof
                0C of   c0s     endof
                0D of   d0s     endof
                0E of   sex endof
                0F of   f0s     endof
        endcase
        .regs ;

forth definitions

: step
        [ 1802sim ]
        hide-cursor home fetch exec
        p regs to adres #10 0
        do      .inst
        loop
        show-cursor ;   forth

: steps
        0
        ?do     step
        loop ;

: trace
        begin   step key >upc dup 'I' =
                if      interrupt
                then
                ^[ =
        until ;

vocabulary 1802asm

1802asm definitions

create aprior   4 cells allot
' drop aprior !
' drop aprior cell+ cell+ !

: a;!
        aprior cell+ cell+ 2! ;

: clr-a;
        0 ['] drop a;! ;

: a;
        aprior 2@ execute aprior cell+ cell+ 2@ aprior 2! clr-a; ;

0 value here-t

: c,-t
        here-t c!-t 1 +to here-t ;

: ,-t
        here-t !-t 2 +to here-t ;

: (m1)  c@ c,-t ;

: m1
        create  c,
        does>   ['] (m1) a;! a; ;

00 m1 idl       38 m1 skp       60 m1 irx
70 m1 ret       71 m1 dis       72 m1 ldxa      73 m1 stxd
74 m1 adc       75 m1 sdb       76 m1 shrc      77 m1 smb
78 m1 sav       79 m1 mark      7A m1 req       7B m1 seq
7E m1 shlc      C4 m1 nop
C5 m1 lsnq      C6 m1 lsnz      C7 m1 lsnf      C8 m1 lskp
CC m1 lsie      0CD m1 lsq      CE m1 lsz       CF m1 lsdf      D9 m1 rts
F0 m1 ldx       F1 m1 or        F2 m1 and       F3 m1 xor
F4 m1 add       F5 m1 sd        F6 m1 shr       F7 m1 sm
FE m1 shl

: (m2)  c@ c,-t c,-t ;

: m2
        create  c,
        does>   ['] (m2) a;! a; ;

30 m2 br        31 m2 bq        32 m2 bz        33 m2 bdf
34 m2 b1        35 m2 b2        36 m2 b3        37 m2 b4
39 m2 bnq       3A m2 bnz       3B m2 bnf
3C m2 bn1       3D m2 bn2       3E m2 bn3       3F m2 bn4
60 m2 out       68 m2 inp
7C m2 adci      7D m2 sdbi      7F m2 smbi
F8 m2 ldi       F9 m2 ori       FA m2 ani       FB m2 xri
FC m2 adi       FD m2 sdi       FF m2 smi

: (m3)  c@ or' c,-t ;

: m3
        create  c,
        does>   ['] (m3) a;! a; ;

00 m3 ldn       10 m3 inc       20 m3 dec       40 m3 lda       50 m3 str
80 m3 glo       90 m3 ghi       A0 m3 plo       B0 m3 phi
D0 m3 sep       E0 m3 sex

: (m4)  c@ c,-t ,-t ;

: m4
        create  c,
        does>   ['] (m4) a;! a; ;

C0 m4 lbr       C1 m4 lbq       C2 m4 lbz       C3 m4 lbdf
C9 m4 lbnq      CA m4 lbnz      CB m4 lbnf
D8 m4 jsr

: (db)
        drop c,-t ;

: db
        0 ['] (db) a;! a; ;

: (dw)
        drop ,-t ;

: dw
        0 ['] (dw) a;! a; ;

: (ds)
        drop 0
        ?do     count c,-t
        loop    drop ;

: ds
        0 ['] (ds) a;! a; ;

2 cells constant /label
#100 constant #labels

create labels   #labels /label * allot
0 value lastlabel

: []label
        labels swap /label * + ;

:noname
        local x false lastlabel 0
        ?do     i []label @ x =
                if      invert leave
                then
        loop
        ;  is label?

:noname
        lastlabel 0
        ?do     dup i []label @ =
                if      i []label cell+ @ .head leave
                then
        loop
        DROP
        ;  is .label

30 constant never
39 constant q
3A constant 0=
3B constant df

: not
        8 xor' ;

: ?page
        2dup xor' FF00 and' abort" Sprong uit de pagina" ;

: >mark
        here-t >s 0 c,-t ;

: >resolve
        here-t s> ?page c!-t ;

: <mark
        here-t >s ;

: <resolve
        here-t 1+ s> ?page c,-t drop ;

: cs-swap
        s> s> swap >s >s ;

: if
        >r a; r> c,-t >mark ;

: then
        a; >resolve ;

: ahead
        never if ;

: else
        ahead cs-swap then ;

: begin
        a; <mark ;

: until
        >r a; r> c,-t <resolve ;

: again
        never until ;

: while
        if cs-swap ;

: repeat
        again then ;

forth definitions

: clearlabels
        [ 1802asm ] labels #labels /label * erase clear lastlabel ;

: asm:
        [ 1802asm ] 1802asm clr-a; !csp ;

: asm;
        [ 1802asm ] a; forth ?csp ;

: label
        create  [ 1802asm ] a; here-t lastlabel []label ! here body> >head
                lastlabel []label cell+ ! 1 +to lastlabel here-t , asm:
        does>   @ ;

: org
        [ 1802asm ] >r a; r> to here-t asm: ;

: ==
        [ 1802asm ] org label ;

trgseg 2@ swap 0 fillp

forth

warning on
                            \ (* End of Source *) /
