\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's
\ DESCRIPTION : Strings, proposed by Albert van der Horst
\ CATEGORY    : Utilities
\ AUTHOR      : Coos Haak
\ LAST CHANGE : May 16, 1994, Coos Haak
\ ----------------------------------------------------------------------


        ?def niks [if] forget niks [then]


        ?def -horststr [if] -horststr [then]
        MARKER -horststr



DOC
(* See Vijgeblad 32, Autumn 1990 *)
ENDDOC


internal

: niks
        ;

:noname
        drop
        ['] $interpret is 'interpret
        ['] $compile is 'compile
        ;  ' niks >head head>forget h!

: $variable             ( u -- ) ( -- addr )
        create  0 c, allot
        does>
        ;

: $constant             ( c-addr u -- ) ( -- c-addr u )
        create  here pack c@ 1+ allot
        does>   count
        ;

' place         alias $!        ( c-addr u addr -- )
' append        alias $+!       ( c-addr u addr -- )
' count         alias $@        ( addr -- c-addr u )
' type          alias $.        ( c-addr u -- )
' compare       alias $compare  ( c-addr1 u1 c-addr2 u2 -- -1|0|1 )
\ ' s"          alias "         immediate       ( "ccc" -- c-addr u )

: $value
        create  0 c, allot
        does>   count
        ;

methods $value

: to
        postpone literal postpone $!
        ;

: +to
        postpone literal postpone $+!
        ;

: clear
        postpone literal postpone c0!
        ;

end-methods

: $?                    ( addr -- )
        $@ $.
        ;

: $=                    ( c-addr1 u1 c-addr2 u2 -- -1|0 )
        $compare 0=
        ;

: $<=                   ( c-addr1 u1 c-addr2 u2 -- -1|0 )
        $compare 0 > invert
        ;

: $@=                   ( addr1 addr2 -- -1|0 )
        $@ rot $@ $compare
        ;

: strchr                ( c-addr u1 ch -- u2 )
        over >r scan nip r> over
        if      1+ swap -
        else    drop
        then
        ;

: $split                        ( c-addr1 u1 ch -- c-addr2 u2 c-addr3 u3 )
        0 locals| ix char len addr |
        addr len char strchr dup to ix
        if      addr ix 1- addr len ix /string
        else    addr len 0 0
        then
        ;

\ Debugging only:
: SS                    ( c-addr u ch -- )
        DUP>R $SPLIT .S CR 2SWAP '<' EMIT TYPE '>'
        EMIT R> EMIT '<' EMIT TYPE '>' EMIT SPACE
        ;

DOC
(* Change the interpreter *)
(* This could be already present in the kernel *)
ENDDOC

variable port-string    port-string off

123 mess" is in a non-portable string format "

vector string?

: (string?)             ( c-addr1 u1 -- c-addr2 u2 true | false )
        port-string off dup 2 <
        if      2drop false exit
        then
        over c@ '"' = >r 2dup + 1- c@ '"' = r> and
        if      1 /string 1- true
                port-string on
        else    2drop false
        then
        ;

: "interpret
        search-context
        if      ?ansi headflags =comp and #-14 ?error execute exit
        then
        parsed-word string?
        if      ansi @ port-string @ and
                if      123 .mess
                then
                flyer postpone sliteral exit
        then
        parsed-word number? 0= #-13 ?error ?portable
        ;

: "compile
        search-context
        if      ?ansi headflags =immediate and
                if      execute exit
                then
                compile, exit
        then
        parsed-word string?
        if      ansi @ port-string @ and
                if      123 .mess
                then
                postpone sliteral exit
        then
        parsed-word number? ?dup
        if      ?portable postpone literals exit
        then
        #-13 ?crash
        ;

: old
        ['] $interpret is 'interpret
        ['] $compile is 'compile
        ;

: new
        ['] "interpret is 'interpret
        ['] "compile is 'compile
        ;

: (string?)'            ( c-addr1 u1 -- c-addr2 u2 true | false )
        >in @ locals| oldin len adr |
        port-string off len 2 < adr c@ '"' <> or
        if      false exit
        then
        begin   adr len 1- + c@ '"' =
                if      adr 1+ len 2 -
                        true
                        port-string on exit
                then
                >in @ #tib @ <
        while   >in incr 1 +to len
        repeat
        oldin >in ! false
        ;

: small
        ['] (string?) is string?
        ;

: large
        ['] (string?)' is string?
        ;

: help
        >in @ bl parse-word string?
        if      cr '"' emit type '"' emit
                ."  is a non-portable string. " drop exit
        then
        >in ! help
        ;

new large

"dead" "is" "James Brown" 
cr type space type space type

: soulman
        "dead" "is" "James Brown" 
        cr type space type space type
        ;

soulman

old

forth

                            \ (* End of Source *) /
