\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's 
\ DESCRIPTION : Nice graphics bodies 
\ CATEGORY    : Graphics 
\ AUTHOR      : Marcel Hendrix 
\ LAST CHANGE : May 16, 1994, Coos Haak 
\ ----------------------------------------------------------------------



        NEEDS -graphics
        NEEDS -quad
        NEEDS -gonio
        NEEDS -stack

        ?DEF -volumes [IF] -volumes [THEN]


        MARKER -volumes



\ See: Vijgeblad 25


' vres is graphics

absplot

: grhome
        xmax 2/ ymax 2/ moveto ;

64 constant brightness
 1 constant nx
 1 constant ny
 2 constant nz

false value clip

0 value phi

: pseudorandom
        64 choose ;

: ?plot
        if      white
        else    black
        then
        plot ;

: getshade
        >r phi rotate >r >r
        r" dup m* r' dup m* d- r@ dup m* d- sqrt
        nz * r> nx * + r> ny * + brightness r> */
        clip
        if      dup 0<
                if      drop 0
                then
        else    abs
        then ;

: phi!
        360 mod dup 0<
        if      360 +
        then
        to phi ;

DOC
: pseudoplot
        local origineel pseudorandom local gokje
        origineel gokje >
        if      white
        else    origineel gokje 3 / <
                if      black
                else    origineel gokje 2 3 */ <
                        if      col-2
                        else    col-1
                        then
                then
        then
        plot ;

: pseudoplot
        2 rshift (maxc) and to color plot ;

: pseudoplot
        maxc 1+ 2* + (maxc) and to color plot ;
ENDDOC

: pseudoplot
        (maxc) and to color plot ;

: srplt
        getshade >r phi rotate
        ypix + swap xpix + swap xpix ypix 2swap
        r> pseudoplot
        to ypix to xpix ;

: 2plot
        >r >r >r
        2dup swap r' r@ r" srplt
        r> r> r> srplt ;

: 4plot
        >r >r >r 2dup r@ r' r" srplt
        2dup negate r@ r' negate r" srplt
        over negate over r@ negate r' r" srplt
        negate swap negate swap r> negate r> negate r> srplt ;

: 8plot
        >r 2dup 2dup r@ 2plot
        2dup negate 2dup r@ 2plot
        over negate over 2dup r@ 2plot
        negate swap negate swap 2dup r> 2plot ;

: 8plot'
        >r >r >r 2dup r@ r' r" 2plot
        2dup negate r@ r' negate r" 2plot
        over negate over r@ negate r' r" 2plot
        negate swap negate swap r> r> negate r> 2plot ;

: cylinder
        phi! over 0
        do      dup 0
                do      i j 0 j 5 pick 4plot
                loop
        loop
        2drop ;

: sphere
        clear phi dup 13860 19601 */ 0
        do      dup dup um* i dup um* d- sqrt i
                do      j i pluck 8plot #10000 dup /
                +loop
        loop
        drop ;

: toroid
        2dup swap - 2/ >s
        2dup + 2/ >s
        clear phi
        dup 13860 19601 */ 0
        do      dup dup um* i dup um* d- sqrt pluck dup i >
                if      dup um* i dup um* d- sqrt
                else    drop i
                then
                do      j i over dup um* i dup um* d+ sqrt >s
                        j dup t s */ -
                        i dup t s> */ - t
                        8plot'
                loop
        loop
        2drop s>drop s>drop ;

: etoroid
        phi! 2dup swap - 2/ >s
        2dup + 2/ >s
        t 0
        do      t dup um* i dup um* d- sqrt s + 0
                do      j i over t dup um* j dup um* d- sqrt >s
                        i s s> s + */ t 4plot
                loop
        loop
        2drop s>drop s>drop ;

: diabolo
        phi! 2dup swap - 2/ >s
        2dup + 2/ >s
        t 0
        do      s t dup um* i dup um* d- sqrt - >s
                s 0
                do      j i over negate i t s */ i - u 4plot
                loop
                s>drop
        loop
        2drop s>drop s>drop ;

: init
        grhome 90 sphere ;

: demo
        text?
        if      graphics
        then
        grhome
        90 200 0 cylinder
        45 80 90 cylinder
        55 sphere
        65 120 toroid
        4 0
        do      change-colors change-grays
        loop ;

: .help
        cr ." CYLINDER straal lengte hoek"
        cr ." SPHERE straal"
        cr ." TOROID in uit"
        cr ." ETOROID in uit hoek"
        cr ." DIABOLO in uit hoek"
        cr
        ;

.help

                            \ (* End of Source *) /
