\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's 
\ DESCRIPTION : Splines 
\ CATEGORY    : Graphics 
\ AUTHOR      : Coos Haak 
\ LAST CHANGE : May 16, 1994, Coos Haak 
\ ----------------------------------------------------------------------



        NEEDS -dvalues
        NEEDS -graphics
        NEEDS -peripher

        ?DEF -splines [IF] -splines [THEN]

        MARKER -splines



DOC
   Vijgeblad 43, from ForthWrite, FIGUK
ENDDOC

' line alias draw-line

0 value level
0 value l_max
0. dvalue a0
0. dvalue a1
0. dvalue a2
0. dvalue a3
0. dvalue b0
0. dvalue b1
0. dvalue b2
0. dvalue c0
0. dvalue c1
0. dvalue d0

: loada
        to a3 to a2 to a1 to a0 ;

: mean
        rot + 2/ >r + 2/ r> ;

: mid_pts
        a0 a1 mean to b0
        a1 a2 mean to b1
        a2 a3 mean to b2
        b0 b1 mean to c0
        b1 b2 mean to c1
        c0 c1 mean to d0 ;

: st1
        a0 b0 c0 d0 level ;

: st2
        d0 c1 b2 a3 level ;

: draw-3-lines
        2 0
        do      2over draw-line
        loop
        draw-line ;

: b-spline
        dup 1+ to level l_max <
        if      loada mid_pts st1 st2 recurse recurse
        else    draw-3-lines
        then ;

: splines
        5 2 0 3 0
        do      to l_max ." Next level = " l_max .
                ." , press a key .." key drop page
                0               0
                xmax 8 /        ymax 5 6 */
                xmax 5 6 */     ymax 20 /
                xmax            ymax
                0 b-spline
        loop ;

: demo
        text?
        if      graphics
        then
        page 5 to l_max
        begin
                xmax choose ymax choose
                xmax choose ymax choose
                xmax choose ymax choose
                xmax choose ymax choose
                0 randcolor b-spline
                stop?
        until
        white ;

: crosshairs
        2dup 4 circle ;

: tekenen
        page 5 to l_max showmouse
        begin   button
                if      hidemouse mouse crosshairs
                        begin   button 0=
                        until
                        showmouse
                then
                depth 8 =
                if      2rot 0 randcolor b-spline
                then
                home depth 2/ 2 .r stop?
        until
        begin   depth
        while   drop
        repeat
        hidemouse ;

                            \ (* End of Source *) /
