\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's 
\ DESCRIPTION : Decay of radioactive isotopes 
\ CATEGORY    : Physics 
\ AUTHOR      : Coos Haak 
\ LAST CHANGE : May 19, 1994, Coos Haak 
\ ----------------------------------------------------------------------



        NEEDS -graphics
        NEEDS -fixed
        NEEDS -fixlog

        MARKER -radio


DOC
   mother --> daughter1 --> daughter2 --> daughter3     <-- isotopes
          t1            t2            t3                <-- decay times

   decay constants      k = ln(2) / t
   differences          dN = N(t) - N(t-1)      ( is negative )
   mother isotope       N(t) = N(0) exp (-k1*t)
                             = N(0) exp (-t*ln(2)/t1)
                             = N(t-1) + dN
ENDDOC


fvalue t1                                       \ decay time 1
fvalue t2                                       \ decay time 2
fvalue t3                                       \ decay time 3
fvalue k1                                       \ decay constant 1
fvalue k2                                       \ decay constant 2
fvalue k3                                       \ decay constant 3

fvalue N1                                       \ conc. mother
fvalue N2                                       \ conc. daughter 1
fvalue N3                                       \ conc. daughter 2
fvalue N4                                       \ conc. daughter 3

: dN1           ( -- r )                        \ decay mother
        k1 fnegate N1 f*
        ;

: dN2           ( -- r )                        \ decay daughter 1
        k2 fnegate N2 f*
        ;

: dN3           ( -- r )                        \ decay daughter 2
        k3 fnegate N3 f*
        ;

25 value step

: go
        text?
        if      graphics
        then
        1025 step
        do      fln2 i s>f fdup to t1 f/ to k1
                1025 step
                do      fln2 i s>f fdup to t2 f/ to k2
                        1025 step
                        do      fln2 i s>f fdup to t3 f/ to k3
        480e to N1
        0e to N2
        0e to N3
        0e to N4
                                page
                                cr t1 0 6 n.r
                                cr t2 0 6 n.r
                                cr t3 0 6 n.r
                                640 0
                                do
                                        15 to color i N1 f>s plot
                                        14 to color i N2 f>s plot
                                        13 to color i N3 f>s plot
                                        12 to color i N4 f>s plot
                                        dN1 +to N1
                                        dN2 dN1 f- +to N2
                                        dN3 dN2 f- +to N3
                                        dN3 fnegate +to N4
                                loop
                                stop? ?leave
                        i +loop
                i +loop
        i +loop
        ;

                            \ (* End of Source *) /
