\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's 
\ DESCRIPTION : A caleidoscope 
\ CATEGORY    : Graphics 
\ AUTHOR      : Coos Haak 
\ LAST CHANGE : May 16, 1994, Coos Haak 
\ ----------------------------------------------------------------------



        needs -loadhigh

        loadhigh assembler

        mark -assembler

        needs -graphics

$1000 constant size

0 value data

: d@        ( addr -- x )
        data swap @x
        ;

: d!        ( x addr -- )
        data swap !x
        ;

$2000 constant len
len 2/ constant offset

: plotten       ( addr -- )
        d@ split
        dup negate local -h local +h
        dup negate local -v local +v
        +h +v plot +v +h plot
        -h +v plot +v -h plot
        +h -v plot -v +h plot
        -h -v plot -v -h plot
    ;

: rommelen      ( -- )
        0. 0 0
        do      17 choose 8 - + swap 2dup join i d!
        1 cells +loop
        2drop
        ;

: cstars        ( -- )
        rommelen 0 0
        do      randcolor i offset negate u<
                if      i plotten
                then
                i offset u< invert
                if      black i offset - plotten
                then
                stop? ?leave
        1 cells +loop
        white
        ;

relplot

: run
        size alloc throw to data
        graphics
        begin   cstars
        again
        data dealloc throw
        ;

dispose

turnkey run kaleidoskoop
                            \ (* End of Source *) /
