\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's 
\ DESCRIPTION : IFS figures 
\ CATEGORY    : Graphics 
\ AUTHOR      : Coos Haak 
\ LAST CHANGE : May 16, 1994, Coos Haak 
\ ----------------------------------------------------------------------



        NEEDS -graphics
        NEEDS -fixed
        NEEDS -arrays



        MARKER -ifs



DOC
(*
 * Wat IFS betekend, weet ik niet meer.
 * Kijk in een nummer van PCM van enige jaren geleden.
 *)
ENDDOC


fvalue oldx
fvalue oldy
0 value newx
0 value newy
0 value index

6 farray a
6 farray b
6 farray c
6 farray d
6 farray e
6 farray f
6 farray kans

 0.5e 0 to a
 0.0e 0 to b
-0.3e 0 to c
 0.0e 0 to d
-0.5e 0 to e
-0.3e 0 to f
 0.125e 0 to kans
 0.2e 1 to a
 0.0e 1 to b
 0.0e 1 to c
 0.0e 1 to d
 0.2e 1 to e
-1.5e 1 to f
 0.125e 1 to kans
 0.85e 2 to a
 0.3e 2 to b
-0.3e 2 to c
-0.3e 2 to d
 0.85e 2 to e
 0.2e 2 to f
 0.75e 2 to kans

: deltax
        index a oldx f*
        index b oldy f* f+
        index c f+ ;

: deltay
        index d oldx f*
        index e oldy f* f+
        index f f+ ;

create kleuren
        00 c, 15 c, 01 c, 14 c,
        02 c, 13 c, 03 c, 12 c,
        04 c, 11 c, 05 c, 10 c,
        06 c, 09 c, 07 c, 08 c,

: kleurindex
        16 0
        do      dup i kleuren + c@ =
                if      drop i leave
                then
        loop ;

: go
        text?
        if      graphics
        then
        page \ s" plasma" (loadpalette) grijs
        relplot clear oldx clear oldy
        begin   frandom 0 kans f- fdup f0<
                if      fdrop clear index
                else    1 kans f- f0<
                        if      1 to index
                        else    2 to index
                        then
                then
                deltay deltax to oldx to oldy
                oldx 40.0e f* round to newx
                oldy 30.0e f* round to newy
\               newx newy get-dot kleurindex 1+ maxc min kleuren + c@
\               newx newy get-dot 1+ (maxc) min
                newx newy get-dot 3 + (maxc) min
                to color newx newy plot stop?
        until
        kleur ;


                            \ (* End of Source *) /
