\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's 
\ DESCRIPTION : Graphic fonts on the screen 
\ CATEGORY    : Graphics 
\ AUTHOR      : Coos Haak 
\ LAST CHANGE : May 16, 1994, Coos Haak 
\ ----------------------------------------------------------------------



        NEEDS -graphics

        MARKER -fonts


create fontbuffer       here #24 #256 * dup allot erase

0 value height
0 value width

create curfont  here #64 dup allot erase

: .font
        cr width dec. height dec. curfont count 9 /string 4 - type ;

: (loadfont)
        s" f:/fonts/" curfont place
        curfont append s" .chf" curfont append
        curfont count r/o bin open-file throw local thefont
        pad 2 thefont read-file throw drop
        pad c@ to height
        pad 1+ c@ to width
        fontbuffer height width 8 */ #256 * thefont read-file throw
        thefont close-file throw
        height width 8 */ #256 * <> abort" Bestand blijkt te kort" ;

: .fonts
        s" xdir c:/fonts/*.chf" evaluate ;

: font:
        >in @
        create  >in ! bl word c@ 1+ allot
        does>   count (loadfont) ;

font: apls6
font: apls7
font: apls8
font: apls9
font: apls10
font: apls11
font: apls14
font: apls24
font: font8
font: font14
font: font16
font: thin8
font: thin14
font: thin16
font: neil
font: howard
font: oldeng
font: gaelic
font: fraktur

howard

0 value v_pos
0 value h_pos

: home
        home clear v_pos clear h_pos ;

: <cls>
        home [ ' emit >body ] literal @ ['] (emit) to emit
        page to emit home ;

: [emit]
        dup ^m =
        if      drop clear h_pos exit
        then
        dup ^j =
        if      drop height +to v_pos exit
        then
        dup ^h =
        if      drop h_pos width - 0 max to h_pos exit
        then
        dup ^i =
        if      drop 8 h_pos width / 8 mod - width * +to h_pos exit
        then
        dup ^l =
        if      drop <cls> exit
        then
        h_pos width + 8 / c/l < invert
        if      clear h_pos height +to v_pos
        then
        v_pos height + maxypix < invert
        if      <cls>
        then
        height * fontbuffer + height 0
        do      dup i + c@ width 0
                do      dup 1 and
                        if      white
                        else    black
                        then
                        h_pos width + i - maxypix 1- v_pos j + - plot
                        2/
                loop
                drop
        loop
        drop width +to h_pos ;

: new
        ['] [emit] to emit ;

: old
        ['] (emit) to emit ;

: do-it
        .font #128 bl
        do      i [emit]
        loop
        clear h_pos height +to v_pos ;

: demo
        page
        apls24 do-it
        font16 do-it
        thin16 do-it
        apls14 do-it
        font14 do-it
        thin14 do-it
        apls6 do-it
        apls7 do-it
        apls9 do-it
        apls10 do-it
        apls11 do-it
        apls8 do-it
        font8 do-it
        thin8 do-it
        neil do-it
        howard do-it
        ;


                            \ (* End of Source *) /
