\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's 
\ DESCRIPTION : Testing of goniometric functions 
\ CATEGORY    : Graphics and mathematics 
\ AUTHOR      : Coos Haak 
\ LAST CHANGE : May 16, 1994, Coos Haak 
\ ----------------------------------------------------------------------



        NEEDS -double
        NEEDS -graphics
        NEEDS -fixed
        NEEDS -fixgonio
        NEEDS -fixhyper
        NEEDS -fixcompl
        NEEDS -zlocals



        MARKER -fixtest



relplot

75 value dx
fvalue fdx      dx s>f to fdx
fvalue fdy      dx s>f to fdy

: axes
        maxc 1+ 2/ 1 max to color
        xmax 2/ 0 over negate 0 line
        0 ymax 2/ 0 over negate line ;

: >x
        s>f fdx f/ ;

: >y
        fdy f* round ;

: 1/x
        fdup f0=
        if      fdrop maxfloat
        else    1e fswap f/
        then ;

: een
        axes xmax 2/ dup negate
        do      white i dup >x fsin >y plot
                maxc 1- 1 max to color i dup >x fcos >y plot
                maxc 2 - 1 max to color i dup >x ftan >y plot
                maxc 3 - 1 max to color i dup >x fsin 1/x >y plot
                maxc 4 - 1 max to color i dup >x fcos 1/x >y plot
                maxc 5 - 1 max to color i dup >x ftan 1/x >y plot
        loop ;

: twee
        axes xmax 2/ dup negate
        do      white i dup >x fsinh >y plot
                maxc 1- 1 max to color i dup >x fcosh >y plot
                maxc 2 - 1 max to color i dup >x ftanh >y plot
                maxc 3 - 1 max to color i dup >x fsinh 1/x >y plot
                maxc 4 - 1 max to color i dup >x fcosh 1/x >y plot
                maxc 5 - 1 max to color i dup >x ftanh 1/x >y plot
        loop ;

: drie
        0e flocal x
        0e flocal y
        0e 0e zlocal z
        0e 0e zlocal t
        axes 361 0
        do      i s>f frad fcos to x
                i s>f frad fsin to y
                x facos pi/2 f- y fasin to z
                white z re fdx f* round z im >y plot
                z 1/z to t
                maxc 1- 1 max to color t re fdx f* round t im >y plot
        loop ;

: vier
        0 local temp
        axes white 361 0
        do      i s>f frad fsincos 200e 1e z*
                round to temp round temp swap plot
        loop ;

: go
        text?
        if      graphics
        then
        een page twee page drie page vier ;

: cirkels
        0 local temp
        page axes white gray
        1 360
        do      361 0
                do      i s>f frad fsincos 200e 1e z*
                        round to temp round temp swap
                        i j + s>f frad fsincos 200e 1e z*
                        round to temp round temp swap line
                j +loop
                361 0
                do      i s>f frad fsincos 200e 1e z*
                        round to temp round temp swap
                        i j + s>f frad fsincos 200e 1e z*
                        round to temp round temp swap line
                j +loop
                stop? ?leave
        -1 +loop
        white ;

: check
        361 0
        do      cr i 4 .r i s>f frad fsincos zdup 12 z.r
                fatan2 pi/180 f/ 12 f.r
        15 +loop ;

                            \ (* End of Source *) /
