\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's 
\ DESCRIPTION : Light bending by heavy masses 
\ CATEGORY    : Astrophysics 
\ AUTHOR      : Coos Haak 
\ LAST CHANGE : May 16, 1994, Coos Haak 
\ ----------------------------------------------------------------------



        NEEDS -graphics
        NEEDS -fixed
        NEEDS -fixgonio


        MARKER -einstein


relplot

' vres+ is graphics

: go
        text?
        if      graphics
        then
\       s" plasma" (loadpalette)
\       grijs
        0e flocal faktor 0e flocal afstand
        #256 0
        do      i negate to color
                #40 #1
                do      #40 #1
                        do      i s>f fsqr
                                j s>f fsqr f+ fsqrt to afstand
                                k s>f afstand f/ to faktor
                                faktor i s>f f* f>s i +
                                faktor j s>f f* f>s j +
                                2dup i j d=
                                if      2drop
                                else
                                        2dup plot
                                        over negate over plot
                                        2dup negate plot
                                        negate swap negate swap plot
                                then
                        loop
                loop
                stop?
                if      leave
                then
        loop
        change-colors 1000 ms text ;

                            \ (* End of Source *) /
