\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's 
\ DESCRIPTION : Atomic orbitals 
\ CATEGORY    : Graphics 
\ AUTHOR      : Coos Haak 
\ LAST CHANGE : May 16, 1994, Coos Haak 
\ ----------------------------------------------------------------------



        NEEDS -graphics
        NEEDS -fixed
        NEEDS -fixgonio
        NEEDS -fixlog

        ?DEF -chemie [IF] -chemie [THEN]

        MARKER -chemie



( x y -- f )    -- verwaarloos z-as
vector functie

fvalue z
fvalue x
fvalue y

: polar
        to y to x
        x fsqr y fsqr f+ fsqrt
        y x fatan2 ;

fvalue r
fvalue theta

: 1s
        polar fdrop fnegate z f* fexp
        [ 1e pi fsqrt f/ ] fliteral f* z 1.5e f** f* ;

: 2s
        polar fdrop to r
        2.0e r z f* f- r z f* -0.5e f* fexp f*
        [ 1e pi 32.0e f* fsqrt f/ ] fliteral f* z 1.5e f** f* ;

: 2p
        polar to theta to r
        r z f* fdup -0.5e f* fexp f* theta fcos f*
        [ 1e pi 32.0e f* fsqrt f/ ] fliteral f* z 1.5e f** f* ;

: 3s
        polar fdrop to r
        6.0e 4.0e r f* f- [ 4e 9e f/ ] fliteral
        r fsqr f* f+ r -3.0e f/ fexp f*
        [ 1e pi 972.0e f* fsqrt f/ ] fliteral f* ;

: 3p
        polar to theta to r
        [ 8e 3e f/ ] fliteral r f* [ 4e 9e f/ ] fliteral r fsqr f* f-
        r -3.0e f/ fexp f* theta fcos f*
        [ 1e pi 648.0e f* fsqrt f/ ] fliteral f* ;

: 3d
        polar to theta to r
        r fsqr r -3.0e f/ fexp f*
        3.0e theta fcos fsqr f* 1.0e f- f*
        [ 4e 324e f/ 6e pi f* fsqrt f/ ] fliteral f* ;

: 2s+2p
        fover fover 2s f>r 2p fr> f+ 2.0e f/ ;

: 3s+3p
        fover fover 3s f>r 3p fr> f+ 2.0e f/ ;

: 3s+3d
        fover fover 3s f>r 3d fr> f+ 2.0e f/ ;

: 3s-3d
        fover fover 3d f>r 3s fr> f- 2.0e f/ ;

: 3p+3d
        fover fover 3p f>r 3d fr> f+ 2.0e f/ ;

\ : h2
\        fover 2.0e f- fover 2p f>r fswap 2.0e f+ fswap 2p fr> f- ; -- sigma

\ : h2'
\        fover 2.0e f- fover 2p f>r fswap 2.0e f+ fswap 2p fr> f+ ; -- sigma*

\ : h2
\        fover fover 2.0e f- 2p f>r 2.0e f+ 2p fr> f+ ; -- pi

\ : h2'
\        fover fover 2.0e f- 2p f>r 2.0e f+ 2p fr> f- ; -- pi*

\ : h2
\        fover fover 6.0e f- 3p f>r 6.0e f+ 3p fr> f+ ; -- pi

\ : h2'
\        fover fover 6.0e f- 3p f>r 6.0e f+ 3p fr> f- ; -- pi*

: h2
        fover 0.25e f* fover 4.0e f- 0.25e f* 2p 0.5e f* f>r
        4.0e f+ 3p fr> f+ ; -- pi

: h2'
        fover 0.25e f* fover 4.0e f- 0.25e f* 2p 0.5e f* f>r
        4.0e f+ 3p fr> f- ; -- pi*

\ : h2
\        fover 5.0e f- fover 5.0e f- 3d f>r
\        fswap 5.0e f+ fswap 5.0e f+ 3d fr> f- ; -- pi

\ : h2'
\        fover 5.0e f- fover 5.0e f- 3d f>r
\        fswap 5.0e f+ fswap 5.0e f+ 3d fr> f+ ; -- pi*

relplot

50 constant pixels
\ pixels 25 / constant schaal
4 constant schaal

: kies
\       $20 + $3F and $20 + to color ;
\        #128 + to color ;
        2* 2* to color
    ;

\ : kies
\       32 + 63 and to color ;

: doen
        local y local x
        x s>f schaal s>f f/ y s>f schaal s>f f/ functie
\       fsqr 20.0e f*
\       400.0e f* round kies x y plot ;
        1000.0e f* round kies x y plot ;

: go
        pixels 1
        do
\               i s>f schaal s>f f/ home 12 f.r
                i 1+ 0
                do      i               j               doen
                        i               j negate        doen
                        i negate        j               doen
                        i negate        j negate        doen
                        j               i               doen
                        j               i negate        doen
                        j negate        i               doen
                        j negate        i negate        doen
                loop
                stop? ?leave
        loop ;

: %
        attr @ >r 63 attr !
        home eol >in @ ^M word count type >in ! '%' parse-word 2drop
        r> attr ! ;

' vres is graphics
graphics
\ loadpalette plasma
grijs

page

\ ' 3d to functie go dazzle grijs dazzle kleur

\ \s

-- grijs
% 1s, z=1%      ' 1s is functie 1.0e to z go
-- % 1s, z=2%   ' 1s is functie 2.0e to z go
% 2p, z=1%      ' 2p is functie 1.0e to z go
% 2p, z=2%      ' 2p is functie 2.0e to z go
% 2s%           ' 2s is functie go
% 2p%           ' 2p is functie go
% 3s%           ' 3s is functie go
% 3p%           ' 3p is functie go
% 3d%           ' 3d is functie go
% 2s+2p%        ' 2s+2p is functie go
% 3s+3p%        ' 3s+3p is functie go
% 3s+3d%        ' 3s+3d is functie go
% 3s-3d%        ' 3s-3d is functie go
% 3p+3d%        ' 3p+3d is functie go
% zomaar%       ' h2 is functie go
% onzin%        ' h2' is functie go
kleur

                            \ (* End of Source *) /
