\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's 
\ DESCRIPTION : Plotting in three dimensions 
\ CATEGORY    : Graphics 
\ AUTHOR      : Coos Haak 
\ LAST CHANGE : May 16, 1994, Coos Haak 
\ ----------------------------------------------------------------------



        NEEDS -fixed
        NEEDS -fixgonio
        NEEDS -fixlog
        NEEDS -graphics

        ?DEF -3dplot [IF] -3dplot [THEN]

        MARKER -3dplot



fvalue k        0.5e to k

fvalue hoek     30e to hoek

: 3d>2d         ( r1 r2 r3 -- n1 n2 )
        flocal z flocal y flocal x
        xmax 2/ s>f x f+ k y f* [ hoek frad fcos ] fliteral f* f+ f>s
        ymax 2/ s>f k y f* [ hoek frad fsin ] fliteral f* f+ z f+ f>s ;

vector functie

10 value stap

: go
        text?
        if      graphics
        then
        -120 120
        do      121 -120
                do      i s>f j s>f
                        j i functie
                        fdup f>s 7 + 15 and >r 3d>2d r> set-dot
                1 +loop
        stap negate +loop
        121 -120
        do      -120 120
                do      j s>f i s>f
                        i j functie
                        fdup f>s 7 + 15 and >r 3d>2d r> set-dot
                -1 +loop
        stap +loop ;

DOC
: fun           ( n1 n2 -- r1 )
        s>f 50e f/ fsqr f>r s>f 50e f/ fsqr fr> f+ flocal r
        r fcos
        r 3.0e f* fcos 3.0e f/ f+
        r 5.0e f* fcos 5.0e f/ f+
        r 7.0e f* fcos 7.0e f/ f+
        8.0e f*
        ;  ' fun is functie
ENDDOC

: fun           ( n1 n2 -- r1 )
        s>f 20e f/ flocal y
        s>f 20e f/ flocal x
        x fcos y fcos f- fdup fsqr f*
        7.0e f*
        ;  ' fun is functie


                            \ (* End of Source *) /
