\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's 
\ DESCRIPTION : Crossreferences in Forth programs 
\ CATEGORY    : Wordlists 
\ AUTHOR      : Coos Haak 
\ LAST CHANGE : May 16, 1994, Coos Haak 
\ ----------------------------------------------------------------------


        NEEDS -arrays

        MARKER -crossref


DOC
        XREF filename      Make a crossreference.
        XREFS (filespec)   Idem from a group of files, default *.frt
        SHOWLIST           Display the occurence list.
        LOOKUP word        Find the word in the list.
        CLEARLIST          Make the list empty.
ENDDOC

privates

2array thelist  private

variable counter        private
variable numbers        private
variable comments       private

: one_item
        out #20 + c/l >
        if      cr
        then
        thelist 6 .r space >head .head
        ;  private

: result
        counter @ 6 .r numbers @ 6 .r comments @ 6 .r
        ;  private

: reorder
        ?dup
        if      dup>r 1- thelist nip r@ thelist nip <
                if      r@ thelist r@ 1- thelist
                        r@ to thelist r@ 1- to thelist
                        r@ 1- recurse
                then
                r>drop
        then
        ;  private

: sortlist
        counter @ 1+ 0
        do      dup i thelist drop =
                if      drop i thelist 1+ i to thelist i reorder unloop exit
                then
        loop
        1 counter @ to thelist counter incr
        ;  private

: xinterpret
        search-context
        if
                case
                ['] noop of     endof
                ['] \ of        postpone \ comments incr        endof
                ['] ( of        postpone ( comments incr        endof
                ['] .( of       ')' parse 2drop comments incr   endof
                ['] doc of      postpone doc comments incr      endof
\ Self crossreferencing needs following: ENDDOC ( -- )
                ['] [if] of     postpone \ comments incr        endof
                ['] [else] of   postpone \ comments incr        endof
                ['] [then] of   postpone \ comments incr        endof
                ['] ." of       '"' parse 2drop ['] ." sortlist endof
                ['] abort" of   '"' parse 2drop ['] abort" sortlist     endof
                sortlist false
                        endcase exit
        then
        parsed-word number? dup
        if      numbers incr 0
                do      drop
                loop
        else    drop
        then
        ;  private

: rtab
        out over mod - spaces
        ;  private

: clearlist
        reset thelist -1 -1 0 to thelist 0 0 1 to thelist
        counter off numbers off comments off
        ;

clearlist

: lookup
        ' counter @ 0= abort" Lijst is leeg" counter @ 0
        do      dup i thelist drop =
                if      drop i cr one_item unloop exit
                then
        loop
        drop cr parsed-word type ."  komt niet in de lijst voor"
        ;

: showlist
        cr counter @ 0
        ?do     i one_item 19 rtab stop? ?leave
        loop
        ;

: xref
        >in @ bl parse-word type >in ! 16 htab
        ['] xinterpret dup is 'interpret is 'compile
        ['] in catch drop
        ['] $interpret is 'interpret
        ['] $compile is 'compile
        result
        ;

: (xrefs)
        begin   cr found-file 2dup tuck type 16 swap - spaces included
                result find-next-file stop? or
        until
        ;

: xrefs
        bl parse-word dup 0=
        if      2drop s" *.frt"
        then
        find-first-file
        if      exit
        then
        ['] xinterpret dup is 'interpret is 'compile
        ['] (xrefs) catch drop
        ['] $interpret is 'interpret
        ['] $compile is 'compile
        ;

deprive

                            \ (* End of Source *) /
