\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's 
\ DESCRIPTION : Configuratie of this computer 
\ CATEGORY    : MS-DOS 
\ AUTHOR      : Coos Haak 
\ LAST CHANGE : 27 jan 94, Coos Haak, English. No Dutch or Zealando-Flemish!
\ LAST CHANGE : 02 nov 93, Coos Haak 
\ ----------------------------------------------------------------------




        NEEDS -assembler


        MARKER -config



code equip
                push    bx
                int     $11
                mov     bx, ax
                next    end-code

code memsize
                push    bx
                int     $12
                mov     bx, ax
                next    end-code

: lastseg
        [ #1024 #paragraphs ] literal alloc throw dup dealloc throw ;

: center
        c/l over - 2/ spaces type ;

: first-tab
        #20 htab ;

: second-tab
        #50 htab ;

: equipment
        push base decimal
        cr s" Configuration" center equip
        cr first-tab ." Printers" second-tab dup #14 rshift .
        dup $1000 and
        if      cr first-tab ." Game port"
        then
        dup 9 rshift 7 and
        cr first-tab ." RS-232 cards" second-tab .
        cr first-tab ." Floppy drives" second-tab dup 6 rshift 3 and 1+ .
        cr first-tab ." Video" second-tab dup 4 rshift 3 and
        case
                1 of    ." 40*25 color" endof
                2 of    ." 80*25 color" endof
                3 of    ." 80*25 monochrome"    endof
                ." not display connected?"
        endcase
        cr first-tab ." Coprocessor" second-tab 2 and 0=
        if      ." not "
        then
        ." available"
        cr first-tab ." Memory" second-tab memsize 0 .r 'K' emit
        cr first-tab ." Free memory" second-tab memsize lastseg 6 rshift - 0 .r
        ." K (" lastseg h. ." - "
        memsize 6 lshift h. ^H emit ')' emit
        cr first-tab ." HERE" second-tab cseg ['] -config x.
        cr first-tab ." Interrupts" second-tab $100 0
        do      0 i 2* 1+ 2* @x cseg =
                if      i b.
                then
        loop
        cr first-tab ." Logical drives" second-tab ." A:.." getdisk setdisk
        '@' + emit ':' emit
        cr eseg 0
        begin   cr
                begin   countx ?dup
                while   emit
                repeat
                2dup c@x 0=
        until
        2drop cr .me space $80 c@
        if      $80 count type
        then
        pop base cr ;

equipment


-config ( Remove this program )

                            \ (* End of Source *) /
