\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's 
\ DESCRIPTION : Block extensions 
\ CATEGORY    : Standarisation 
\ AUTHOR      : Coos Haak 
\ LAST CHANGE : April 1, 1994, Coos Haak, FIGFORTH editor
\ LAST CHANGE : February 21, 1994, Coos Haak 
\ ----------------------------------------------------------------------



        NEEDS -environ


        MARKER -blockext



DOC
\ 
\ Redefine the BLOCK and BLOCK EXTENSIONS words so that they do work.
\ 
ENDDOC

s" BLOCK" environment? [if]
        drop also environment-wordlist set-context
        true to block
        true to block-ext
        previous
[then]

        privates

        internal also extra definitions

create bext$    ", .blk"

4 to buffers

variable existing       existing off    private

variable scrs           scrs off
variable blkfile        blkfile off     private

: f:initbufs
        drop existing @
        if      clear buffer-0 existing off
                ['] not-implemented dup dup dup
                is read-block is write-block is +buf is update
        then
        ;  private

: initbufs
        existing @ invert
        if      align here to buffer-0 #1026 buffers * allot
                buffer-0 dup to prev to use existing on empty-buffers
        then
        ;
' f:initbufs ' initbufs >head head>forget h!

initbufs

:noname
        #1026 + buffer-0 #1026 buffers * +
        of      buffer-0
        then
        dup prev <>
        ;  is +buf

: make-first-line       ( adr blk -- adr blk )
        push base decimal
        over #54 + >r date
        <# u>d # # 2drop 1- 3 * months + count hold count hold c@ hold
        u>d # # #> r@ swap cmove s" jjh" r> 7 + swap cmove
        pop base
        ;  private

: read/write
        dup scrs @ u< invert #-35 ?error
        #1024 um* blkfile @ reposition-file throw
        #1024 blkfile @
        ;  private

:noname
        read/write read-file #-33 ?error drop
        ;  is read-block

:noname
        make-first-line
        read/write write-file #-34 ?error
        ;  is write-block

:noname
        prev @ $8000 or prev !
        ;  is update

: close
        blkfile @
        if      save-buffers blkfile @ blkfile off close-file throw
        then
        ;

:noname
        chain atexit
        close
        ;  is atexit

: use-blocks            ( c-addr u -- )
        close ( empty-buffers ) scr off
        block-file-name pack count '.' scan nip 0=
        if      bext$ count block-file-name append
        then
        block-file-name count r/w bin open-file throw blkfile !
        blkfile @ file-size throw #1024 sm/rem scrs ! drop
        source-id
        blkfile @ to source-id
        scrs @ #16 * #lines !
        to source-id
        ;

:noname
        chain start
        s" blokken" ['] use-blocks catch ?dup
        if      cr ." Message " .dec ." skipping loading of default blocks file. "
        then
        ;  is start

        forth definitions

: ?rem
        >in @ bl word find
        if      execute
        else    drop
        then
        >in ! marker
        ;

s" blokken.blk" temporary place
temporary count file-status nip 0= [if]
temporary count use-blocks
[then]

: make-blocks-file      ( n "ccc" -- )
        here #1024 dup allot blank
        bl word count temporary pack count '.' scan nip 0=
        if      bext$ count temporary append
        then
        temporary count w/o bin create-file throw local output
        0
        ?do     here #1024 - #1024 output write-file throw
                ?at i 4 .r at-xy
        loop
        output close-file throw #-1024 allot 4 spaces cr
        ;

-- FIGFORTH extensions

: index         ( from to+1 -- )
        swap
        do      cr i 3 .r space 0 i .line stop? ?leave
        loop
        ;

: .blks
        buffers 0
        do      cr i 3 .r buffer-0 i #1026 * +
                dup @ $7FFF and 6 .r
                dup @ 0<
                if      ."  Upd "
                else    ."      "
                then
                dup use =
                if      ." Curr "
                else    ."      "
                then
                prev =
                if      ." Prev "
                else    ."      "
                then
        loop
    ;

editor also definitions

#64 constant /sline     private

0 value cursor

: text          ( c "ccc" -- )
        here /sline 1+ blank word temporary /sline 1+ cmove
        bl temporary count + c!
        ;  private

: line                  ( n -- c-addr )
        dup $FFF0 and abort" Line not within screen" scr @ (line) drop
        ;  private

: #locate               ( -- n1 n2 )
        cursor /sline /mod
        ;  private

: #lead                 ( -- c-addr u )
        #locate line swap
        ;  private

: #lag                  ( -- c-addr u )
        #lead /sline swap /string
        ;  private

: -move                 ( c-addr n -- )
        line /sline cmove update
        ;  private

: h                     ( n -- )
        line /sline temporary place
        ;

: e                     ( n -- )
        line /sline blank update
        ;

: s                     ( n -- )
        dup 1- #14
        ?do     i line i 1+ -move
        -1 +loop
        e
        ;

: d                     ( n -- )
        dup h #15 dup rot
        do      i 1+ line i -move
        loop
        e
        ;

: m                     ( n -- )
        cr +to cursor #lead type ^Q emit #lag type #locate 2 .r drop
        ;

: t                     ( n -- )
        dup /sline * to cursor h 0 m
        ;

: l                     ( -- )
        scr @ list
        ;

: r                     ( n -- )
        temporary 1+ swap -move
        ;

: p                     ( n "ccc" -- )
        separator text r
        ;

: top                   ( -- )
        clear cursor
        ;

: wipe                  ( -- )
        #16 0
        do      i e
        loop
        ;

: copy                  ( n1 n2 -- )
        swap block cell- ! update save-buffers
        ;

: match                 ( c-addr1 u1 c-addr2 u2 -- flag n1 )
        2over bounds
        do      2dup i over compare 0=
                if      -rot 2drop - i swap - true swap unloop exit
                then
        loop
        2drop nip false swap
        ;  private

: 1line                 ( -- flag )
        #lag temporary count match +to cursor
        ;  private

: find          ( -- )
        begin   #1023 cursor <
                if      top temporary here /sline 1+ cmove
                        abort" text not found"
                then
                1line
        until
        ;  private

: delete                ( u -- )
        >r #lag + r@ - #lag r@ negate +to cursor #lead + swap cmove
        r> blank update
        ;  private

: n                     ( -- )
        find 0 m
        ;

: f                     ( "ccc" -- )
        separator text n
        ;

: b                     ( -- )
        temporary c@ negate m
        ;

: x                     ( "ccc" -- )
        separator text find temporary c@ delete 0 m
        ;

: till                  ( "ccc" -- )
        #lead + separator text 1line 0= abort" text not found"
        #lead + swap - delete 0 m
        ;

: c                     ( "ccc" -- )
        separator text temporary count #lag rot over min dup>r +to cursor
        r@ - >r dup here r@ cmove here #lead + r> cmove
        r> cmove update 0 m
        ;

: y                     ( n -- )
        #16 0
        do      cr i 3 .r space i over =
                if      refill drop 1 text #tib @ 0=
                        if      ^H emit i scr @ .line
                        else    i r 1+
                        then
                else    i scr @ .line
                then
        loop
        drop
        ;

vector ed-i             private

: u                     ( n -- )
        1+ #16 0
        do      cr i 3 .r space i over =
                if      refill drop 1 text #tib @ 0=
                        if      ^H emit i scr @ .line
                        else    i ed-i 1+
                        then
                else    i scr @ .line
                then
        loop
        drop
        ;

: i                     ( n -- )
        dup s r
        ;

' i is ed-i

: q                     ( -- )
        scr @ 1- 0 max scr !
        ;

: w                     ( -- )
        scr @ 1+ scrs @ 1- min scr !
        ;

: a                     ( -- )
        scr @ scrs @ 2/ + scrs @ mod scr !
        ;

: search                ( n1 n2 "ccc" -- )
        push base push scr decimal
        1 text 1+ swap
        do      [ forth ] i [ editor ] scr ! top
                begin   1line
                        if      0 m scr @ 4 .r space
                        then
                        #1024 cursor > invert
                until
                stop? ?leave
        loop
        top pop scr pop base
        ;

: wi                    ( "ccc" -- )
        0 scrs @ 1- search
        ;

0 value keep    private

: browsehelp
        page cr cr 10 spaces ." The BROWSE command." cr
        cr 10 spaces ." PgDn  next screen"
        cr 10 spaces ." PgUp  previous screen"
        cr 10 spaces ." Home  first screen"
        cr 10 spaces ." End   last screen"
        cr 10 spaces ." Ins   mark this screen"
        cr 10 spaces ." Del   return to the marked screen"
        cr 10 spaces ." F2    swap with the shadow screen"
        cr 10 spaces ." Esc   leave browser"
        cr 10 spaces ." F1    this help"
        cr
        ;  private

forth definitions editor

: browse
        browsehelp
        begin   ekey
                case
                        ^[ of       exit   endof
                        $3B00 of    browsehelp              endof   \ F1
                        $4900 of    q page l                endof   \ PgUp
                        $5100 of    w page l                endof   \ PgDn
                        $4700 of    scr off page l          endof   \ Home
                        $4F00 of    scrs @ 1- scr ! page l  endof   \ End
                        $5200 of    scr @ to keep           endof   \ Ins
                        $5300 of    keep scr ! page l       endof   \ Del
                        $3C00 of    a page l                endof   \ F2
                endcase
        again
        ;

previous previous forth definitions
deprive

                            \ (* End of Source *) /
