\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's 
\ DESCRIPTION : INTEL 8080 microprocessor 
\ CATEGORY    : Simulations 
\ AUTHOR      : Coos Haak 
\ LAST CHANGE : May 16, 1994, Coos Haak 
\ ----------------------------------------------------------------------


        NEEDS -8080lib

        MARKER -8080

hex

reset
clearlabels

trgseg 2@ swap 0 fillp

8 == rst_8
                ei
                ret
asm;

10 == rst_10
                ei
                ret
asm;

18 == rst_18
                ei
                ret
asm;

20 == rst_20
                ei
                ret
asm;

28 == rst_28
                ei
                ret
asm;

30 == _nxt
                ldax    b
                inx     b
                mov     l a
                ldax    b
                inx     b
                mov     h a
                pchl
asm;

200 org

label vlag      db 10
label rptr      dw C000
label vlag2     db 0

C000 == sp0
D000 == rp0

38 == _int
                di
                push    psw
                push    h
                lxi     h       vlag
                dcr     m
        0= if
                mvi     m       10
                pop     h
                pop     psw
                ret
        then
                pop     h
                pop     psw
                ei
                ret
asm;

66 == _nmi
                rst     0
asm;

label _docol
                lhld    rptr
                dcx     h
                mov     m       b
                dcx     h
                mov     m       c
                shld    rptr
                pop     b
                rst     6
asm;

100 == _main
                lxi     h       sp0
                sphl
                lxi     h       rp0
                shld    rptr
                lxi     d       vlag
                lxi     h       vlag2
                ei
        begin
        begin
                ldax    d
                cpi     10
        0= not until
                mov     m       a
                dcr     m
        again
asm;

0 == rst_0
                di
                jmp     _main
asm;

: go
        page
        begin   10 10 choose + steps _int interrupt stop?
        until
        home ;

: fill-memory
        [ 8080asm ]
        400 to here-t
        100 0
        do      i c,-t 0 ,-t
        loop
        [ forth ] ;

                            \ (* End of Source *) /
