\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's 
\ DESCRIPTION : RCA COSMAC 1806 microprocessor 
\ CATEGORY    : Simulations 
\ AUTHOR      : Coos Haak 
\ LAST CHANGE : May 16, 1994, Coos Haak 
\ ----------------------------------------------------------------------


        NEEDS -1806lib

        ?DEF -1806 [IF] -1806 [THEN]

        MARKER -1806

hex
reset
clearlabels
trgseg 2@ swap 0 fillp

DOC
0 == alles
        stpc
        dtc
        spm2
        scm2
        spm1
        scm1
        ldc
        stm
        gec
        etq
        xie
        xid
        cie
        cid
        bci     here-t
        bxi     here-t
        rlxa    t0
        scal    lk here-t
        sret    lk
        rsxd    t0
        rnx     t0
        rldi    t0 here-t
        dbnz    t0 here-t
        dadc
        dsav
        dsmb
        daci    10
        dsbi    10
        dadd
        dsm
        dadi    10
        dsmi    10
asm;
alles disasm
\s
ENDDOC

FF30 == intsrv
        begin
                ret
                dsav
                dec     rp
                rsxd    ip
                rldi    ip intsrv 1-
                ldn     ip
                adi     1
                str     ip
                inc     rp
                rlxa    ip
                ldxa
                shl
                ldxa
        again
asm;

100 == main
        begin
                scal    lk 200
                scal    lk 600
        again
asm;

label sub1
                sret    lk
asm;

label sub2
                scal    lk sub1
                rldi    t0 4
label lusje
                glo     t0
                xri     -1
                dbnz    t0 lusje
                sret    lk
asm;

600 == mega
                rldi    t2 #100
                xid
label m_1       dbnz    t2 m_1
                xie
                sret    lk

asm;

200 == sub3
                scal    lk sub1
                scal    lk sub2
                sret    lk
asm;

0 org
                dis
                db      0
                rldi    1 intsrv 1+
                rldi    sp B000
                rldi    rp C000
                rldi    pc main
                ret
                db      sp 10 * pc +
asm;

: go
        page
        begin   20 20 choose + steps interrupt stop?
        until
        home ;


                            \ (* End of Source *) /
