


NASM(1)                                                   NASM(1)


[1mNAME[m
       nasm - the Netwide Assembler - portable 80x86 assembler

[1mSYNOPSIS[m
       [1mnasm[m [ [1m-f[m format ] [ [1m-o[m outfile ] [ [4moptions[m...  ] infile
       [1mnasm[m [1m-h[m
       [1mnasm[m [1m-r[m

[1mDESCRIPTION[m
       The  [1mnasm[m  command  assembles  the file [4minfile[m and directs
       output to the file [4moutfile[m if specified. If [4moutfile[m is not
       specified,  [1mnasm[m  will  derive  a default output file name
       from the name of its input file, usually by appending `.o'
       or  `.obj', or by removing all extensions for a raw binary
       file.  Failing  that,  the  output  file  name   will   be
       `nasm.out'.

   [1mOPTIONS[m
       [1m-h[m     Causes  [1mnasm[m  to  exit  immediately, after giving a
              summary of its invocation options, and listing  all
              its supported output file formats.

       [1m-a[m     Causes  [1mnasm[m to assemble the given input file with-
              out first applying the macro preprocessor.

       [1m-e[m     Causes [1mnasm[m to preprocess the given input file, and
              write the output to [4mstdout[m (or the specified output
              file name), and not actually assemble anything.

       [1m-r[m     Causes [1mnasm[m to exit immediately,  after  displaying
              its version number.

       [1m-f[m [4mformat[m
              Specifies  the  output file format. Formats include
              [4mbin[m, to produce flat-form binary  files,  and  [4maout[m
              and  [4melf[m  to  produce  Linux  a.out  and ELF object
              files, respectively.

       [1m-o[m [4moutfile[m
              Specifies a precise name for the output file, over-
              riding [1mnasm[m's default means of determining it.

       [1m-l[m [4mlistfile[m
              Causes  an  assembly  listing to be directed to the
              given file, in which the original  source  is  dis-
              played  on the right hand side (plus the source for
              included files and  the  expansions  of  multi-line
              macros)  and  the generated code is shown in hex on
              the left.

       [1m-s[m     Causes [1mnasm[m to send its error messages and/or  help
              text to [4mstdout[m instead of [4mstderr[m.





                  The Netwide Assembler Project                 1





NASM(1)                                                   NASM(1)


       [1m-w[m[4m[+-]foo[m
              Causes [1mnasm[m to enable or disable certain classes of
              warning messages, for example  [1m-w+orphan-labels[m  or
              [1m-w-macro-params[m  to,  respectively, enable warnings
              about labels alone on  lines  or  disable  warnings
              about  incorrect  numbers  of  parameters  in macro
              calls.

       [1m-i[m [4mdirectory[m
              Adds a directory to the  search  path  for  include
              files. The directory specification must include the
              trailing slash, as it will be directly prepended to
              the name of the include file.

       [1m-p[m [4mfile[m
              Specifies  a  file  to  be pre-included, before the
              main source file starts to be processed.

       [1m-d[m [4mmacro[=value][m
              Pre-defines a single-line macro.


   [1mSYNTAX[m
       This man page does not fully describe the syntax of [1mnasm[m's
       assembly  language, but does give a summary of the differ-
       ences from other assemblers.

       [4mRegisters[m have no leading `%' sign, unlike [1mgas[m, and float-
       ing-point stack registers are referred to as [4mst0[m, [4mst1[m, and
       so on.

       [4mFloating-point[m [4minstructions[m may  use  either  the  single-
       operand  form  or  the  double.  A [4mTO[m keyword is provided;
       thus, one could either write

                      fadd st0,st1
                      fadd st1,st0

       or one could use the alternative single-operand forms

                      fadd st1
                      fadd to st1

       [4mUninitialised[m [4mstorage[m is reserved using  the  [4mRESB[m,  [4mRESW[m,
       [4mRESD[m, [4mRESQ[m and [4mREST[m pseudo-opcodes, each taking one param-
       eter which gives the number of bytes, words,  doublewords,
       quadwords or ten-byte words to reserve.

       [4mRepetition[m of data items is not done by the [4mDUP[m keyword as
       seen in DOS assemblers, but by the use of the  [4mTIMES[m  pre-
       fix, like this:

             message: times 3 db 'abc'
                      times 64-$+message db 0



                  The Netwide Assembler Project                 2





NASM(1)                                                   NASM(1)


       which  defines  the  string  `abcabcabc',  followed by the
       right number of zero bytes to make the total length up  to
       64 bytes.

       [4mSymbol[m  [4mreferences[m  are  always understood to be immediate
       (i.e. the address of the symbol), unless  square  brackets
       are  used,  in which case the contents of the memory loca-
       tion are used. Thus:

                      mov ax,wordvar

       loads AX with  the  address  of  the  variable  `wordvar',
       whereas

                      mov ax,[wordvar]
                      mov ax,[wordvar+1]
                      mov ax,[es:wordvar+bx]

       all  refer  to  the [4mcontents[m of memory locations. The syn-
       taxes

                      mov ax,es:wordvar[bx]
                      es mov ax,wordvar[1]

       are not legal at all, although the use of a segment regis-
       ter  name  as  an  instruction prefix is valid, and can be
       used with instructions such as [4mLODSB[m which can't be  over-
       ridden any other way.

       [4mConstants[m  may be expressed numerically in most formats: a
       trailing H, Q or B denotes hex, octal  or  binary  respec-
       tively,  and  a  leading  `0x' or `$' denotes hex as well.
       Leading zeros are not treated specially at all.  Character
       constants  may  be  enclosed  in  single or double quotes;
       there is no escape  character.  The  ordering  is  little-
       endian  (reversed),  so that the character constant [4m'abcd'[m
       denotes 0x64636261 and not 0x61626364.

       [4mLocal[m [4mlabels[m begin with a period, and their `locality'  is
       granted by the assembler prepending the name of the previ-
       ous non-local symbol. Thus declaring a label `.loop' after
       a  label  `label'  has  actually  defined  a symbol called
       `label.loop'.

   [1mDIRECTIVES[m
       [4mSECTION[m [4mname[m or [4mSEGMENT[m [4mname[m causes  [1mnasm[m  to  direct  all
       following  code  to  the named section. Section names vary
       with output file format, although most formats support the
       names  [4m.text[m,  [4m.data[m  and [4m.bss[m.  (The exception is the [4mobj[m
       format, in which all segments are user-definable.)

       [4mABSOLUTE[m [4maddress[m causes  [1mnasm[m  to  position  its  notional
       assembly  point at an absolute address: so no code or data
       may be generated, but you can use [4mRESB[m, [4mRESW[m and  [4mRESD[m  to



                  The Netwide Assembler Project                 3





NASM(1)                                                   NASM(1)


       move  the  assembly  point  further on, and you can define
       labels. So this directive  may  be  used  to  define  data
       structures.  When  you have finished doing absolute assem-
       bly, you must issue another [4mSECTION[m directive to return to
       normal assembly.

       [4mBITS[m [4m16[m or [4mBITS[m [4m32[m switches the default processor mode for
       which [1mnasm[m is generating code: it is equivalent  to  [4mUSE16[m
       or [4mUSE32[m in DOS assemblers.

       [4mEXTERN[m  [4msymbol[m  and [4mGLOBAL[m [4msymbol[m import and export symbol
       definitions, respectively, from and to other modules. Note
       that  the  [4mGLOBAL[m directive must appear before the defini-
       tion of the symbol it refers to.

       [4mSTRUC[m [4mstrucname[m and [4mENDSTRUC[m, when used to bracket a  num-
       ber  of  [4mRESB[m, [4mRESW[m or similar instructions, define a data
       structure. In addition to  defining  the  offsets  of  the
       structure members, the construct also defines a symbol for
       the size of the structure, which is simply  the  structure
       name with [4m_size[m tacked on to the end.

   [1mFORMAT-SPECIFIC[m [1mDIRECTIVES[m
       [4mORG[m  [4maddress[m  is  used  by the [4mbin[m flat-form binary output
       format, and specifies the address at which the output code
       will eventually be loaded.

       [4mGROUP[m  [4mgrpname[m [4mseg1[m [4mseg2...[m  is used by the [4mobj[m (Microsoft
       16-bit) output format, and defines  segment  groups.  This
       format  also  uses  [4mUPPERCASE[m, which directs that all seg-
       ment, group and symbol names output  to  the  object  file
       should  be  in uppercase. Note that the actual assembly is
       still case sensitive.

       [4mLIBRARY[m [4mlibname[m is used by  the  [4mrdf[m  output  format,  and
       causes  a  dependency  record  to be written to the output
       file which indicates that the program requires  a  certain
       library in order to run.

   [1mMACRO[m [1mPREPROCESSOR[m
       Single-line  macros are defined using the [4m%define[m or [4m%ide-[m
       [4mfine[m commands, in a similar fashion to the C preprocessor.
       They  can  be overloaded with respect to number of parame-
       ters, although defining a macro with  no  parameters  pre-
       vents  the definition of any macro with the same name tak-
       ing parameters, and vice versa.   [4m%define[m  defines  macros
       whose   names  match  case-sensitively,  whereas  [4m%idefine[m
       defines case-insensitive macros.

       Multi-line macros are defined  using  [4m%macro[m  and  [4m%imacro[m
       (the  distinction  is the same as that between [4m%define[m and
       [4m%idefine[m), whose syntax is as follows:

             %macro [4mname[m [4mminprm[m[-[4mmaxprm[m][+][.nolist] [[4mdefaults[m]



                  The Netwide Assembler Project                 4





NASM(1)                                                   NASM(1)


                      <some lines of macro expansion text>
             %endmacro

       Again, these macros may be overloaded. The  trailing  plus
       sign  indicates that any parameters after the last one get
       subsumed, with their  separating  commas,  into  the  last
       parameter.  The  [4mdefaults[m  part  can  be  used  to specify
       defaults for unspecified macro parameters after  [4mminparam[m.
       [4m%endm[m is a valid synonym for [4m%endmacro[m.

       To refer to the macro parameters within a macro expansion,
       you use [4m%1[m, [4m%2[m and so on. You  can  also  enforce  that  a
       macro  parameter  should contain a condition code by using
       [4m%+1[m, and you can invert the condition code by  using  [4m%-1[m.
       You can also define a label specific to a macro invocation
       by prefixing it with a double % sign.

       Files can be included using the [4m%include[m directive,  which
       works like C.

       The  preprocessor has a `context stack', which may be used
       by one macro to store information that a  later  one  will
       retrieve. You can push a context on the stack using [4m%push[m,
       remove one using [4m%pop[m, and change the name of the top con-
       text (without disturbing any associated definitions) using
       [4m%repl[m.  Labels and [4m%define[m macros specific to the top con-
       text  may be defined by prefixing their names with %$, and
       things specific to the next context down with %$$, and  so
       on.

       Conditional  assembly is done by means of [4m%ifdef[m, [4m%ifndef[m,
       [4m%else[m and [4m%endif[m as in C. (Except that [4m%ifdef[m  can  accept
       several  putative  macro  names, and will evaluate TRUE if
       any of them  is  defined.)  In  addition,  the  directives
       [4m%ifctx[m and [4m%ifnctx[m can be used to condition on the name of
       the top context on the context stack. The obvious  set  of
       `else-if'  directives,  [4m%elifdef[m,  [4m%elifndef[m, [4m%elifctx[m and
       [4m%elifnctx[m are also supported.

[1mBUGS[m
       There is a reported seg-fault on some (Linux) systems with
       some  large  source files. This appears to be very hard to
       reproduce. All other [4mknown[m bugs have been fixed...

[1mRESTRICTIONS[m
       There is no support for listing  files,  symbol  maps,  or
       debugging  object-file  records.  The advanced features of
       the ELF and Win32 object file formats are  not  supported,
       and  there  is no means for warning the programmer against
       using an instruction beyond the capability of  the  target
       processor.

[1mSEE[m [1mALSO[m
       [1mas[m([1m1[m), [1mld[m([1m1[m).



                  The Netwide Assembler Project                 5


