/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.ArrayType;
import gnu.bytecode.ClassType;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.Field;
import gnu.bytecode.Method;
import gnu.bytecode.ObjectType;
import gnu.bytecode.Variable;
import gnu.expr.ApplyExp;
import gnu.expr.CheckedTarget;
import gnu.expr.ClassExp;
import gnu.expr.Compilation;
import gnu.expr.ConsumerTarget;
import gnu.expr.Declaration;
import gnu.expr.Expression;
import gnu.expr.GenericProc;
import gnu.expr.IgnoreTarget;
import gnu.expr.Inlineable;
import gnu.expr.LambdaExp;
import gnu.expr.Language;
import gnu.expr.ModuleMethod;
import gnu.expr.PairClassType;
import gnu.expr.Target;
import gnu.kawa.functions.MakeList;
import gnu.kawa.lispexpr.LangObjType;
import gnu.lists.LList;
import gnu.mapping.CallContext;
import gnu.mapping.MethodProc;
import gnu.mapping.Procedure;
import gnu.mapping.ProcedureN;
import gnu.mapping.WrongArguments;
import java.io.PrintWriter;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Type;

public class PrimProcedure
extends MethodProc
implements Inlineable {
    gnu.bytecode.Type retType;
    gnu.bytecode.Type[] argTypes;
    Method method;
    int op_code;
    char mode;
    LambdaExp source;
    Member member;
    private static ClassLoader systemClassLoader = PrimProcedure.class.getClassLoader();

    public final int opcode() {
        return this.op_code;
    }

    public gnu.bytecode.Type getReturnType() {
        return this.retType;
    }

    public void setReturnType(gnu.bytecode.Type type) {
        this.retType = type;
    }

    public boolean isSpecial() {
        return this.mode == 'P';
    }

    public gnu.bytecode.Type getReturnType(Expression[] expressionArray) {
        return this.retType;
    }

    public Method getMethod() {
        return this.method;
    }

    public boolean takesVarArgs() {
        if (this.method != null) {
            if ((this.method.getModifiers() & 0x80) != 0) {
                return true;
            }
            String string = this.method.getName();
            return string.endsWith("$V") || string.endsWith("$V$X");
        }
        return false;
    }

    public boolean takesContext() {
        return this.method != null && PrimProcedure.takesContext(this.method);
    }

    public static boolean takesContext(Method method) {
        return method.getName().endsWith("$X");
    }

    public int isApplicable(gnu.bytecode.Type[] typeArray) {
        int n = super.isApplicable(typeArray);
        int n2 = typeArray.length;
        if (n == -1 && this.method != null && (this.method.getModifiers() & 0x80) != 0 && n2 > 0 && typeArray[n2 - 1] instanceof ArrayType) {
            gnu.bytecode.Type[] typeArray2 = new gnu.bytecode.Type[n2];
            System.arraycopy(typeArray, 0, typeArray2, 0, n2 - 1);
            typeArray2[n2 - 1] = ((ArrayType)typeArray[n2 - 1]).getComponentType();
            return super.isApplicable(typeArray2);
        }
        return n;
    }

    public final boolean isConstructor() {
        return this.opcode() == 183 && this.mode != 'P';
    }

    public boolean takesTarget() {
        return this.mode != '\u0000';
    }

    public int numArgs() {
        int n = this.argTypes.length;
        if (this.takesTarget()) {
            ++n;
        }
        if (this.takesContext()) {
            --n;
        }
        return this.takesVarArgs() ? n - 1 + -4096 : n + (n << 12);
    }

    public int match0(CallContext callContext) {
        return this.matchN(ProcedureN.noArgs, callContext);
    }

    public int match1(Object object2, CallContext callContext) {
        Object[] objectArray = new Object[]{object2};
        return this.matchN(objectArray, callContext);
    }

    public int match2(Object object2, Object object3, CallContext callContext) {
        Object[] objectArray = new Object[]{object2, object3};
        return this.matchN(objectArray, callContext);
    }

    public int match3(Object object2, Object object3, Object object4, CallContext callContext) {
        Object[] objectArray = new Object[]{object2, object3, object4};
        return this.matchN(objectArray, callContext);
    }

    public int match4(Object object2, Object object3, Object object4, Object object5, CallContext callContext) {
        Object[] objectArray = new Object[]{object2, object3, object4, object5};
        return this.matchN(objectArray, callContext);
    }

    public int matchN(Object[] objectArray, CallContext callContext) {
        Object object2;
        Type type;
        Object object3;
        int n = objectArray.length;
        boolean bl = this.takesVarArgs();
        int n2 = this.minArgs();
        if (n < n2) {
            return 0xFFF10000 | n2;
        }
        if (!bl && n > n2) {
            return 0xFFF20000 | n2;
        }
        int n3 = this.argTypes.length;
        gnu.bytecode.Type type2 = null;
        Object[] objectArray2 = null;
        int n4 = this.takesTarget() || this.isConstructor() ? 1 : 0;
        boolean bl2 = this.takesContext();
        Object[] objectArray3 = new Object[n3];
        if (bl2) {
            objectArray3[--n3] = callContext;
        }
        if (bl) {
            gnu.bytecode.Type type3 = this.argTypes[n3 - 1];
            if (type3 == Compilation.scmListType || type3 == LangObjType.listType) {
                objectArray3[n3 - 1] = LList.makeList(objectArray, n2);
                n = n2;
                type2 = gnu.bytecode.Type.objectType;
            } else {
                object3 = (ArrayType)type3;
                type2 = ((ArrayType)object3).getComponentType();
                type = type2.getReflectClass();
                objectArray3[n3 - 1] = objectArray2 = (Object[])Array.newInstance(type, n - n2);
            }
        }
        if (this.isConstructor()) {
            object2 = objectArray[0];
        } else if (n4 != 0) {
            try {
                object2 = this.method.getDeclaringClass().coerceFromObject(objectArray[0]);
            }
            catch (ClassCastException classCastException) {
                return -786431;
            }
        } else {
            object2 = null;
        }
        for (int i = n4; i < objectArray.length; ++i) {
            object3 = objectArray[i];
            Type type4 = type = i < n2 ? this.argTypes[i - n4] : type2;
            if (type != gnu.bytecode.Type.objectType) {
                try {
                    object3 = ((gnu.bytecode.Type)type).coerceFromObject(object3);
                }
                catch (ClassCastException classCastException) {
                    return 0xFFF40000 | i + 1;
                }
            }
            if (i < n2) {
                objectArray3[i - n4] = object3;
                continue;
            }
            if (objectArray2 == null) continue;
            objectArray2[i - n2] = object3;
        }
        callContext.value1 = object2;
        callContext.values = objectArray3;
        callContext.proc = this;
        return 0;
    }

    public void apply(CallContext callContext) throws Throwable {
        int n = this.argTypes.length;
        boolean bl = this.isConstructor();
        boolean bl2 = bl && this.method.getDeclaringClass().hasOuterLink();
        try {
            int n2;
            Object object2;
            Object object3;
            if (this.member == null) {
                object3 = this.method.getDeclaringClass().getReflectClass();
                object2 = new Class[n + (bl2 ? 1 : 0)];
                n2 = n;
                while (--n2 >= 0) {
                    object2[n2 + (bl2 ? 1 : 0)] = this.argTypes[n2].getReflectClass();
                }
                if (bl2) {
                    object2[0] = this.method.getDeclaringClass().getOuterLinkType().getReflectClass();
                }
                if (bl) {
                    this.member = ((Class)object3).getConstructor((Class<?>)object2);
                } else if (this.method != gnu.bytecode.Type.clone_method) {
                    this.member = ((Class)object3).getMethod(this.method.getName(), (Class<?>)object2);
                }
            }
            if (bl) {
                object2 = callContext.values;
                if (bl2) {
                    n2 = ((Object[])object2).length + 1;
                    Object[] objectArray = new Object[n2];
                    System.arraycopy(object2, 0, objectArray, 1, n2 - 1);
                    objectArray[0] = ((PairClassType)callContext.value1).staticLink;
                    object2 = objectArray;
                }
                object3 = ((Constructor)this.member).newInstance((Object[])object2);
            } else if (this.method == gnu.bytecode.Type.clone_method) {
                object2 = callContext.value1;
                Class<?> clazz = object2.getClass().getComponentType();
                int n3 = Array.getLength(object2);
                object3 = Array.newInstance(clazz, n3);
                System.arraycopy(object2, 0, object3, 0, n3);
            } else {
                object3 = this.retType.coerceToObject(((java.lang.reflect.Method)this.member).invoke(callContext.value1, callContext.values));
            }
            if (!this.takesContext()) {
                callContext.consumer.writeObject(object3);
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            throw invocationTargetException.getTargetException();
        }
    }

    public PrimProcedure(String string, String string2, int n) {
        this(ClassType.make(string).getDeclaredMethod(string2, n));
    }

    public PrimProcedure(java.lang.reflect.Method method, Language language) {
        this(((ClassType)language.getTypeFor(method.getDeclaringClass())).getMethod(method), language);
    }

    public PrimProcedure(Method method) {
        this.init(method);
        this.retType = method.getName().endsWith("$X") ? gnu.bytecode.Type.objectType : method.getReturnType();
    }

    public PrimProcedure(Method method, Language language) {
        this(method, '\u0000', language);
    }

    public PrimProcedure(Method method, char c, Language language) {
        this.mode = c;
        this.init(method);
        gnu.bytecode.Type[] typeArray = this.argTypes;
        int n = typeArray.length;
        this.argTypes = null;
        int n2 = n;
        while (--n2 >= 0) {
            gnu.bytecode.Type type;
            gnu.bytecode.Type type2 = typeArray[n2];
            if (type2 instanceof ClassType && !((ClassType)type2).isExisting() || type2 == (type = language.getLangTypeFor(type2))) continue;
            if (this.argTypes == null) {
                this.argTypes = new gnu.bytecode.Type[n];
                System.arraycopy(typeArray, 0, this.argTypes, 0, n);
            }
            this.argTypes[n2] = type;
        }
        if (this.argTypes == null) {
            this.argTypes = typeArray;
        }
        if (this.isConstructor()) {
            this.retType = method.getDeclaringClass();
        } else if (method.getName().endsWith("$X")) {
            this.retType = gnu.bytecode.Type.objectType;
        } else {
            this.retType = language.getLangTypeFor(method.getReturnType());
            if (this.retType == gnu.bytecode.Type.toStringType) {
                this.retType = gnu.bytecode.Type.javalangStringType;
            }
        }
    }

    private void init(Method method) {
        gnu.bytecode.Type[] typeArray;
        this.method = method;
        int n = method.getModifiers();
        if ((n & 8) != 0) {
            this.op_code = 184;
        } else {
            typeArray = method.getDeclaringClass();
            if (this.mode == 'P') {
                this.op_code = 183;
            } else {
                this.mode = (char)86;
                this.op_code = "<init>".equals(method.getName()) ? 183 : ((typeArray.getModifiers() & 0x200) != 0 ? 185 : 182);
            }
        }
        typeArray = method.getParameterTypes();
        if (this.isConstructor() && method.getDeclaringClass().hasOuterLink()) {
            int n2 = typeArray.length - 1;
            gnu.bytecode.Type[] typeArray2 = new gnu.bytecode.Type[n2];
            System.arraycopy(typeArray, 1, typeArray2, 0, n2);
            typeArray = typeArray2;
        }
        this.argTypes = typeArray;
    }

    public PrimProcedure(Method method, LambdaExp lambdaExp) {
        this(method);
        this.retType = lambdaExp.getReturnType();
        this.source = lambdaExp;
    }

    public PrimProcedure(int n, gnu.bytecode.Type type, gnu.bytecode.Type[] typeArray) {
        this.op_code = n;
        this.retType = type;
        this.argTypes = typeArray;
    }

    public static PrimProcedure makeBuiltinUnary(int n, gnu.bytecode.Type type) {
        gnu.bytecode.Type[] typeArray = new gnu.bytecode.Type[]{type};
        return new PrimProcedure(n, type, typeArray);
    }

    public static PrimProcedure makeBuiltinBinary(int n, gnu.bytecode.Type type) {
        gnu.bytecode.Type[] typeArray = new gnu.bytecode.Type[]{type, type};
        return new PrimProcedure(n, type, typeArray);
    }

    public PrimProcedure(int n, ClassType classType, String string, gnu.bytecode.Type type, gnu.bytecode.Type[] typeArray) {
        this.op_code = n;
        this.method = classType.addMethod(string, n == 184 ? 8 : 0, typeArray, type);
        this.retType = type;
        this.argTypes = typeArray;
        this.mode = (char)(n == 184 ? 0 : 86);
    }

    public final boolean getStaticFlag() {
        return this.method == null || this.method.getStaticFlag() || this.isConstructor();
    }

    public final gnu.bytecode.Type[] getParameterTypes() {
        return this.argTypes;
    }

    private void compileArgs(Expression[] expressionArray, int n, gnu.bytecode.Type type, Compilation compilation) {
        Object object2;
        boolean bl = this.takesVarArgs();
        String string = this.getName();
        gnu.bytecode.Type type2 = null;
        CodeAttr codeAttr = compilation.getCode();
        int n2 = type == gnu.bytecode.Type.voidType ? 1 : 0;
        int n3 = this.argTypes.length - n2;
        if (this.takesContext()) {
            --n3;
        }
        int n4 = expressionArray.length - n;
        boolean bl2 = type == null || n2 != 0;
        boolean bl3 = false;
        if (bl && (this.method.getModifiers() & 0x80) != 0 && n4 > 0 && this.argTypes.length > 0 && n4 == n3 + (bl2 ? 0 : 1)) {
            gnu.bytecode.Type type3 = expressionArray[expressionArray.length - 1].getType();
            object2 = this.argTypes[this.argTypes.length - 1];
            if (type3 instanceof ObjectType && object2 instanceof ArrayType && !(((ArrayType)object2).getComponentType() instanceof ArrayType)) {
                if (!(type3 instanceof ArrayType)) {
                    bl3 = true;
                }
                bl = false;
            }
        }
        int n5 = bl ? n3 - (bl2 ? 1 : 0) : expressionArray.length - n;
        Object object3 = object2 = this.source == null ? null : this.source.firstDecl();
        if (object2 != null && ((Declaration)object2).isThisParameter()) {
            object2 = ((Declaration)object2).nextDecl();
        }
        int n6 = 0;
        while (true) {
            boolean bl4;
            if (bl && n6 == n5) {
                type2 = this.argTypes[n3 - 1 + n2];
                if (type2 == Compilation.scmListType || type2 == LangObjType.listType) {
                    MakeList.compile(expressionArray, n + n6, compilation);
                    break;
                }
                codeAttr.emitPushInt(expressionArray.length - n - n5);
                type2 = ((ArrayType)type2).getComponentType();
                codeAttr.emitNewArray(type2);
            }
            if (n6 >= n4) break;
            boolean bl5 = bl4 = bl3 && n6 + 1 == n4;
            if (n6 >= n5) {
                codeAttr.emitDup(1);
                codeAttr.emitPushInt(n6 - n5);
            } else {
                type2 = object2 != null && (bl2 || n6 > 0) ? ((Declaration)object2).getType() : (bl2 ? this.argTypes[n6 + n2] : (n6 == 0 ? type : this.argTypes[n6 - 1]));
            }
            compilation.usedClass(type2);
            gnu.bytecode.Type type4 = bl4 ? gnu.bytecode.Type.objectType : type2;
            Target target = this.source == null ? CheckedTarget.getInstance(type4, string, n6 + 1) : CheckedTarget.getInstance(type4, this.source, n6);
            expressionArray[n + n6].compileNotePosition(compilation, target, expressionArray[n + n6]);
            if (bl4) {
                gnu.bytecode.Type type5 = ((ArrayType)type2).getComponentType();
                codeAttr.emitDup();
                codeAttr.emitInstanceof(type2);
                codeAttr.emitIfIntNotZero();
                codeAttr.emitCheckcast(type2);
                codeAttr.emitElse();
                codeAttr.emitPushInt(1);
                codeAttr.emitNewArray(type5);
                codeAttr.emitDupX();
                codeAttr.emitSwap();
                codeAttr.emitPushInt(0);
                codeAttr.emitSwap();
                type5.emitCoerceFromObject(codeAttr);
                codeAttr.emitArrayStore(type2);
                codeAttr.emitFi();
            }
            if (n6 >= n5) {
                codeAttr.emitArrayStore(type2);
            }
            if (object2 != null && (bl2 || n6 > 0)) {
                object2 = ((Declaration)object2).nextDecl();
            }
            ++n6;
        }
    }

    public void compile(ApplyExp applyExp, Compilation compilation, Target target) {
        String string;
        CodeAttr codeAttr = compilation.getCode();
        ClassType classType = this.method == null ? null : this.method.getDeclaringClass();
        Expression[] expressionArray = applyExp.getArgs();
        if (this.isConstructor()) {
            codeAttr.emitNew(classType);
            codeAttr.emitDup(classType);
        }
        if ((string = WrongArguments.checkArgCount(this, expressionArray.length)) != null) {
            compilation.error('e', string);
        }
        this.compile(this.getStaticFlag() ? null : classType, applyExp, compilation, target);
    }

    void compile(gnu.bytecode.Type type, ApplyExp applyExp, Compilation compilation, Target target) {
        Expression[] expressionArray = applyExp.getArgs();
        CodeAttr codeAttr = compilation.getCode();
        gnu.bytecode.Type type2 = this.retType;
        int n = 0;
        if (this.isConstructor()) {
            ClassType classType;
            ClassType classType2 = classType = this.method == null ? null : this.method.getDeclaringClass();
            if (classType.hasOuterLink()) {
                ClassExp.loadSuperStaticLink(expressionArray[0], classType, compilation);
            }
            type = null;
            n = 1;
        } else if (this.takesTarget() && this.method.getStaticFlag()) {
            n = 1;
        }
        this.compileArgs(expressionArray, n, type, compilation);
        if (this.method == null) {
            codeAttr.emitPrimop(this.opcode(), expressionArray.length, this.retType);
            target.compileFromStack(compilation, type2);
        } else {
            PrimProcedure.compileInvoke(compilation, this.method, target, applyExp.isTailCall(), this.op_code, type2);
        }
    }

    public static void compileInvoke(Compilation compilation, Method method, Target target, boolean bl, int n, gnu.bytecode.Type type) {
        CodeAttr codeAttr = compilation.getCode();
        compilation.usedClass(method.getDeclaringClass());
        compilation.usedClass(method.getReturnType());
        if (!PrimProcedure.takesContext(method)) {
            codeAttr.emitInvokeMethod(method, n);
        } else {
            if (target instanceof IgnoreTarget || target instanceof ConsumerTarget && ((ConsumerTarget)target).isContextTarget()) {
                Field field = null;
                Variable variable = null;
                compilation.loadCallContext();
                if (target instanceof IgnoreTarget) {
                    ClassType classType = Compilation.typeCallContext;
                    field = classType.getDeclaredField("consumer");
                    codeAttr.pushScope();
                    variable = codeAttr.addLocal(classType);
                    codeAttr.emitDup();
                    codeAttr.emitGetField(field);
                    codeAttr.emitStore(variable);
                    codeAttr.emitDup();
                    codeAttr.emitGetStatic(ClassType.make("gnu.lists.VoidConsumer").getDeclaredField("instance"));
                    codeAttr.emitPutField(field);
                }
                codeAttr.emitInvokeMethod(method, n);
                if (bl) {
                    compilation.loadCallContext();
                    codeAttr.emitInvoke(Compilation.typeCallContext.getDeclaredMethod("runUntilDone", 0));
                }
                if (target instanceof IgnoreTarget) {
                    compilation.loadCallContext();
                    codeAttr.emitLoad(variable);
                    codeAttr.emitPutField(field);
                    codeAttr.popScope();
                }
                return;
            }
            compilation.loadCallContext();
            type = gnu.bytecode.Type.objectType;
            codeAttr.pushScope();
            Variable variable = codeAttr.addLocal(gnu.bytecode.Type.intType);
            compilation.loadCallContext();
            codeAttr.emitInvokeVirtual(Compilation.typeCallContext.getDeclaredMethod("startFromContext", 0));
            codeAttr.emitStore(variable);
            codeAttr.emitWithCleanupStart();
            codeAttr.emitInvokeMethod(method, n);
            codeAttr.emitWithCleanupCatch(null);
            compilation.loadCallContext();
            codeAttr.emitLoad(variable);
            codeAttr.emitInvokeVirtual(Compilation.typeCallContext.getDeclaredMethod("cleanupFromContext", 1));
            codeAttr.emitWithCleanupDone();
            compilation.loadCallContext();
            codeAttr.emitLoad(variable);
            codeAttr.emitInvokeVirtual(Compilation.typeCallContext.getDeclaredMethod("getFromContext", 1));
            codeAttr.popScope();
        }
        target.compileFromStack(compilation, type);
    }

    public gnu.bytecode.Type getParameterType(int n) {
        int n2;
        if (this.takesTarget()) {
            if (n == 0) {
                return this.isConstructor() ? gnu.bytecode.Type.objectType : this.method.getDeclaringClass();
            }
            --n;
        }
        if (n < (n2 = this.argTypes.length) - 1) {
            return this.argTypes[n];
        }
        boolean bl = this.takesVarArgs();
        if (n < n2 && !bl) {
            return this.argTypes[n];
        }
        gnu.bytecode.Type type = this.argTypes[n2 - 1];
        if (type instanceof ArrayType) {
            return ((ArrayType)type).getComponentType();
        }
        return gnu.bytecode.Type.objectType;
    }

    public static PrimProcedure getMethodFor(Procedure procedure, Expression[] expressionArray) {
        return PrimProcedure.getMethodFor(procedure, null, expressionArray, Language.getDefaultLanguage());
    }

    public static PrimProcedure getMethodFor(Procedure procedure, Declaration declaration, Expression[] expressionArray, Language language) {
        int n = expressionArray.length;
        gnu.bytecode.Type[] typeArray = new gnu.bytecode.Type[n];
        int n2 = n;
        while (--n2 >= 0) {
            typeArray[n2] = expressionArray[n2].getType();
        }
        return PrimProcedure.getMethodFor(procedure, declaration, typeArray, language);
    }

    public static PrimProcedure getMethodFor(Procedure procedure, Declaration declaration, gnu.bytecode.Type[] typeArray, Language language) {
        Object object2;
        if (procedure instanceof GenericProc) {
            object2 = (GenericProc)procedure;
            MethodProc[] methodProcArray = ((GenericProc)object2).methods;
            procedure = null;
            int n = ((GenericProc)object2).count;
            while (--n >= 0) {
                int n2 = methodProcArray[n].isApplicable(typeArray);
                if (n2 < 0) continue;
                if (procedure != null) {
                    return null;
                }
                procedure = methodProcArray[n];
            }
            if (procedure == null) {
                return null;
            }
        }
        if (procedure instanceof PrimProcedure && ((PrimProcedure)(object2 = (PrimProcedure)procedure)).isApplicable(typeArray) >= 0) {
            return object2;
        }
        object2 = PrimProcedure.getProcedureClass(procedure);
        if (object2 == null) {
            return null;
        }
        return PrimProcedure.getMethodFor((ClassType)gnu.bytecode.Type.make((Class)object2), procedure.getName(), declaration, typeArray, language);
    }

    public static Class getProcedureClass(Object object2) {
        Class<?> clazz = object2 instanceof ModuleMethod ? ((ModuleMethod)object2).module.getClass() : object2.getClass();
        try {
            if (clazz.getClassLoader() == systemClassLoader) {
                return clazz;
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return null;
    }

    public static PrimProcedure getMethodFor(Class clazz, String string, Declaration declaration, Expression[] expressionArray, Language language) {
        return PrimProcedure.getMethodFor((ClassType)gnu.bytecode.Type.make(clazz), string, declaration, expressionArray, language);
    }

    public static PrimProcedure getMethodFor(ClassType classType, String string, Declaration declaration, Expression[] expressionArray, Language language) {
        int n = expressionArray.length;
        gnu.bytecode.Type[] typeArray = new gnu.bytecode.Type[n];
        int n2 = n;
        while (--n2 >= 0) {
            typeArray[n2] = expressionArray[n2].getType();
        }
        return PrimProcedure.getMethodFor(classType, string, declaration, typeArray, language);
    }

    public static PrimProcedure getMethodFor(ClassType classType, String string, Declaration declaration, gnu.bytecode.Type[] typeArray, Language language) {
        PrimProcedure primProcedure = null;
        int n = -1;
        boolean bl = false;
        try {
            if (string == null) {
                return null;
            }
            String string2 = Compilation.mangleName(string);
            String string3 = string2 + "$V";
            String string4 = string2 + "$V$X";
            String string5 = string2 + "$X";
            boolean bl2 = true;
            for (Method method = classType.getDeclaredMethods(); method != null; method = method.getNext()) {
                boolean bl3;
                int n2 = method.getModifiers();
                if ((n2 & 9) != 9 && (declaration == null || declaration.base == null)) continue;
                String string6 = method.getName();
                if (string6.equals(string2) || string6.equals(string3) || string6.equals(string5) || string6.equals(string4)) {
                    bl3 = false;
                } else {
                    if (!bl2 || !string6.equals("apply") && !string6.equals("apply$V")) continue;
                    bl3 = true;
                }
                if (!bl3) {
                    bl2 = false;
                    if (bl) {
                        primProcedure = null;
                        n = -1;
                        bl = false;
                    }
                }
                PrimProcedure primProcedure2 = new PrimProcedure(method, language);
                primProcedure2.setName(string);
                int n3 = primProcedure2.isApplicable(typeArray);
                if (n3 < 0 || n3 < n) continue;
                if (n3 > n) {
                    primProcedure = primProcedure2;
                } else if (primProcedure != null && (primProcedure = (PrimProcedure)MethodProc.mostSpecific(primProcedure, primProcedure2)) == null && n > 0) {
                    return null;
                }
                n = n3;
                bl = bl3;
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return primProcedure;
    }

    public String getName() {
        String string = super.getName();
        if (string != null) {
            return string;
        }
        string = this.getVerboseName();
        this.setName(string);
        return string;
    }

    public String getVerboseName() {
        StringBuffer stringBuffer = new StringBuffer(100);
        if (this.method == null) {
            stringBuffer.append("<op ");
            stringBuffer.append(this.op_code);
            stringBuffer.append('>');
        } else {
            stringBuffer.append(this.method.getDeclaringClass().getName());
            stringBuffer.append('.');
            stringBuffer.append(this.method.getName());
        }
        stringBuffer.append('(');
        for (int i = 0; i < this.argTypes.length; ++i) {
            if (i > 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append(this.argTypes[i].getName());
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append(this.retType.getName());
        stringBuffer.append(' ');
        stringBuffer.append(this.getVerboseName());
        return stringBuffer.toString();
    }

    public void print(PrintWriter printWriter) {
        printWriter.print("#<primitive procedure ");
        printWriter.print(this.toString());
        printWriter.print('>');
    }
}

