/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.servlet;

import gnu.expr.Language;
import gnu.kawa.servlet.MyTtyInPort;
import gnu.kawa.servlet.OutBufferWriter;
import gnu.mapping.Environment;
import gnu.mapping.Future;
import gnu.mapping.InPort;
import gnu.mapping.OutPort;
import gnu.text.QueueReader;
import kawa.repl;
import kawa.standard.Scheme;

public class ReplSession {
    Language language;
    Environment penvironment;
    QueueReader qreader;
    InPort in_p;
    OutPort err_p;
    OutPort out_p;
    OutBufferWriter prompt_p;
    Future thread;
    StringBuffer outBuffer = new StringBuffer();
    char outBufferState;
    boolean outAvailable;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void appendOutput(char c, char c2) {
        ReplSession replSession = this;
        synchronized (replSession) {
            this.appendOutputRaw(c, c2);
        }
    }

    void appendOutputRaw(char c, char c2) {
        if (this.outBufferState != '\u0000' && this.outBufferState != 'R' && this.outBufferState != c2) {
            this.outBuffer.append("</span>");
            this.outBufferState = '\u0000';
        }
        if (c2 == 'R') {
            this.outBuffer.append(c);
            this.outBufferState = c2;
        } else if (c == '\n' || c == '\r') {
            this.outBuffer.append("<br />");
        } else {
            if (this.outBufferState != c2) {
                if (c2 == 'O') {
                    this.outBuffer.append("<span std=\"output\">");
                } else if (c2 == 'E') {
                    this.outBuffer.append("<span std=\"error\">");
                } else if (c2 == 'P') {
                    this.outBuffer.append("<span std=\"prompt\">");
                }
                this.outBufferState = c2;
            }
            if (c == '&') {
                this.outBuffer.append("&amp;");
            } else if (c == '<') {
                this.outBuffer.append("&lt;");
            } else if (c == '>') {
                this.outBuffer.append("&gt;");
            } else {
                this.outBuffer.append(c);
            }
        }
    }

    public void appendOutputRaw(String string, int n, int n2, char c) {
        for (int i = 0; i < n2; ++i) {
            this.appendOutputRaw(string.charAt(n + i), c);
        }
    }

    public void appendOutputRaw(String string, char c) {
        this.appendOutputRaw(string, 0, string.length(), c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String grabOutput() {
        ReplSession replSession = this;
        synchronized (replSession) {
            return this.grabOutputRaw();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String waitOutput() {
        ReplSession replSession = this;
        synchronized (replSession) {
            if (!this.outAvailable) {
                try {
                    this.wait(30000L);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
            String string = this.grabOutputRaw();
            return string;
        }
    }

    String grabOutputRaw() {
        if (this.outBufferState != '\u0000' && this.outBufferState != 'R') {
            this.outBuffer.append("</span>");
            this.outBufferState = '\u0000';
        }
        String string = this.outBuffer.toString();
        this.outBuffer.setLength(0);
        this.outAvailable = false;
        return string;
    }

    public ReplSession() {
        this(Scheme.getInstance());
    }

    public ReplSession(Language language) {
        if (Language.getDefaultLanguage() == null) {
            Language.setDefaults(language);
        }
        this.penvironment = Environment.getCurrent();
        this.qreader = new QueueReader();
        this.out_p = new OutPort(new OutBufferWriter(this, 'O'), true, true, "<stdout>");
        this.err_p = new OutPort(new OutBufferWriter(this, 'E'), true, true, "<stderr>");
        this.prompt_p = new OutBufferWriter(this, 'P');
        this.in_p = new MyTtyInPort(this.qreader, "<stdin>", this.out_p, this);
        this.thread = new Future(new repl(language), this.penvironment, this.in_p, this.out_p, this.err_p);
        this.thread.start();
    }

    void appendInputLine(String string) {
        this.qreader.append(string);
        this.qreader.append('\n');
    }
}

