/*
 * Decompiled with CFR 0.152.
 */
package gnu.lists;

import gnu.lists.Consumer;
import gnu.lists.Convert;
import gnu.lists.Sequence;
import gnu.lists.SimpleVector;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;

public class F32Vector
extends SimpleVector
implements Externalizable {
    float[] data;
    protected static float[] empty = new float[0];

    public F32Vector() {
        this.data = empty;
    }

    public F32Vector(int n, float f) {
        float[] fArray = new float[n];
        this.data = fArray;
        this.size = n;
        while (--n >= 0) {
            fArray[n] = f;
        }
    }

    public F32Vector(int n) {
        this.data = new float[n];
        this.size = n;
    }

    public F32Vector(float[] fArray) {
        this.data = fArray;
        this.size = fArray.length;
    }

    public F32Vector(Sequence sequence) {
        this.data = new float[sequence.size()];
        this.addAll((Collection)sequence);
    }

    public int getBufferLength() {
        return this.data.length;
    }

    public void setBufferLength(int n) {
        int n2 = this.data.length;
        if (n2 != n) {
            float[] fArray = new float[n];
            System.arraycopy(this.data, 0, fArray, 0, n2 < n ? n2 : n);
            this.data = fArray;
        }
    }

    protected Object getBuffer() {
        return this.data;
    }

    public final int intAtBuffer(int n) {
        return (int)this.data[n];
    }

    public final float floatAt(int n) {
        if (n >= this.size) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.data[n];
    }

    public final float floatAtBuffer(int n) {
        return this.data[n];
    }

    public final Object get(int n) {
        if (n > this.size) {
            throw new IndexOutOfBoundsException();
        }
        return Convert.toObject(this.data[n]);
    }

    public final Object getBuffer(int n) {
        return Convert.toObject(this.data[n]);
    }

    public final void setFloatAt(int n, float f) {
        if (n > this.size) {
            throw new IndexOutOfBoundsException();
        }
        this.data[n] = f;
    }

    public final void setFloatAtBuffer(int n, float f) {
        this.data[n] = f;
    }

    public final Object setBuffer(int n, Object object2) {
        Object object3 = Convert.toObject(this.data[n]);
        this.data[n] = Convert.toFloat(object2);
        return object3;
    }

    protected void clearBuffer(int n, int n2) {
        while (--n2 >= 0) {
            this.data[n++] = 0.0f;
        }
    }

    public int getElementKind() {
        return 25;
    }

    public String getTag() {
        return "f32";
    }

    public boolean consumeNext(int n, Consumer consumer) {
        int n2 = n >>> 1;
        if (n2 >= this.size) {
            return false;
        }
        consumer.writeFloat(this.data[n2]);
        return true;
    }

    public void consumePosRange(int n, int n2, Consumer consumer) {
        if (consumer.ignoring()) {
            return;
        }
        int n3 = n >>> 1;
        int n4 = n2 >>> 1;
        while (n3 < n4) {
            consumer.writeFloat(this.data[n3]);
            ++n3;
        }
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        int n = this.size;
        objectOutput.writeInt(n);
        int n2 = 0;
        while (n2 < n) {
            objectOutput.writeFloat(this.data[n2]);
            ++n2;
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        float[] fArray = new float[n];
        int n2 = 0;
        while (n2 < n) {
            fArray[n2] = objectInput.readFloat();
            ++n2;
        }
        this.data = fArray;
        this.size = n;
    }
}

