/*
 * Decompiled with CFR 0.152.
 */
package gnu.jemacs.buffer;

import gnu.jemacs.buffer.Buffer;
import gnu.jemacs.buffer.EToolkit;
import gnu.jemacs.buffer.Marker;
import java.awt.Color;
import java.io.Writer;

public class BufferWriter
extends Writer
implements Runnable {
    Marker marker;
    Object style;
    Object stylePlain;
    boolean adjustPoint;
    static final int NO_ESCAPES_STATE = 1;
    static final int NORMAL_STATE = 0;
    static final int LAST_COLUMN_STATE = 1;
    static final int SEEN_ESC_STATE = 2;
    static final int SEEN_ESC_LBRAC_STATE = 3;
    static final int SEEN_ESC_RBRAC_STATE = 4;
    int state = 0;
    static final int ESC = 27;
    boolean insertMode = false;
    char[] savedOutput;
    int savedCount;
    boolean bold = false;
    boolean underline = false;
    boolean blink = false;
    boolean inverse;
    boolean invisible;
    String foregroundName;
    String backgroundName;
    Color foreground;
    Color background;
    StringBuffer styleNameBuf;
    String styleName;
    private String name;
    private Color color;
    char[] buf1 = new char[1];
    char[] buffer;
    int count;

    public BufferWriter(Marker marker, boolean bl) {
        this.marker = marker;
        EToolkit eToolkit = EToolkit.getInstance();
        this.style = this.stylePlain = eToolkit.getFace("output", true);
        this.adjustPoint = bl;
    }

    public BufferWriter(Buffer buffer) {
        this(buffer.pointMarker, false);
    }

    void resetAttributes() {
        this.bold = false;
        this.underline = false;
        this.blink = false;
        this.inverse = false;
        this.invisible = false;
        this.foregroundName = null;
        this.backgroundName = null;
        this.foreground = null;
        this.background = null;
    }

    void updateStyle() {
        int n;
        if (this.styleNameBuf == null) {
            this.styleNameBuf = new StringBuffer(60);
        }
        this.styleNameBuf.setLength(0);
        if (this.underline) {
            this.styleNameBuf.append("underlined,");
        }
        if (this.bold) {
            this.styleNameBuf.append("bold,");
        }
        if (this.foreground != null) {
            this.styleNameBuf.append("fg=");
            this.styleNameBuf.append(this.foregroundName != null ? this.foregroundName : this.foreground.toString());
            this.styleNameBuf.append(',');
        }
        if (this.background != null) {
            this.styleNameBuf.append("bg=");
            this.styleNameBuf.append(this.backgroundName != null ? this.backgroundName : this.background.toString());
            this.styleNameBuf.append(',');
        }
        if ((n = this.styleNameBuf.length()) == 0) {
            this.style = this.stylePlain;
            this.styleName = "output";
            return;
        }
        this.styleNameBuf.setLength(n - 1);
        this.styleName = this.styleNameBuf.toString();
        EToolkit eToolkit = EToolkit.getInstance();
        this.style = eToolkit.getFace(this.styleName, false);
        if (this.style != null) {
            return;
        }
        this.style = eToolkit.getFace(this.styleName, true);
        eToolkit.setUnderline(this.style, this.underline);
        eToolkit.setBold(this.style, this.bold);
        if (this.foreground != null) {
            eToolkit.setForeground(this.style, this.foreground);
        }
        if (this.background != null) {
            eToolkit.setBackground(this.style, this.background);
        }
    }

    private void getColor(int n, boolean bl) {
        switch (n) {
            case 0: {
                this.color = Color.black;
                this.name = "black";
                break;
            }
            case 1: {
                this.color = Color.red;
                this.name = "red";
                break;
            }
            case 2: {
                this.color = Color.green;
                this.name = "green";
                break;
            }
            case 3: {
                this.color = Color.yellow;
                this.name = "yellow";
                break;
            }
            case 4: {
                this.color = Color.blue;
                this.name = "blue";
                break;
            }
            case 5: {
                this.color = Color.magenta;
                this.name = "magenta";
                break;
            }
            case 6: {
                this.color = Color.cyan;
                this.name = "cyan";
                break;
            }
            case 7: {
                this.color = Color.white;
                this.name = "white";
                break;
            }
            default: {
                this.color = null;
                this.name = null;
            }
        }
    }

    public int handleSetCharacterRendition(int n, int n2) {
        switch (n) {
            case -1: 
            case 0: {
                this.resetAttributes();
            }
            case 1: {
                this.bold = true;
                break;
            }
            case 4: {
                this.underline = true;
                break;
            }
            case 22: {
                this.bold = false;
                break;
            }
            case 24: {
                this.underline = false;
                break;
            }
            default: {
                if (n >= 30 && n <= 39) {
                    this.getColor(n - 30, false);
                    this.foreground = this.color;
                    this.foregroundName = this.name;
                    break;
                }
                if (n >= 40 && n <= 49) {
                    this.getColor(n - 40, false);
                    this.background = this.color;
                    this.backgroundName = this.name;
                    break;
                }
                if (n >= 90 && n <= 97) {
                    this.getColor(n - 90, true);
                    this.background = this.color;
                    this.backgroundName = this.name;
                    break;
                }
                if (n < 100 || n > 107) break;
                this.getColor(n - 100, true);
                this.background = this.color;
                this.backgroundName = this.name;
            }
        }
        return n2;
    }

    public void handleOperatingSystemCommand(char c) {
        if (c == '\u0007') {
            this.state = 0;
        } else if (this.savedCount >= this.savedOutput.length) {
            int n = 0;
            while (n < this.savedCount && this.savedOutput[n] != '\n') {
                ++n;
            }
            if (n < this.savedCount || c == '\n') {
                this.state = 0;
            } else {
                this.savedCount = 0;
            }
        } else {
            this.savedOutput[this.savedCount++] = c;
        }
    }

    public int handleCSICommand(char c, int n, int n2) {
        switch (c) {
            case 'C': {
                this.moveColumns(n > 0 ? n : 1);
                break;
            }
            case 'D': {
                this.moveColumns(-(n > 0 ? n : 1));
                break;
            }
            case 'h': {
                if (n != 4) break;
                this.insertMode = true;
                break;
            }
            case 'l': {
                if (n != 4) break;
                this.insertMode = false;
                break;
            }
            case 'm': {
                return this.handleSetCharacterRendition(n, n2);
            }
        }
        return n2;
    }

    public void handleEscapeBracket(char c) {
        if (c == ';' || c >= '0' && c <= '9') {
            if (this.savedCount >= this.savedOutput.length) {
                this.savedCount = 0;
            }
            this.savedOutput[this.savedCount++] = c;
        } else {
            int n = -1;
            int n2 = 0;
            while (n2 < this.savedCount) {
                c = this.savedOutput[n2];
                if (c >= '0' && c <= '9') {
                    n = (n <= 0 ? 0 : 10 * n) + (c - 48);
                } else {
                    n2 = this.handleCSICommand('m', n, n2);
                    n = -1;
                }
                ++n2;
            }
            this.handleCSICommand('m', n, this.savedCount);
            this.updateStyle();
            this.state = 0;
        }
    }

    public void unTabifyRestOfLine() {
    }

    public void removeChars(int n) {
        int n2 = this.marker.getOffset();
        this.moveColumns(n);
        this.marker.removeChar(this.marker.getOffset() - n2);
    }

    public void moveColumns(int n) {
        this.marker.moveToColumn(this.marker.currentColumn() + n, true);
    }

    public synchronized void put(char[] cArray, int n, int n2) {
        if (n2 == 0) {
            return;
        }
        if (this.insertMode) {
            this.unTabifyRestOfLine();
        } else {
            this.removeChars(n2);
        }
        boolean bl = this.adjustPoint && this.marker.getOffset() == this.marker.buffer.getDot();
        this.marker.insert(new String(cArray, n, n2), this.style);
        if (bl) {
            this.marker.buffer.setDot(this.marker.getOffset());
        }
    }

    public synchronized void write(int n) {
        boolean bl = this.marker.getOffset() == this.marker.buffer.getDot();
        this.write1(n);
        if (bl) {
            this.marker.buffer.setDot(this.marker.getOffset());
        }
    }

    public synchronized void write1(int n) {
        if (this.state <= 0) {
            if (n >= 32 || n == 10 || this.state < 0) {
                this.buf1[0] = (char)n;
                this.put(this.buf1, 0, 1);
            } else if (n == 27) {
                this.state = 2;
            } else if (n == 8) {
                this.moveColumns(-1);
            } else if (n == 9) {
                int n2 = this.marker.currentColumn();
                this.marker.moveToColumn(n2 + 8 - (n2 & 7), true);
            } else if (n != 13) {
                System.err.println("received ctrl-" + (char)(n + 64));
            }
        } else if (this.state == 2) {
            switch (n) {
                case 91: {
                    this.state = 3;
                    if (this.savedOutput == null) {
                        this.savedOutput = new char[100];
                    }
                    this.savedCount = 0;
                    break;
                }
                case 93: {
                    this.state = 4;
                    if (this.savedOutput == null) {
                        this.savedOutput = new char[100];
                    }
                    this.savedCount = 0;
                    break;
                }
                default: {
                    this.state = 0;
                    break;
                }
            }
        } else if (this.state == 3) {
            this.handleEscapeBracket((char)n);
        } else {
            this.handleOperatingSystemCommand((char)n);
        }
    }

    public synchronized void write(char[] cArray, int n, int n2) {
        boolean bl = this.marker.getOffset() == this.marker.buffer.getDot();
        while (n2 > 0) {
            int n3;
            if (this.state > 0) {
                this.write1(cArray[n++]);
                --n2;
                continue;
            }
            if (this.state == 1) {
                n3 = n2;
            } else {
                n3 = 0;
                while (n3 < n2) {
                    char c = cArray[n + n3];
                    if (c < ' ') break;
                    ++n3;
                }
            }
            if (n3 > 0) {
                this.put(cArray, n, n3);
                n += n3;
                n2 -= n3;
            }
            if (n3 >= n2) continue;
            this.write1(cArray[n++]);
            --n2;
        }
        if (bl) {
            this.marker.buffer.setDot(this.marker.getOffset());
        }
    }

    public synchronized void flush() {
    }

    public synchronized void close() {
    }

    public void run() {
        this.write(this.buffer, 0, this.count);
    }
}

