/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.reflect;

import gnu.bytecode.ClassType;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.Member;
import gnu.bytecode.Method;
import gnu.bytecode.ObjectType;
import gnu.bytecode.Type;
import gnu.expr.ApplyExp;
import gnu.expr.CanInline;
import gnu.expr.CheckedTarget;
import gnu.expr.ClassExp;
import gnu.expr.Compilation;
import gnu.expr.Expression;
import gnu.expr.InlineCalls;
import gnu.expr.Inlineable;
import gnu.expr.Language;
import gnu.expr.QuoteExp;
import gnu.expr.Target;
import gnu.kawa.reflect.Invoke;
import gnu.kawa.reflect.SlotGet;
import gnu.lists.FString;
import gnu.mapping.Procedure;
import gnu.mapping.Procedure3;
import gnu.mapping.Symbol;
import gnu.mapping.Values;
import gnu.mapping.WrappedException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import kawa.standard.Scheme;

public class SlotSet
extends Procedure3
implements CanInline,
Inlineable {
    boolean isStatic;
    boolean returnSelf;
    public static final SlotSet set$Mnfield$Ex = new SlotSet("set-field!", false);
    public static final SlotSet set$Mnstatic$Mnfield$Ex = new SlotSet("set-static-field!", true);
    public static final SlotSet setFieldReturnObject = new SlotSet("set-field-return-object!", false);

    public SlotSet(String name, boolean isStatic) {
        super(name);
        this.isStatic = isStatic;
    }

    public static void setField(Object obj, String name, Object value) {
        SlotSet.apply(false, obj, name, value);
    }

    public static void setStaticField(Object obj, String name, Object value) {
        SlotSet.apply(true, obj, name, value);
    }

    public static void apply(boolean isStatic, Object obj, String name, Object value) {
        Language language = Language.getDefaultLanguage();
        boolean illegalAccess = false;
        String fname = Compilation.mangleNameIfNeeded(name);
        Class<?> clas = isStatic ? SlotGet.coerceToClass(obj) : obj.getClass();
        try {
            Field field = clas.getField(fname);
            Class<?> ftype = field.getType();
            field.set(obj, language.coerceFromObject(ftype, value));
            return;
        }
        catch (NoSuchFieldException ex) {
        }
        catch (IllegalAccessException ex) {
            illegalAccess = true;
        }
        try {
            java.lang.reflect.Method getmethod = null;
            try {
                String getName = ClassExp.slotToMethodName("get", name);
                getmethod = clas.getMethod(getName, SlotGet.noClasses);
            }
            catch (Exception getEx) {
                String getName = ClassExp.slotToMethodName("is", name);
                getmethod = clas.getMethod(getName, SlotGet.noClasses);
            }
            String setName = ClassExp.slotToMethodName("set", name);
            Class[] setArgTypes = new Class[]{getmethod.getReturnType()};
            java.lang.reflect.Method setmethod = clas.getMethod(setName, setArgTypes);
            Object[] args = new Object[]{language.coerceFromObject(setArgTypes[0], value)};
            setmethod.invoke(obj, args);
            return;
        }
        catch (InvocationTargetException ex) {
            throw WrappedException.wrapIfNeeded(ex.getTargetException());
        }
        catch (IllegalAccessException ex) {
            illegalAccess = true;
        }
        catch (NoSuchMethodException ex) {
            // empty catch block
        }
        if (illegalAccess) {
            throw new RuntimeException("illegal access for field " + name);
        }
        throw new RuntimeException("no such field " + name + " in " + clas.getName());
    }

    public Object apply3(Object obj, Object fname, Object value) {
        SlotSet.apply(this.isStatic, obj, fname.toString(), value);
        return this.returnSelf ? obj : Values.empty;
    }

    public static Member lookupMember(ObjectType clas, String name, ClassType caller) {
        String setName;
        Method method;
        gnu.bytecode.Field field = clas.getField(Compilation.mangleNameIfNeeded(name), -1);
        if (field != null) {
            if (caller == null) {
                caller = Type.pointer_type;
            }
            if (caller.isAccessible(field, clas)) {
                return field;
            }
        }
        if ((method = clas.getMethod(setName = ClassExp.slotToMethodName("set", name), new Type[1])) == null) {
            return field;
        }
        return method;
    }

    static void compileSet(Procedure thisProc, ClassType ctype, Expression valArg, Object part, Compilation comp) {
        boolean isStatic;
        CodeAttr code = comp.getCode();
        Language language = comp.getLanguage();
        boolean bl = isStatic = thisProc instanceof SlotSet && ((SlotSet)thisProc).isStatic;
        if (part instanceof gnu.bytecode.Field) {
            gnu.bytecode.Field field = (gnu.bytecode.Field)part;
            boolean isStaticField = field.getStaticFlag();
            Type ftype = language.getLangTypeFor(field.getType());
            if (isStatic && !isStaticField) {
                comp.error('e', "cannot access non-static field `" + field.getName() + "' using `" + thisProc.getName() + '\'');
            }
            valArg.compile(comp, CheckedTarget.getInstance(ftype));
            if (isStaticField) {
                code.emitPutStatic(field);
            } else {
                code.emitPutField(field);
            }
            return;
        }
        if (part instanceof Method) {
            Method method = (Method)part;
            boolean isStaticMethod = method.getStaticFlag();
            if (isStatic && !isStaticMethod) {
                comp.error('e', "cannot call non-static getter method `" + method.getName() + "' using `" + thisProc.getName() + '\'');
            }
            Type[] setArgTypes = method.getParameterTypes();
            valArg.compile(comp, CheckedTarget.getInstance(language.getLangTypeFor(setArgTypes[0])));
            if (isStaticMethod) {
                code.emitInvokeStatic(method);
            } else {
                code.emitInvoke(method);
            }
            return;
        }
    }

    public Expression inline(ApplyExp exp, InlineCalls walker, boolean argsInlined) {
        exp.walkArgs(walker, argsInlined);
        if (this.isStatic && walker.getCompilation().mustCompile) {
            return Invoke.inlineClassName(exp, 0, walker);
        }
        return exp;
    }

    public void compile(ApplyExp exp, Compilation comp, Target target) {
        Expression[] args = exp.getArgs();
        int nargs = args.length;
        if (nargs != 3) {
            String msg = nargs < 3 ? "too few" : "too many";
            comp.error('e', msg + " arguments to `" + this.getName() + '\'');
            comp.compileConstant(null, target);
            return;
        }
        Expression arg0 = args[0];
        Expression arg1 = args[1];
        Expression value = args[2];
        Type type = this.isStatic ? Scheme.exp2Type(arg0) : arg0.getType();
        Member part = null;
        if (type instanceof ClassType && arg1 instanceof QuoteExp) {
            String name;
            ClassType caller;
            Object val1 = ((QuoteExp)arg1).getValue();
            ClassType ctype = (ClassType)type;
            ClassType classType = caller = comp.curClass != null ? comp.curClass : comp.mainClass;
            if (val1 instanceof String || val1 instanceof FString || val1 instanceof Symbol) {
                name = val1.toString();
                part = SlotSet.lookupMember(ctype, name, caller);
                if (part == null && type != Type.pointer_type) {
                    comp.error('e', "no slot `" + name + "' in " + ctype.getName());
                }
            } else if (val1 instanceof Member) {
                part = (Member)val1;
                name = part.getName();
            } else {
                name = null;
            }
            if (part != null) {
                boolean isStaticField;
                int modifiers = part.getModifiers();
                boolean bl = isStaticField = (modifiers & 8) != 0;
                if (caller != null && !caller.isAccessible(part, ctype)) {
                    comp.error('e', "slot '" + name + "' in " + part.getDeclaringClass().getName() + " not accessible here");
                }
                args[0].compile(comp, isStaticField ? Target.Ignore : Target.pushValue(ctype));
                if (this.returnSelf) {
                    comp.getCode().emitDup(ctype);
                }
                SlotSet.compileSet(this, ctype, args[2], part, comp);
                if (this.returnSelf) {
                    target.compileFromStack(comp, ctype);
                } else {
                    comp.compileConstant(Values.empty, target);
                }
                return;
            }
        }
        ApplyExp.compile(exp, comp, target);
    }

    public Type getReturnType(Expression[] args) {
        if (this.returnSelf && args.length == 3) {
            return args[0].getType();
        }
        return Type.void_type;
    }

    static {
        SlotSet.setFieldReturnObject.returnSelf = true;
    }
}

