/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.sat;

import java.util.Objects;
import org.chocosolver.sat.MiniSat;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.SetVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.util.ESat;

public interface Literalizer {
    public void svar(int var1);

    public int svar();

    public Variable cvar();

    public boolean canReact();

    public int toLit();

    public boolean toEvent(int var1, ICause var2) throws ContradictionException;

    public boolean check(boolean var1);

    public static class SetInLit
    implements Literalizer {
        public final SetVar cpVar;
        public final int val;
        public int satVar;

        public SetInLit(SetVar cpVar, int val) {
            this.cpVar = cpVar;
            this.val = val;
            this.satVar = -1;
        }

        @Override
        public void svar(int svar) {
            if (this.satVar != -1) {
                throw new UnsupportedOperationException("Overriding Literalizer's satVar is forbidden");
            }
            this.satVar = svar;
        }

        @Override
        public int svar() {
            return this.satVar;
        }

        @Override
        public Variable cvar() {
            return this.cpVar;
        }

        @Override
        public boolean canReact() {
            return this.cpVar.getLB().contains(this.val) || !this.cpVar.getUB().contains(this.val);
        }

        @Override
        public int toLit() {
            return MiniSat.makeLiteral(this.satVar, this.cpVar.getLB().contains(this.val));
        }

        @Override
        public boolean toEvent(int lit, ICause cause) throws ContradictionException {
            assert (this.satVar == MiniSat.var(lit));
            if (MiniSat.sgn(lit)) {
                return this.cpVar.force(this.val, cause);
            }
            return this.cpVar.remove(this.val, cause);
        }

        @Override
        public boolean check(boolean sign) {
            return sign ? this.cpVar.getLB().contains(this.val) : !this.cpVar.getUB().contains(this.val);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof SetInLit)) {
                return false;
            }
            SetInLit setInLit = (SetInLit)o;
            return this.val == setInLit.val && this.cpVar.equals(setInLit.cpVar);
        }

        public int hashCode() {
            return Objects.hash(this.cpVar, this.val);
        }
    }

    public static class IntLeLit
    implements Literalizer {
        public final IntVar cpVar;
        public final int val;
        public int satVar;

        public IntLeLit(IntVar cpVar, int val) {
            this.cpVar = cpVar;
            this.val = val;
            this.satVar = -1;
        }

        @Override
        public void svar(int svar) {
            if (this.satVar != -1) {
                throw new UnsupportedOperationException("Overriding Literalizer's satVar is forbidden");
            }
            this.satVar = svar;
        }

        @Override
        public int svar() {
            return this.satVar;
        }

        @Override
        public Variable cvar() {
            return this.cpVar;
        }

        @Override
        public boolean canReact() {
            return this.cpVar.getUB() <= this.val || this.cpVar.getLB() > this.val;
        }

        @Override
        public int toLit() {
            return MiniSat.makeLiteral(this.satVar, this.cpVar.getUB() <= this.val);
        }

        @Override
        public boolean toEvent(int lit, ICause cause) throws ContradictionException {
            assert (this.satVar == MiniSat.var(lit));
            if (MiniSat.sgn(lit)) {
                return this.cpVar.updateUpperBound(this.val, cause);
            }
            return this.cpVar.updateLowerBound(this.val + 1, cause);
        }

        @Override
        public boolean check(boolean sign) {
            return sign ? this.cpVar.getUB() <= this.val : this.cpVar.getLB() > this.val;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof IntLeLit)) {
                return false;
            }
            IntLeLit intLeLit = (IntLeLit)o;
            return this.val == intLeLit.val && this.satVar == intLeLit.satVar && this.cpVar.equals(intLeLit.cpVar);
        }

        public int hashCode() {
            return Objects.hash(this.cpVar, this.val);
        }
    }

    public static class IntEqLit
    implements Literalizer {
        public final IntVar cpVar;
        public final int val;
        public int satVar;

        public IntEqLit(IntVar cpVar, int val) {
            this.cpVar = cpVar;
            this.val = val;
            this.satVar = -1;
        }

        @Override
        public void svar(int svar) {
            if (this.satVar != -1) {
                throw new UnsupportedOperationException("Overriding Literalizer's satVar is forbidden");
            }
            this.satVar = svar;
        }

        @Override
        public int svar() {
            return this.satVar;
        }

        @Override
        public Variable cvar() {
            return this.cpVar;
        }

        @Override
        public boolean canReact() {
            return this.cpVar.isInstantiated() || !this.cpVar.contains(this.val);
        }

        @Override
        public int toLit() {
            return MiniSat.makeLiteral(this.satVar, this.cpVar.isInstantiatedTo(this.val));
        }

        @Override
        public boolean toEvent(int lit, ICause cause) throws ContradictionException {
            assert (this.satVar == MiniSat.var(lit));
            if (MiniSat.sgn(lit)) {
                return this.cpVar.instantiateTo(this.val, cause);
            }
            return this.cpVar.removeValue(this.val, cause);
        }

        @Override
        public boolean check(boolean sign) {
            return sign ? this.cpVar.isInstantiatedTo(this.val) : !this.cpVar.contains(this.val);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof IntEqLit)) {
                return false;
            }
            IntEqLit intEqLit = (IntEqLit)o;
            return this.val == intEqLit.val && this.cpVar.equals(intEqLit.cpVar);
        }

        public int hashCode() {
            return Objects.hash(this.cpVar, this.val);
        }
    }

    public static class BoolLit
    implements Literalizer {
        public final BoolVar cpVar;
        public int satVar;

        public BoolLit(BoolVar cpVar) {
            this.cpVar = cpVar;
            this.satVar = -1;
        }

        @Override
        public void svar(int svar) {
            if (this.satVar != -1) {
                throw new UnsupportedOperationException("Overriding Literalizer's satVar is forbidden");
            }
            this.satVar = svar;
        }

        @Override
        public int svar() {
            return this.satVar;
        }

        @Override
        public Variable cvar() {
            return this.cpVar;
        }

        @Override
        public boolean canReact() {
            return this.cpVar.isInstantiated();
        }

        @Override
        public int toLit() {
            return MiniSat.makeLiteral(this.satVar, this.cpVar.getValue() != 0);
        }

        @Override
        public boolean toEvent(int lit, ICause cause) throws ContradictionException {
            assert (this.satVar == MiniSat.var(lit));
            return this.cpVar.instantiateTo(MiniSat.sgn(lit) ? 1 : 0, cause);
        }

        @Override
        public boolean check(boolean sign) {
            return this.cpVar.getBooleanValue().equals((Object)ESat.eval(sign));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof BoolLit)) {
                return false;
            }
            BoolLit boolLit = (BoolLit)o;
            return this.cpVar.equals(boolLit.cpVar);
        }

        public int hashCode() {
            return Objects.hash(this.cpVar);
        }
    }
}

