/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.structgen.maygen;

import java.io.Closeable;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.atomic.AtomicInteger;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.group.Permutation;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.structgen.maygen.BoundaryConditions;
import org.openscience.cdk.structgen.maygen.Generation;
import org.openscience.cdk.structgen.maygen.HydrogenDistributor;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;

public class Maygen {
    private final ILoggingTool logger = LoggingToolFactory.createLoggingTool(Maygen.class);
    public static final Consumer NOOP_CONSUMER = mol -> {};
    private static final String NUMBERS_FROM_0_TO_9 = "(?=[0-9])";
    private static final String LETTERS_FROM_A_TO_Z = "(?=[A-Z])";
    private static final String THE_INPUT_FORMULA = "The input formula, ";
    private static final String DOES_NOT_REPRESENT_ANY_MOLECULE = ", does not represent any molecule.";
    private final Map<String, Integer> valences;
    private int size = 0;
    private int total = 0;
    private Consumer consumer = NOOP_CONSUMER;
    private boolean tsvoutput = false;
    private boolean setElement = false;
    private boolean boundary = false;
    private boolean multiThread = false;
    private boolean verbose = false;
    private String formula;
    private String fuzzyFormula;
    private int hIndex = 0;
    private final AtomicInteger count = new AtomicInteger();
    private int fuzzyCount = 0;
    private int matrixSize = 0;
    private List<String> symbols = new ArrayList<String>();
    private int[] occurrences;
    private int[] nodeLabels;
    private int graphSize;
    private List<int[]> oxygenSulfur = new ArrayList<int[]>();
    private int[] firstDegrees;
    private int totalHydrogen = 0;
    private List<String> firstSymbols = new ArrayList<String>();
    private int[] firstOccurrences;
    private boolean callHydrogenDistributor = false;
    private boolean justH = false;
    private boolean noHydrogen = false;
    private int sizePart = 0;
    private boolean singleAtom = true;
    private boolean onlyDegree2 = true;
    private boolean onSm = true;
    private int oxygen = 0;
    private int sulfur = 0;
    private String[] symbolArray;
    private final IChemObjectBuilder builder;
    private IAtomContainer atomContainer;

    public Maygen(IChemObjectBuilder builder) {
        this.builder = builder;
        this.atomContainer = builder.newAtomContainer();
        this.valences = new HashMap<String, Integer>();
        this.valences.put("C", 4);
        this.valences.put("N", 3);
        this.valences.put("O", 2);
        this.valences.put("S", 2);
        this.valences.put("P", 3);
        this.valences.put("F", 1);
        this.valences.put("I", 1);
        this.valences.put("Cl", 1);
        this.valences.put("Br", 1);
        this.valences.put("H", 1);
    }

    public int getSize() {
        return this.size;
    }

    public boolean isBoundary() {
        return this.boundary;
    }

    public void setBoundary(boolean boundary) {
        this.boundary = boundary;
    }

    public void setConsumer(Consumer consumer) {
        this.consumer = consumer;
    }

    public Consumer getConsumer() {
        return this.consumer;
    }

    public boolean isSetElement() {
        return this.setElement;
    }

    public void setSetElement(boolean setElement) {
        this.setElement = setElement;
    }

    public boolean isTsvoutput() {
        return this.tsvoutput;
    }

    public void setTsvoutput(boolean tsvoutput) {
        this.tsvoutput = tsvoutput;
    }

    public String[] getSymbolArray() {
        return this.symbolArray;
    }

    public IChemObjectBuilder getBuilder() {
        return this.builder;
    }

    public boolean isMultiThread() {
        return this.multiThread;
    }

    public void setMultiThread(boolean multiThread) {
        this.multiThread = multiThread;
    }

    public int getCount() {
        return this.count.get();
    }

    public int getFuzzyCount() {
        return this.fuzzyCount;
    }

    public String getFormula() {
        return this.formula;
    }

    public void setFormula(String formula) {
        this.formula = formula;
    }

    public String getFuzzyFormula() {
        return this.fuzzyFormula;
    }

    public void setFuzzyFormula(String fuzzyFormula) {
        this.fuzzyFormula = fuzzyFormula;
    }

    public int getTotal() {
        return this.total;
    }

    public List<String> getSymbols() {
        return this.symbols;
    }

    public int[] getOccurrences() {
        return this.occurrences;
    }

    public List<int[]> getOxygenSulfur() {
        return this.oxygenSulfur;
    }

    public int getTotalHydrogen() {
        return this.totalHydrogen;
    }

    public boolean isOnSm() {
        return this.onSm;
    }

    public boolean getVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public int[] permuteArray(int[] array, int i, int j) {
        int temp = array[i];
        array[i] = array[j];
        array[j] = temp;
        return array;
    }

    public int sum(int[] array) {
        int sum = 0;
        for (int j : array) {
            sum += j;
        }
        return sum;
    }

    public int sum(int[] list, int index) {
        int sum = 0;
        for (int i = 0; i <= index; ++i) {
            sum += list[i];
        }
        return sum;
    }

    public int atomOccurrence(String[] info) {
        if (info.length == 1) {
            if (info[0].contains("(")) {
                return 1;
            }
            String[] info2 = info[0].split(NUMBERS_FROM_0_TO_9, 2);
            if (info2.length == 1) {
                return 1;
            }
            return Integer.parseInt(info2[1]);
        }
        if (info[1].contains(")")) {
            String[] info2 = info[1].split("\\)");
            return info2.length > 1 ? Integer.parseInt(info2[1]) : 1;
        }
        return Integer.parseInt(info[1]);
    }

    public int[] actArray(int[] array, Permutation permutation) {
        int permLength = permutation.size();
        int arrayLength = array.length;
        int[] modified = new int[arrayLength];
        for (int i = 0; i < permLength; ++i) {
            int newIndex = permutation.get(i);
            modified[newIndex] = array[i];
        }
        return modified;
    }

    public int[] idValues(int localSize) {
        int[] id = new int[localSize];
        for (int i = 0; i < localSize; ++i) {
            id[i] = i;
        }
        return id;
    }

    public Permutation idPermutation(int localSize) {
        return new Permutation(localSize);
    }

    public void sortAscending(List<String> symbols) {
        HashMap<String, Integer> inputs = new HashMap<String, Integer>();
        for (String symbol : symbols) {
            if (inputs.containsKey(symbol)) {
                Integer localCount = (Integer)inputs.get(symbol) + 1;
                inputs.put(symbol, localCount);
                continue;
            }
            inputs.put(symbol, 1);
        }
        Set<Map.Entry<String, Integer>> set = inputs.entrySet();
        this.sort(symbols, set);
    }

    public void sort(List<String> symbols, Set<Map.Entry<String, Integer>> set) {
        int index = 0;
        ArrayList<Map.Entry<String, Integer>> list = new ArrayList<Map.Entry<String, Integer>>(set);
        list.sort((value1, value2) -> {
            int comparison = ((Integer)value2.getValue()).compareTo((Integer)value1.getValue());
            if (comparison == 0) {
                return this.valences.get(value1.getKey()).compareTo(this.valences.get(value2.getKey()));
            }
            return ((Integer)value1.getValue()).compareTo((Integer)value2.getValue());
        });
        for (Map.Entry<String, Integer> entry : list) {
            int value = entry.getValue();
            for (int i = 0; i < value; ++i) {
                symbols.set(index + i, entry.getKey());
            }
            index += value;
        }
    }

    public void singleAtomCheck(String[] atoms) {
        String[] info = atoms[0].split(NUMBERS_FROM_0_TO_9, 2);
        String symbol = info[0].split("\\(")[0];
        if (atoms.length == 1) {
            if (symbol.equals("H")) {
                this.singleAtom = false;
            } else if (this.atomOccurrence(info) > 1) {
                this.singleAtom = false;
            }
        } else if (atoms.length == 2) {
            this.singleAtomCheckLengthIsBiggerThanOne(atoms);
        } else {
            this.singleAtom = false;
        }
    }

    public void singleAtomCheckLengthIsBiggerThanOne(String[] atoms) {
        int localCount = 0;
        for (String atom : atoms) {
            String[] info = atom.split(NUMBERS_FROM_0_TO_9, 2);
            String symbol = info[0];
            if (symbol.equals("H") || this.atomOccurrence(info) <= 1 && ++localCount <= 1) continue;
            this.singleAtom = false;
            break;
        }
    }

    public void checkOxygenSulfur(String[] atoms) {
        for (String atom : atoms) {
            String[] info = atom.split("\\(");
            String symbol = info.length != 1 ? info[0] + info[1].split("\\)")[0] : info[0].split(NUMBERS_FROM_0_TO_9)[0];
            if (this.valences.get(symbol) != 2) {
                this.onlyDegree2 = false;
                this.onSm = false;
                break;
            }
            if (symbol.equals("S")) {
                this.sulfur = this.atomOccurrence(info);
                continue;
            }
            if (!symbol.equals("O")) continue;
            this.oxygen = this.atomOccurrence(info);
        }
        if (this.onlyDegree2) {
            this.hIndex = this.matrixSize = this.sulfur + this.oxygen;
        }
    }

    public void getSingleAtomVariables(String localFormula) {
        String[] atoms = localFormula.split(LETTERS_FROM_A_TO_Z);
        ArrayList<String> symbolList = new ArrayList<String>();
        int hydrogens = 0;
        this.hIndex = 1;
        for (String atom : atoms) {
            String[] info = atom.split(NUMBERS_FROM_0_TO_9, 2);
            String symbol = info[0].split("\\(")[0];
            if (symbol.equals("H")) {
                hydrogens = this.atomOccurrence(info);
                continue;
            }
            symbolList.add(symbol);
        }
        this.matrixSize = hydrogens + 1;
        for (int i = 0; i < hydrogens; ++i) {
            symbolList.add("H");
        }
        this.setSymbols(symbolList);
    }

    public void getSymbolOccurrences(String localFormula) {
        String[] atoms = localFormula.split(LETTERS_FROM_A_TO_Z);
        ArrayList<String> symbolList = new ArrayList<String>();
        int hydrogens = 0;
        for (String atom : atoms) {
            String[] info = atom.split("\\(");
            hydrogens = info.length == 1 ? this.getHydrogensInfoLengthIsOne(symbolList, info, hydrogens) : this.getHydrogens(symbolList, info, hydrogens);
        }
        this.sortAscending(symbolList);
        for (int i = 0; i < hydrogens; ++i) {
            symbolList.add("H");
        }
        this.firstOccurrences = this.getPartition(symbolList);
        this.matrixSize = this.sum(this.firstOccurrences);
        this.setSymbols(symbolList);
        this.occurrences = this.getPartition(symbolList);
        if (hydrogens != 0) {
            this.totalHydrogen += hydrogens;
            if (this.hIndex == 1) {
                this.callHydrogenDistributor = false;
            } else if (this.hIndex == 0) {
                this.justH = true;
                this.callHydrogenDistributor = false;
                this.matrixSize = this.hIndex = hydrogens;
            } else {
                this.callHydrogenDistributor = true;
            }
        } else {
            this.callHydrogenDistributor = false;
            this.noHydrogen = true;
        }
    }

    public int getHydrogensInfoLengthIsOne(List<String> symbolList, String[] info, int hydrogens) {
        String symbol = info[0].split(NUMBERS_FROM_0_TO_9)[0];
        if (!symbol.equals("H")) {
            int occur = this.atomOccurrence(info);
            ++this.sizePart;
            for (int i = 0; i < occur; ++i) {
                symbolList.add(symbol);
                ++this.hIndex;
            }
        } else {
            hydrogens = this.atomOccurrence(info);
        }
        return hydrogens;
    }

    private int getHydrogens(List<String> symbolList, String[] info, int hydrogens) {
        String symbol = info[0];
        if (!(symbol = symbol + info[1].split("\\)")[0]).equals("H")) {
            int occur = this.atomOccurrence(info);
            ++this.sizePart;
            for (int i = 0; i < occur; ++i) {
                symbolList.add(symbol);
                ++this.hIndex;
            }
        } else {
            hydrogens = this.atomOccurrence(info);
        }
        return hydrogens;
    }

    public int[] nextCount(int index, int i, int localSize, List<String> symbols, int[] partition) {
        int localCount = 1;
        if (i == localSize - 1) {
            partition[index] = 1;
        } else {
            for (int j = i + 1; j < localSize; ++j) {
                if (symbols.get(i).equals(symbols.get(j))) {
                    ++localCount;
                    if (j != localSize - 1) continue;
                    partition[index] = localCount;
                    ++index;
                    break;
                }
                partition[index] = localCount;
                ++index;
                break;
            }
        }
        return new int[]{localCount, ++index};
    }

    public int[] getPartition(List<String> symbols) {
        int i = 0;
        int[] partition = new int[this.sizePart + 1];
        int localSize = symbols.size();
        int index = 0;
        while (i < localSize) {
            int[] result = this.nextCount(index, i, localSize, symbols, partition);
            int next = i + result[0];
            index = result[1];
            if (next == localSize) break;
            i = next;
        }
        return partition;
    }

    public void setSymbols(List<String> symbolList) {
        this.symbolArray = new String[this.matrixSize];
        int index = 0;
        Iterator<String> iterator = symbolList.iterator();
        while (iterator.hasNext()) {
            String symbol;
            this.symbolArray[index] = symbol = iterator.next();
            ++index;
            if (this.firstSymbols.contains(symbol)) continue;
            this.firstSymbols.add(symbol);
        }
    }

    private static String replaceEach(String str, String[] from, String[] to) {
        if (from.length != to.length) {
            throw new IllegalArgumentException();
        }
        StringBuilder sb = new StringBuilder();
        int pos = 0;
        while (pos < str.length()) {
            int best = -1;
            int bestLen = -1;
            for (int j = 0; j < from.length; ++j) {
                int len = from[j].length();
                if (len <= bestLen || !str.regionMatches(pos, from[j], 0, len)) continue;
                best = j;
                bestLen = len;
            }
            if (best < 0) {
                sb.append(str.charAt(pos));
                ++pos;
                continue;
            }
            sb.append(to[best]);
            pos += bestLen;
        }
        return sb.toString();
    }

    public String normalizeFormula(String formula) {
        String[] from = new String[]{"cl", "CL", "c", "n", "o", "s", "p", "f", "i", "br", "BR", "h"};
        String[] to = new String[]{"Cl", "Cl", "C", "N", "O", "S", "P", "F", "I", "Br", "Br", "H"};
        return Maygen.replaceEach(formula, from, to);
    }

    public String[] validateFormula(String formula) {
        String[] from = new String[]{"Cl", "C", "N", "O", "S", "P", "F", "I", "Br", "H"};
        String[] to = new String[]{"", "", "", "", "", "", "", "", "", ""};
        String result = Maygen.replaceEach(formula.replaceAll("[0-9]", ""), from, to);
        return result.isEmpty() ? new String[]{} : result.split("");
    }

    public String[] validateFuzzyFormula(String formula) {
        String[] from = new String[]{"Cl", "C", "N", "O", "S", "P", "F", "I", "Br", "H", "[", "]", "-"};
        String[] to = new String[]{"", "", "", "", "", "", "", "", "", "", "", "", ""};
        String result = Maygen.replaceEach(formula.replaceAll("[0-9]", ""), from, to);
        return result.isEmpty() ? new String[]{} : result.split("");
    }

    public boolean canBuildIsomer(String formula) {
        String[] atoms = this.normalizeFormula(formula).split(LETTERS_FROM_A_TO_Z);
        int localSize = 0;
        int sum = 0;
        for (String atom : atoms) {
            String[] info = atom.contains(")") ? atom.split("\\)") : atom.split(NUMBERS_FROM_0_TO_9, 2);
            String symbol = info[0].split("\\(")[0];
            int valence = this.setElement && info[0].contains("(") ? Integer.parseInt(info[0].split("\\(")[1]) : this.valences.get(symbol);
            int occur = this.atomOccurrence(info);
            localSize += occur;
            sum += valence * occur;
        }
        this.total = localSize;
        return sum % 2 == 0 && sum >= 2 * (localSize - 1);
    }

    public boolean canBuildIsomerSingle(String formula) {
        String[] atoms = this.normalizeFormula(formula).split(LETTERS_FROM_A_TO_Z);
        boolean check = false;
        int nonHydrogen = 0;
        int hydrogens = 0;
        for (String atom : atoms) {
            String[] info = atom.split(NUMBERS_FROM_0_TO_9, 2);
            String symbol = info[0].split("\\(")[0];
            if (symbol.equals("H")) {
                hydrogens = this.atomOccurrence(info);
                continue;
            }
            nonHydrogen = this.setElement ? Integer.parseInt(info[1].split("\\)")[0]) : this.valences.get(symbol);
        }
        if (nonHydrogen == hydrogens) {
            check = true;
        }
        return check;
    }

    public void initialDegrees() {
        this.firstDegrees = new int[this.matrixSize];
        int index = 0;
        int length = this.firstSymbols.size();
        for (int i = 0; i < length; ++i) {
            String symbol = this.firstSymbols.get(i);
            for (int j = 0; j < this.firstOccurrences[i]; ++j) {
                this.firstDegrees[index] = this.valences.get(symbol);
                ++index;
            }
        }
    }

    public boolean equalSetCheck(int[] array1, int[] array2, int[] partition) {
        int[] temp = this.cloneArray(array2);
        temp = this.descendingSortWithPartition(temp, partition);
        return this.equalSetCheck2(partition, array1, temp);
    }

    public int[] getBlocks(int[] array, int begin, int end) {
        return Arrays.copyOfRange(array, begin, end);
    }

    public boolean equalSetCheck2(int[] partition, int[] array1, int[] array2) {
        boolean check = true;
        int i = 0;
        int limit = this.findZeros(partition);
        if (partition[this.size - 1] != 0) {
            for (int d = 0; d < this.size; ++d) {
                if (array1[d] == array2[d]) continue;
                check = false;
                break;
            }
        } else {
            for (int s = 0; s < limit; ++s) {
                int value = partition[s];
                if (this.compareIndexwise(array1, array2, i, value + i)) {
                    i += value;
                    continue;
                }
                check = false;
                break;
            }
        }
        return check;
    }

    public boolean compareIndexwise(int[] array, int[] array2, int index1, int index2) {
        boolean check = true;
        for (int i = index1; i < index2; ++i) {
            if (array[i] == array2[i]) continue;
            check = false;
            break;
        }
        return check;
    }

    public boolean equalRowsCheck(int index, int[][] a, Permutation cycleTransposition, Permutation permutation) {
        int[] canonical = a[index];
        int newIndex = this.findIndex(index, cycleTransposition);
        Permutation pm = permutation.multiply(cycleTransposition);
        int[] original = this.cloneArray(a[newIndex]);
        original = this.actArray(original, pm);
        return Arrays.equals(canonical, original);
    }

    public int[] descendingSort(int[] array, int index0, int index1) {
        for (int i = index0; i < index1; ++i) {
            for (int j = i + 1; j < index1; ++j) {
                if (array[i] >= array[j]) continue;
                int temp = array[i];
                array[i] = array[j];
                array[j] = temp;
            }
        }
        return array;
    }

    public int[] descendingSortWithPartition(int[] array, int[] partition) {
        int i = 0;
        int limit = this.findZeros(partition);
        for (int i1 = 0; i1 < limit; ++i1) {
            int p = partition[i1];
            array = this.descendingSort(array, i, i + p);
            i += p;
        }
        return array;
    }

    public boolean biggerCheck(int index, int[] firstRow, int[] check, int[] partition) {
        int[] sorted = this.cloneArray(check);
        sorted = this.descendingSortWithPartition(sorted, partition);
        return this.descendingOrderUpperMatrixCheck(index, partition, firstRow, sorted);
    }

    public boolean setBiggest(int index, int[][] a, Permutation permutation, int[] partition) {
        int[] check = this.row2compare(index, a, permutation);
        return this.biggerCheck(index, a[index], check, partition);
    }

    public void getLernenIndices(int index, int[][] a, List<Permutation> cycles, int[] partition, int[] nonCanonicalIndices, boolean[] learningFromCanonicalTest) {
        for (Permutation cycle : cycles) {
            int[] check = this.row2compare(index, a, cycle);
            if (this.biggerCheck(index, a[index], check, partition)) continue;
            this.setLernenIndices(index, cycle, a, check, partition, nonCanonicalIndices, learningFromCanonicalTest);
            break;
        }
    }

    public void setLernenIndices(int rowIndex1, Permutation cycle, int[][] a, int[] secondRow, int[] partition, int[] nonCanonicalIndices, boolean[] learningFromCanonicalTest) {
        System.arraycopy(new int[2], 0, nonCanonicalIndices, 0, 2);
        learningFromCanonicalTest[0] = false;
        int rowIndex2 = cycle.get(rowIndex1);
        Permutation permutation = this.getNonCanonicalMakerPermutation(secondRow, cycle, partition);
        learningFromCanonicalTest[0] = true;
        System.arraycopy(this.upperIndex(rowIndex1, rowIndex2, a, permutation), 0, nonCanonicalIndices, 0, 2);
    }

    public Permutation getNonCanonicalMakerPermutation(int[] array, Permutation cycle, int[] partition) {
        int[] sorted = this.cloneArray(array);
        sorted = this.descendingSortWithPartition(sorted, partition);
        Permutation permutation = this.getCanonicalPermutation(sorted, array, partition);
        return permutation.multiply(cycle);
    }

    public boolean zero(int[] array) {
        boolean check = false;
        for (int i = 0; i < this.size; ++i) {
            if (array[i] != 0) continue;
            check = true;
            break;
        }
        return check;
    }

    public boolean rowDescendingTest(int index, int[][] a, int[] partition, int[] nonCanonicalIndices, boolean[] learningFromCanonicalTest) {
        boolean check = true;
        if (this.zero(partition) && !this.descendingOrderCheck(partition, a[index])) {
            check = false;
            int[] array = this.cloneArray(a[index]);
            array = this.descendingSortWithPartition(array, partition);
            Permutation canonicalPermutation = this.getCanonicalPermutation(array, a[index], partition);
            learningFromCanonicalTest[0] = true;
            System.arraycopy(this.upperIndex(index, index, a, canonicalPermutation), 0, nonCanonicalIndices, 0, 2);
        }
        return check;
    }

    public int getPermutedIndex(Permutation permutation, int index) {
        int out = 0;
        for (int i = 0; i < permutation.size(); ++i) {
            if (permutation.get(i) != index) continue;
            out += i;
            break;
        }
        return out;
    }

    public int[] limit(int index, int nextRowIndex, int[][] a, Permutation permutation) {
        int[] original = a[index];
        int[] permuted = a[nextRowIndex];
        int[] limit = new int[2];
        limit[0] = index;
        for (int i = index + 1; i < this.size; ++i) {
            int value = original[i];
            int newIndex = this.getPermutedIndex(permutation, i);
            int newValue = permuted[newIndex];
            if (value == newValue) continue;
            if (value >= newValue) break;
            limit[1] = i;
            break;
        }
        return limit;
    }

    public int[] lowerIndex(int index, int nextRowIndex, int[][] a, Permutation permutation) {
        int max = 0;
        int upperLimit = this.limit(index, nextRowIndex, a, permutation)[1];
        int[] permuted = a[nextRowIndex];
        for (int i = index + 1; i < upperLimit; ++i) {
            int newIndex = this.getPermutedIndex(permutation, i);
            int newValue = permuted[newIndex];
            if (newValue <= 0 || max >= newIndex) continue;
            max = newIndex;
        }
        return new int[]{nextRowIndex, max};
    }

    public int[] upperIndex(int index, int nextRowIndex, int[][] a, Permutation permutation) {
        int[] limit = this.limit(index, nextRowIndex, a, permutation);
        int[] lowerLimit = this.lowerIndex(index, nextRowIndex, a, permutation);
        int[] upperLimit = new int[]{nextRowIndex, this.getPermutedIndex(permutation, limit[1])};
        int[] maximalIndices = this.getMaximumPair(upperLimit, this.getMaximumPair(limit, lowerLimit));
        maximalIndices = this.maximalIndexWithNonZeroEntry(a, maximalIndices);
        return this.getTranspose(maximalIndices);
    }

    public int[] maximalIndexWithNonZeroEntry(int[][] a, int[] maximalIndices) {
        int columnIndex = maximalIndices[1];
        int rowIndex = maximalIndices[0];
        if (columnIndex > rowIndex && a[rowIndex][columnIndex] != 0) {
            return maximalIndices;
        }
        int[] output = new int[2];
        for (int i = columnIndex; i < this.size; ++i) {
            if (a[rowIndex][i] <= 0) continue;
            output[0] = rowIndex;
            output[1] = i;
            break;
        }
        return output;
    }

    public int[] getTranspose(int[] indices) {
        int[] out = new int[2];
        if (indices[0] > indices[1]) {
            out[0] = indices[1];
            out[1] = indices[0];
            return out;
        }
        return indices;
    }

    public int[] getMaximumPair(int[] a, int[] b) {
        if (a[0] > b[0]) {
            return a;
        }
        if (b[0] > a[0]) {
            return b;
        }
        if (a[1] > b[1]) {
            return a;
        }
        if (b[1] > a[1]) {
            return b;
        }
        return a;
    }

    public boolean compare(int[] array1, int[] array2, int index1, int index2) {
        boolean check = true;
        for (int i = index1; i < index2; ++i) {
            if (array1[i] == array2[i]) continue;
            if (array1[i] < array2[i]) {
                check = false;
                break;
            }
            if (array1[i] > array2[i]) break;
        }
        return check;
    }

    public boolean descendingOrderUpperMatrixCheck(int index, int[] partition, int[] firstRow, int[] secondRow) {
        boolean check = true;
        int i = index + 1;
        int limit = this.findZeros(partition);
        for (int k = index + 1; k < limit; ++k) {
            int p = partition[k];
            if (this.descendingOrderCheck(firstRow, i, i + p)) {
                if (!this.compareIndexwise(firstRow, secondRow, i, i + p)) {
                    check = this.compare(firstRow, secondRow, i, i + p);
                    break;
                }
                i += p;
                continue;
            }
            check = false;
            break;
        }
        return check;
    }

    public boolean descendingOrderCheck(int[] array, int f, int l) {
        boolean check = true;
        for (int i = f; i < l - 1; ++i) {
            if (array[i] >= array[i + 1]) continue;
            check = false;
            break;
        }
        return check;
    }

    public boolean descendingOrderCheck(int[] partition, int[] array) {
        boolean check = true;
        int i = 0;
        int limit = this.findZeros(partition);
        for (int s = 0; s < limit; ++s) {
            int value = partition[s];
            if (!this.descendingOrderCheck(array, i, value + i)) {
                check = false;
                break;
            }
            i += value;
        }
        return check;
    }

    public void upperTriangularL(int[] degrees, int[][][] max, int[][][] l) {
        l[0] = new int[this.hIndex][this.hIndex];
        if (this.hIndex == 2) {
            for (int i = 0; i < this.hIndex; ++i) {
                for (int j = i + 1; j < this.hIndex; ++j) {
                    l[0][i][j] = Math.min(degrees[i], this.lsum(i, j, max));
                }
            }
        } else {
            for (int i = 0; i < this.hIndex; ++i) {
                for (int j = i + 1; j < this.hIndex; ++j) {
                    l[0][i][j] = Math.min(degrees[i], this.lsum(i, j + 1, max));
                }
            }
        }
    }

    public void upperTriangularC(int[] degrees, int[][][] max, int[][][] c) {
        c[0] = new int[this.hIndex][this.hIndex];
        if (this.hIndex == 2) {
            for (int i = 0; i < this.hIndex; ++i) {
                for (int j = i + 1; j < this.hIndex; ++j) {
                    c[0][i][j] = Math.min(degrees[j], this.csum(i, j, max));
                }
            }
        } else {
            for (int i = 0; i < this.hIndex; ++i) {
                for (int j = i + 1; j < this.hIndex; ++j) {
                    c[0][i][j] = Math.min(degrees[j], this.csum(i + 1, j, max));
                }
            }
        }
    }

    public int lsum(int i, int j, int[][][] max) {
        int sum = 0;
        for (int k = j; k < this.hIndex; ++k) {
            sum += max[0][i][k];
        }
        return sum;
    }

    public int csum(int i, int j, int[][][] max) {
        int sum = 0;
        for (int k = i; k < this.hIndex; ++k) {
            sum += max[0][k][j];
        }
        return sum;
    }

    public void maximalMatrix(int[] degrees, int[][][] max) {
        max[0] = new int[this.hIndex][this.hIndex];
        for (int i = 0; i < this.hIndex; ++i) {
            for (int j = 0; j < this.hIndex; ++j) {
                int di = degrees[i];
                int dj = degrees[j];
                if (i == j) {
                    max[0][i][j] = 0;
                    continue;
                }
                if (di != dj) {
                    max[0][i][j] = Math.min(di, dj);
                    continue;
                }
                this.checkJustH(max, i, j, di);
            }
        }
    }

    public void checkJustH(int[][][] max, int i, int j, int di) {
        max[0][i][j] = this.justH ? di : (this.hIndex == 2 ? di : (di != 1 ? di - 1 : di));
    }

    public void generate(IAtomContainer ac, String[] symbolArrayCopy, int[] degreeList, int[] initialPartition, int[][] partitionList, int[] connectivityIndices, boolean[] learningFromConnectivity, int[] nonCanonicalIndices, List<ArrayList<Permutation>> formerPermutations, int[] hydrogens, int[] partSize, int[] r, int[] y, int[] z, int[][] ys, int[][] zs, boolean[] learningFromCanonicalTest) throws IOException, CloneNotSupportedException, CDKException {
        int[][] a = new int[this.matrixSize][this.matrixSize];
        int[] degrees = degreeList;
        boolean[] flag = new boolean[]{true};
        int[][][] max = new int[][][]{new int[0][0]};
        int[][][] l = new int[][][]{new int[0][0]};
        int[][][] c = new int[][][]{new int[0][0]};
        this.maximalMatrix(degrees, max);
        this.upperTriangularL(degrees, max, l);
        this.upperTriangularC(degrees, max, c);
        int[] indices = new int[]{0, 1};
        boolean[] callForward = new boolean[]{true};
        r[0] = 0;
        y[0] = ys[0][r[0]];
        z[0] = zs[0][r[0]];
        while (flag[0]) {
            this.nextStep(ac, symbolArrayCopy, a, indices, degrees, initialPartition, partitionList, callForward, connectivityIndices, learningFromConnectivity, nonCanonicalIndices, formerPermutations, hydrogens, partSize, r, y, z, max, l, c, ys, zs, learningFromCanonicalTest, flag);
            if (!flag[0]) break;
            if (learningFromConnectivity[0]) {
                indices = connectivityIndices;
                this.findR(indices, initialPartition, r);
                int value = this.indexYZ(initialPartition, r);
                y[0] = ys[0][value];
                this.clearFormers(false, y[0], partitionList, formerPermutations);
                learningFromConnectivity[0] = false;
                callForward[0] = false;
                continue;
            }
            if (!learningFromCanonicalTest[0]) continue;
            indices = this.successor(nonCanonicalIndices, max[0].length);
            this.findR(indices, initialPartition, r);
            learningFromCanonicalTest[0] = false;
            callForward[0] = false;
        }
    }

    public int[] successor(int[] indices, int localSize) {
        int i0 = indices[0];
        int i1 = indices[1];
        if (i1 < localSize - 1) {
            indices[0] = i0;
            indices[1] = i1 + 1;
        } else if (i0 < localSize - 2 && i1 == localSize - 1) {
            indices[0] = i0 + 1;
            indices[1] = i0 + 2;
        }
        return indices;
    }

    public int[] predecessor(int[] indices, int localSize) {
        int i0 = indices[0];
        int i1 = indices[1];
        if (i0 == i1 - 1) {
            indices[0] = i0 - 1;
            indices[1] = localSize - 1;
        } else {
            indices[0] = i0;
            indices[1] = i1 - 1;
        }
        return indices;
    }

    public void nextStep(IAtomContainer ac, String[] symbolArrayCopy, int[][] a, int[] indices, int[] degrees, int[] initialPartition, int[][] partitionList, boolean[] callForward, int[] connectivityIndices, boolean[] learningFromConnectivity, int[] nonCanonicalIndices, List<ArrayList<Permutation>> formerPermutations, int[] hydrogens, int[] partSize, int[] r, int[] y, int[] z, int[][][] max, int[][][] l, int[][][] c, int[][] ys, int[][] zs, boolean[] learningFromCanonicalTest, boolean[] flag) throws IOException, CloneNotSupportedException, CDKException {
        if (callForward[0]) {
            this.forward(ac, symbolArrayCopy, a, indices, degrees, initialPartition, partitionList, callForward, connectivityIndices, learningFromConnectivity, nonCanonicalIndices, formerPermutations, hydrogens, partSize, r, y, z, max, l, c, ys, zs, learningFromCanonicalTest);
        } else {
            this.backward(a, indices, degrees, initialPartition, callForward, r, max, l, c, flag);
        }
    }

    public int[][] addHydrogens(int[][] a, int index, int[] hydrogens) {
        block4: {
            int localHIndex;
            block3: {
                localHIndex = index;
                if (!this.singleAtom) break block3;
                int hydrogen = this.valences.get(this.symbolArray[0]);
                for (int j = localHIndex; j < hydrogen + localHIndex; ++j) {
                    a[0][j] = 1;
                    a[j][0] = 1;
                }
                break block4;
            }
            if (!this.callHydrogenDistributor) break block4;
            for (int i = 0; i < index; ++i) {
                int hydrogen = hydrogens[i];
                int limit = localHIndex + hydrogen;
                for (int j = localHIndex; j < limit; ++j) {
                    a[i][j] = 1;
                    a[j][i] = 1;
                }
                if (hydrogen == 0) continue;
                localHIndex += hydrogen;
            }
        }
        return a;
    }

    public void findR(int[] indices, int[] initialPartition, int[] r) {
        int block = 0;
        int index = 0;
        int rowIndex = indices[0];
        int limit = this.findZeros(initialPartition);
        for (int i = 0; i < limit; ++i) {
            int part = initialPartition[i];
            if (index <= rowIndex && rowIndex < index + part) break;
            ++block;
            index += part;
        }
        r[0] = block;
    }

    public boolean backwardCriteria(int x, int lInverse, int l) {
        int newX = x - 1;
        return lInverse - newX <= l;
    }

    public int[][] backward(int[][] a, int[] indices, int[] degrees, int[] initialPartition, boolean[] callForward, int[] r, int[][][] max, int[][][] l, int[][][] c, boolean[] flag) {
        int i = indices[0];
        int j = indices[1];
        if (i == 0 && j == 1) {
            flag[0] = false;
        } else {
            indices = this.predecessor(indices, max[0].length);
            this.findR(indices, initialPartition, r);
            i = indices[0];
            j = indices[1];
            int x = a[i][j];
            int l2 = this.lInverse(i, j, a, degrees);
            int c2 = this.cInverse(i, j, a, degrees);
            if (x > 0 && this.backwardCriteria(x, l2, l[0][i][j]) && this.backwardCriteria(x, c2, c[0][i][j])) {
                a[i][j] = x - 1;
                a[j][i] = x - 1;
                indices = this.successor(indices, max[0].length);
                this.findR(indices, initialPartition, r);
                callForward[0] = true;
            } else {
                callForward[0] = false;
            }
        }
        return a;
    }

    public int[][] forward(IAtomContainer ac, String[] symbolArrayCopy, int[][] a, int[] indices, int[] degrees, int[] initialPartition, int[][] partitionList, boolean[] callForward, int[] connectivityIndices, boolean[] learningFromConnectivity, int[] nonCanonicalIndices, List<ArrayList<Permutation>> formerPermutations, int[] hydrogens, int[] partSize, int[] r, int[] y, int[] z, int[][][] max, int[][][] l, int[][][] c, int[][] ys, int[][] zs, boolean[] learningFromCanonicalTest) throws IOException, CloneNotSupportedException, CDKException {
        int i = indices[0];
        int j = indices[1];
        int lInverse = this.lInverse(i, j, a, degrees);
        int cInverse = this.cInverse(i, j, a, degrees);
        int minimumValue = Math.min(max[0][i][j], Math.min(lInverse, cInverse));
        int maximumValue = this.maximalEntry(minimumValue, lInverse, l[0][i][j], cInverse, c[0][i][j]);
        callForward[0] = true;
        return this.forward(ac, symbolArrayCopy, lInverse, cInverse, maximumValue, i, j, a, indices, initialPartition, partitionList, callForward, connectivityIndices, learningFromConnectivity, nonCanonicalIndices, formerPermutations, hydrogens, partSize, r, y, z, max, l, c, ys, zs, learningFromCanonicalTest);
    }

    public int[][] forward(IAtomContainer ac, String[] symbolArrayCopy, int lInverse, int cInverse, int maximalX, int i, int j, int[][] a, int[] indices, int[] initialPartition, int[][] partitionList, boolean[] callForward, int[] connectivityIndices, boolean[] learningFromConnectivity, int[] nonCanonicalIndices, List<ArrayList<Permutation>> formerPermutations, int[] hydrogens, int[] partSize, int[] r, int[] y, int[] z, int[][][] max, int[][][] l, int[][][] c, int[][] ys, int[][] zs, boolean[] learningFromCanonicalTest) throws IOException, CloneNotSupportedException, CDKException {
        if (lInverse - maximalX <= l[0][i][j] && cInverse - maximalX <= c[0][i][j]) {
            a[i][j] = maximalX;
            a[j][i] = maximalX;
            if (i == max[0].length - 2 && j == max[0].length - 1) {
                boolean boundaryCheck = true;
                if (this.boundary) {
                    boundaryCheck = BoundaryConditions.boundaryConditionCheck(a, symbolArrayCopy);
                }
                if (boundaryCheck && this.canonicalTest(a, initialPartition, partitionList, nonCanonicalIndices, formerPermutations, partSize, r, y, z, ys, zs, learningFromCanonicalTest)) {
                    if (this.connectivityTest(a, connectivityIndices, learningFromConnectivity)) {
                        this.count.incrementAndGet();
                        if (ac.getAtomCount() != 0) {
                            IAtomContainer mol = this.buildAtomContainerFromMatrix(this.addHydrogens(a, this.hIndex, hydrogens), ac.clone());
                            this.emit(mol);
                        }
                        callForward[0] = false;
                    } else {
                        callForward[0] = false;
                        learningFromConnectivity[0] = true;
                    }
                } else if (!learningFromCanonicalTest[0]) {
                    callForward[0] = false;
                }
            } else {
                int value = this.indexYZ(initialPartition, r);
                if (indices[0] == zs[0][value] && indices[1] == max[0].length - 1) {
                    callForward[0] = this.canonicalTest(a, initialPartition, partitionList, nonCanonicalIndices, formerPermutations, partSize, r, y, z, ys, zs, learningFromCanonicalTest);
                    if (callForward[0]) {
                        indices = this.successor(indices, max[0].length);
                        this.findR(indices, initialPartition, r);
                    } else {
                        callForward[0] = false;
                    }
                } else {
                    indices = this.successor(indices, max[0].length);
                    this.findR(indices, initialPartition, r);
                    callForward[0] = true;
                }
            }
        } else {
            callForward[0] = false;
        }
        return a;
    }

    public int maximalEntry(int min, int lInverse, int l, int cInverse, int c) {
        int max = 0;
        for (int v = min; v >= 0; --v) {
            if (lInverse - v > l || cInverse - v > c) continue;
            max += v;
            break;
        }
        return max;
    }

    public int lInverse(int i, int j, int[][] a, int[] degrees) {
        int sum = 0;
        if (this.hIndex == 2) {
            for (int s = 0; s <= j; ++s) {
                sum += a[i][s];
            }
        } else {
            for (int s = 0; s < j; ++s) {
                sum += a[i][s];
            }
        }
        return degrees[i] - sum;
    }

    public int cInverse(int i, int j, int[][] a, int[] degrees) {
        int sum = 0;
        if (this.hIndex == 2) {
            for (int s = 0; s <= i; ++s) {
                sum += a[s][j];
            }
        } else {
            for (int s = 0; s < i; ++s) {
                sum += a[s][j];
            }
        }
        return degrees[j] - sum;
    }

    public int[] getPartition(int[] degrees) {
        int[] newPartition = new int[degrees.length];
        int i = 0;
        int length = this.justH || this.noHydrogen ? this.firstOccurrences.length : this.firstOccurrences.length - 1;
        int index = 0;
        for (int part = 0; part < length; ++part) {
            int p = this.firstOccurrences[part];
            int[] subArray = this.getBlocks(degrees, i, p + i);
            int[] nArray = this.getSubPartition(subArray);
            int n = nArray.length;
            for (int j = 0; j < n; ++j) {
                Integer item = nArray[j];
                newPartition[index] = item;
                ++index;
            }
            i += p;
        }
        return newPartition;
    }

    public int[] getSubPartition(int[] degrees) {
        int i = 0;
        int localSize = degrees.length;
        int[] partition = new int[localSize];
        int index = 0;
        while (i < localSize) {
            int[] result = this.nextCount(index, i, localSize, degrees, partition);
            index = result[1];
            int next = i + result[0];
            if (next == localSize) break;
            i = next;
        }
        return partition;
    }

    public int[] nextCount(int index, int i, int localSize, int[] degrees, int[] partition) {
        int localCount = 1;
        if (i == localSize - 1) {
            partition[index] = 1;
        } else {
            for (int j = i + 1; j < localSize; ++j) {
                if (degrees[i] == degrees[j]) {
                    ++localCount;
                    if (j != localSize - 1) continue;
                    partition[index] = localCount;
                    ++index;
                    break;
                }
                partition[index] = localCount;
                ++index;
                break;
            }
        }
        return new int[]{localCount, ++index};
    }

    public boolean checkLengthTwoFormula(String[] atoms) {
        boolean check = true;
        if (atoms.length == 1) {
            String[] info = atoms[0].split(NUMBERS_FROM_0_TO_9, 2);
            if (atoms[0].contains("(")) {
                String[] info2 = info[1].split("\\)");
                if (info2[1].equals("2") && Integer.parseInt(info2[0]) > 3) {
                    check = false;
                }
            } else if (info[1].equals("2") && this.valences.get(info[0]) > 3) {
                check = false;
            }
        }
        return check;
    }

    public void run() throws IOException, CDKException, CloneNotSupportedException {
        this.clearGlobals();
        if (Objects.nonNull(this.fuzzyFormula)) {
            if (!this.setElement) {
                this.fuzzyFormula = this.normalizeFormula(this.fuzzyFormula);
            }
            this.consumer.configure(this.fuzzyFormula);
            if (this.verbose) {
                this.logger.info((Object)"MAYGEN is generating isomers of ", new Object[]{this.fuzzyFormula, "..."});
            }
            long startTime = System.nanoTime();
            this.fuzzyCount = 0;
            List<String> formulae = this.getFormulaList(this.fuzzyFormula);
            if (formulae.isEmpty()) {
                if (this.verbose) {
                    this.logger.info((Object)(THE_INPUT_FORMULA + this.fuzzyFormula + DOES_NOT_REPRESENT_ANY_MOLECULE));
                }
            } else {
                for (String fuzzyFormulaItem : formulae) {
                    this.clearGlobals();
                    this.doRun(fuzzyFormulaItem);
                    this.fuzzyCount += this.count.get();
                }
                this.closeFilesAndDisplayStatistic(startTime);
            }
        } else {
            this.doRun(this.formula);
        }
        this.consumer.close();
    }

    public void closeFilesAndDisplayStatistic(long startTime) {
        if (this.verbose) {
            long endTime = System.nanoTime() - startTime;
            double seconds = (double)endTime / 1.0E9;
            DecimalFormat d = new DecimalFormat(".###");
            d.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.ENGLISH));
            this.logger.info((Object)("The number of structures is: " + this.fuzzyCount));
            this.logger.info((Object)("Time: " + d.format(seconds) + " seconds"));
        }
    }

    public void doRun(String localFormula) throws IOException, CDKException, CloneNotSupportedException {
        String normalizedLocalFormula = this.normalizeFormula(localFormula);
        if (this.setElement) {
            normalizedLocalFormula = normalizedLocalFormula.replace("val=", "");
        }
        String checkFormula = normalizedLocalFormula.replace("(", "");
        CharSequence[] unsupportedSymbols = this.validateFormula(checkFormula = checkFormula.replace(")", ""));
        if (unsupportedSymbols.length > 0 && this.verbose) {
            this.logger.info((Object)("The input formula consists user defined element types: " + String.join((CharSequence)", ", unsupportedSymbols)));
        } else {
            long startTime = System.nanoTime();
            if (Objects.isNull(this.fuzzyFormula)) {
                if (this.verbose) {
                    this.logger.info((Object)("MAYGEN is generating isomers of " + normalizedLocalFormula + "..."));
                }
                this.consumer.configure(normalizedLocalFormula);
            }
            this.processRun(normalizedLocalFormula, startTime);
        }
    }

    public void processRun(String normalizedLocalFormula, long startTime) throws IOException, CDKException, CloneNotSupportedException {
        String[] atoms = normalizedLocalFormula.split(LETTERS_FROM_A_TO_Z);
        if (this.setElement) {
            this.getHigherValences(normalizedLocalFormula);
        }
        if (this.checkLengthTwoFormula(atoms)) {
            this.singleAtomCheck(atoms);
            if (this.singleAtom) {
                if (this.canBuildIsomerSingle(normalizedLocalFormula)) {
                    this.getSingleAtomVariables(normalizedLocalFormula);
                    this.initSingleAC();
                    this.writeSingleAtom(new int[0]);
                    this.displayStatistic(startTime, normalizedLocalFormula);
                }
            } else {
                this.checkOxygenSulfur(atoms);
                this.processFormula(normalizedLocalFormula, startTime);
            }
        } else if (this.verbose) {
            this.logger.info((Object)(THE_INPUT_FORMULA + normalizedLocalFormula + DOES_NOT_REPRESENT_ANY_MOLECULE));
        }
    }

    public void processFormula(String normalizedLocalFormula, long startTime) throws IOException, CDKException, CloneNotSupportedException {
        if (this.onlyDegree2) {
            if (this.oxygen == 0 || this.sulfur == 0) {
                this.degree2graph();
            } else {
                this.distributeSulfurOxygen(normalizedLocalFormula);
            }
            this.displayStatistic(startTime, normalizedLocalFormula);
        } else if (this.canBuildIsomer(normalizedLocalFormula)) {
            this.getSymbolOccurrences(normalizedLocalFormula);
            this.initialDegrees();
            this.structureGenerator(normalizedLocalFormula);
            this.displayStatistic(startTime, normalizedLocalFormula);
        } else if (Objects.isNull(this.fuzzyFormula) && this.verbose) {
            this.logger.info((Object)(THE_INPUT_FORMULA + normalizedLocalFormula + DOES_NOT_REPRESENT_ANY_MOLECULE));
        }
    }

    public void displayStatistic(long startTime, String localFormula) {
        long endTime = System.nanoTime() - startTime;
        double seconds = (double)endTime / 1.0E9;
        DecimalFormat d = new DecimalFormat(".###");
        d.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.ENGLISH));
        if (Objects.isNull(this.fuzzyFormula) && this.verbose) {
            this.logger.info((Object)("The number of structures is: " + this.count));
            this.logger.info((Object)("Time: " + d.format(seconds) + " seconds"));
        }
        if (this.tsvoutput) {
            System.out.println(localFormula + "\t" + this.count + "\t" + d.format(seconds) + "\t" + (this.multiThread ? this.size : 1));
        }
    }

    public List<int[]> distributeHydrogens() {
        ArrayList<int[]> degreeList = new ArrayList<int[]>();
        if (!this.callHydrogenDistributor) {
            degreeList.add(this.firstDegrees);
        } else {
            List<int[]> distributions = new HydrogenDistributor().run(this.firstOccurrences, this.firstDegrees);
            if (this.hIndex == 2) {
                this.fillDegreeListHindexIsTwo(degreeList, distributions);
            } else {
                for (int[] dist : distributions) {
                    int[] newDegree = new int[this.size];
                    for (int i = 0; i < this.size; ++i) {
                        newDegree[i] = this.firstDegrees[i] - dist[i];
                    }
                    degreeList.add(newDegree);
                }
            }
        }
        return degreeList;
    }

    public void fillDegreeListHindexIsTwo(List<int[]> degreeList, List<int[]> distributions) {
        for (int[] dist : distributions) {
            int[] newDegree = new int[this.size];
            for (int i = 0; i < this.size; ++i) {
                newDegree[i] = this.firstDegrees[i] - dist[i];
            }
            if (newDegree[0] != newDegree[1]) continue;
            degreeList.add(newDegree);
        }
    }

    public void setYZValues(int[] initialPartition, int[][] ys, int[][] zs) {
        ys[0] = new int[this.size];
        zs[0] = new int[this.size];
        int limit = this.findZeros(initialPartition);
        int index = 0;
        for (int i = 0; i < limit; ++i) {
            int value = initialPartition[i];
            int y = this.findY(i, initialPartition);
            int z = this.findZ(i, initialPartition);
            for (int j = 0; j < value; ++j) {
                ys[0][index] = y;
                zs[0][index] = z;
                ++index;
            }
        }
    }

    public int findY(int r, int[] initialPartition) {
        return this.sum(initialPartition, r - 1);
    }

    public int findZ(int r, int[] initialPartition) {
        return this.sum(initialPartition, r) - 1;
    }

    public void writeSingleAtom(int[] hydrogens) throws IOException, CDKException, CloneNotSupportedException {
        int[][] a = new int[this.matrixSize][this.matrixSize];
        this.count.incrementAndGet();
        this.emit(this.buildContainer4SDF(this.atomContainer, this.addHydrogens(a, this.hIndex, hydrogens)));
    }

    public int[] setHydrogens(int[] degree) {
        int[] hydrogens = new int[this.size];
        for (int i = 0; i < this.size; ++i) {
            hydrogens[i] = this.firstDegrees[i] - degree[i];
        }
        return hydrogens;
    }

    public void structureGenerator(String localFormula) {
        this.size = this.noHydrogen ? this.sum(this.firstOccurrences, this.firstOccurrences.length - 1) : (this.justH ? this.hIndex : this.sum(this.firstOccurrences, this.firstOccurrences.length - 2));
        List<int[]> newDegrees = this.distributeHydrogens();
        if (this.multiThread) {
            try {
                ((ForkJoinTask)new ForkJoinPool(this.size).submit(() -> newDegrees.parallelStream().forEach(new Generation(this)::run))).get();
            }
            catch (InterruptedException | ExecutionException ex) {
                Thread.currentThread().interrupt();
                if (this.verbose) {
                    this.logger.error((Object)("Failed during parallel generation: " + localFormula), new Object[]{ex});
                }
            }
        } else {
            newDegrees.forEach(new Generation(this)::run);
        }
    }

    public void clearGlobals() {
        this.singleAtom = true;
        this.onlyDegree2 = true;
        this.onSm = true;
        this.oxygen = 0;
        this.sulfur = 0;
        this.graphSize = 0;
        this.callHydrogenDistributor = false;
        this.total = 0;
        this.totalHydrogen = 0;
        this.size = 0;
        this.sizePart = 0;
        this.hIndex = 0;
        this.count.set(0);
        this.matrixSize = 0;
        this.justH = false;
        this.noHydrogen = false;
        this.oxygenSulfur = new ArrayList<int[]>();
        this.symbols = new ArrayList<String>();
        this.occurrences = null;
        this.symbolArray = null;
        this.firstSymbols = new ArrayList<String>();
        this.symbols = new ArrayList<String>();
        this.firstOccurrences = null;
    }

    public Set<Integer> nValues(int index, int total, int[][] mat) {
        HashSet<Integer> nValues = new HashSet<Integer>();
        nValues.add(index);
        int[] theRow = mat[index];
        for (int i = index + 1; i < total; ++i) {
            if (theRow[i] <= 0) continue;
            nValues.add(i);
        }
        return nValues;
    }

    public Set<Integer> wValues(Set<Integer> nValues, int[] kFormer) {
        HashSet<Integer> wValues = new HashSet<Integer>();
        for (Integer i : nValues) {
            wValues.add(kFormer[i]);
        }
        return wValues;
    }

    public int[] kValues(int total, Set<Integer> wValues, int[] kFormer) {
        int[] kValues = new int[total];
        int min = Collections.min(wValues);
        for (int i = 0; i < total; ++i) {
            kValues[i] = wValues.contains(kFormer[i]) ? min : kFormer[i];
        }
        return kValues;
    }

    public int[] initialKList(int total) {
        int[] k = new int[total];
        for (int i = 0; i < total; ++i) {
            k[i] = i;
        }
        return k;
    }

    public boolean connectivityTest(int[][] mat, int[] connectivityIndices, boolean[] learningFromConnectivity) {
        learningFromConnectivity[0] = false;
        boolean check = false;
        int[] kValues = this.initialKList(this.hIndex);
        HashSet<Integer> zValues = new HashSet<Integer>();
        int zValue = 0;
        for (int i = 0; i < this.hIndex; ++i) {
            Set<Integer> nValues = this.nValues(i, this.hIndex, mat);
            Set<Integer> wValues = this.wValues(nValues, kValues);
            zValue = Collections.min(wValues);
            zValues.add(zValue);
            kValues = this.kValues(this.hIndex, wValues, kValues);
        }
        if (zValue == 0 && this.allIs0(kValues)) {
            check = true;
        } else {
            this.setLearningFromConnectivity(zValues, kValues, connectivityIndices, learningFromConnectivity);
        }
        return check;
    }

    public void setLearningFromConnectivity(Set<Integer> zValues, int[] kValues, int[] connectivityIndices, boolean[] learningFromConnectivity) {
        learningFromConnectivity[0] = true;
        connectivityIndices[0] = this.minComponentIndex(zValues, kValues);
        connectivityIndices[1] = this.hIndex - 1;
    }

    public int minComponentIndex(Set<Integer> zValues, int[] kValues) {
        int index = this.findMaximalIndexInComponent(kValues, 0);
        for (Integer i : zValues) {
            int value = this.findMaximalIndexInComponent(kValues, i);
            if (value >= index) continue;
            index = value;
        }
        return index;
    }

    public int findMaximalIndexInComponent(int[] kValues, int value) {
        int maxIndex = this.hIndex;
        for (int i = this.hIndex - 1; i > 0; --i) {
            if (kValues[i] != value) continue;
            maxIndex = i;
            break;
        }
        return maxIndex;
    }

    public boolean allIs0(int[] list) {
        boolean check = true;
        for (int j : list) {
            if (j == 0) continue;
            check = false;
            break;
        }
        return check;
    }

    public int indexYZ(int[] initialPartition, int[] r) {
        int index = 0;
        for (int i = 0; i <= r[0]; ++i) {
            index += initialPartition[i];
        }
        return index - 1;
    }

    public boolean canonicalTest(int[][] a, int[] initialPartition, int[][] partitionList, int[] nonCanonicalIndices, List<ArrayList<Permutation>> formerPermutations, int[] partSize, int[] r, int[] y, int[] z, int[][] ys, int[][] zs, boolean[] learningFromCanonicalTest) {
        boolean check = true;
        learningFromCanonicalTest[0] = false;
        int value = this.indexYZ(initialPartition, r);
        y[0] = ys[0][value];
        z[0] = zs[0][value];
        if (partSize[0] == r[0] && z[0] != 1) {
            z[0] = z[0] - 1;
        }
        this.clearFormers(false, y[0], partitionList, formerPermutations);
        for (int i = y[0]; i <= z[0]; ++i) {
            boolean test = this.rowCanonicalTest(i, r, a, partitionList[i], this.canonicalPartition(i, partitionList[i]), initialPartition, partitionList, nonCanonicalIndices, formerPermutations, y, ys, learningFromCanonicalTest);
            if (test) continue;
            check = false;
            break;
        }
        this.clearFormers(check, y[0], partitionList, formerPermutations);
        return check;
    }

    public void clearFormers(boolean check, int y, int[][] partitionList, List<ArrayList<Permutation>> formerPermutations) {
        if (!check) {
            int partitionSize;
            int formerSize = formerPermutations.size() - 1;
            if (formerSize >= y) {
                formerPermutations.subList(y, formerSize + 1).clear();
            }
            for (int i = partitionSize = partitionList.length - 1; i > y; --i) {
                partitionList[i] = null;
            }
        }
    }

    public void candidatePermutations(int index, List<Permutation> cycles, List<ArrayList<Permutation>> formerPermutations) {
        ArrayList<Permutation> newList = new ArrayList<Permutation>(cycles);
        if (index != 0) {
            ArrayList<Permutation> formers = formerPermutations.get(index - 1);
            for (Permutation permutation : formers) {
                if (permutation.isIdentity()) continue;
                newList.add(permutation);
            }
            ArrayList<Permutation> newForm = new ArrayList<Permutation>();
            for (Permutation frm : formers) {
                if (frm.isIdentity()) continue;
                newForm.add(frm);
            }
            ArrayList<Permutation> arrayList = new ArrayList<Permutation>();
            if (cycles.size() != 1) {
                for (Permutation cyc : cycles) {
                    if (cyc.isIdentity()) continue;
                    arrayList.add(cyc);
                }
            }
            for (Permutation perm : newForm) {
                for (Permutation cycle : arrayList) {
                    Permutation newPermutation = cycle.multiply(perm);
                    if (newPermutation.isIdentity()) continue;
                    newList.add(newPermutation);
                }
            }
        }
        formerPermutations.add(index, newList);
    }

    public boolean rowCanonicalTest(int index, int[] r, int[][] a, int[] partition, int[] newPartition, int[] initialPartition, int[][] partitionList, int[] nonCanonicalIndices, List<ArrayList<Permutation>> formerPermutations, int[] y, int[][] ys, boolean[] learningFromCanonicalTest) {
        boolean check;
        if (!this.rowDescendingTest(index, a, newPartition, nonCanonicalIndices, learningFromCanonicalTest)) {
            check = false;
        } else {
            int value = this.indexYZ(initialPartition, r);
            y[0] = ys[0][value];
            List<Object> cycles = new ArrayList();
            if (partition[this.size - 1] != 0) {
                Permutation id = new Permutation(this.size);
                cycles.add(id);
            } else {
                cycles = this.cycleTranspositions(index, partition);
            }
            this.candidatePermutations(index, cycles, formerPermutations);
            check = this.check(index, this.size, a, newPartition, formerPermutations);
            if (!check) {
                if (cycles.size() != 1) {
                    this.getLernenIndices(index, a, cycles, newPartition, nonCanonicalIndices, learningFromCanonicalTest);
                }
            } else {
                this.addPartition(index, newPartition, a, partitionList);
            }
        }
        return check;
    }

    public void addPartition(int index, int[] newPartition, int[][] a, int[][] partitionList) {
        partitionList[index + 1] = newPartition[this.size - 1] != 0 ? newPartition : this.refinedPartitioning(newPartition, a[index]);
    }

    public int[] refinedPartitioning(int[] partition, int[] row) {
        int[] refined = new int[this.size];
        int index = 0;
        int localCount = 1;
        int refinedIndex = 0;
        int limit = this.findZeros(partition);
        for (int s = 0; s < limit; ++s) {
            if (partition[s] != 1) {
                for (int i = index; i < partition[s] + index - 1; ++i) {
                    if (i + 1 < partition[s] + index - 1) {
                        if (row[i] == row[i + 1]) {
                            ++localCount;
                            continue;
                        }
                        refined[refinedIndex] = localCount;
                        ++refinedIndex;
                        localCount = 1;
                        continue;
                    }
                    if (row[i] == row[i + 1]) {
                        refined[refinedIndex] = ++localCount;
                    } else {
                        refined[refinedIndex] = localCount;
                        refined[++refinedIndex] = 1;
                    }
                    ++refinedIndex;
                    localCount = 1;
                }
                index += partition[s];
                continue;
            }
            ++index;
            refined[refinedIndex] = 1;
            ++refinedIndex;
            localCount = 1;
        }
        return refined;
    }

    public int[] row2compare(int index, int[][] a, Permutation cycleTransposition) {
        int[] array = this.cloneArray(a[this.findIndex(index, cycleTransposition)]);
        return this.actArray(array, cycleTransposition);
    }

    public int findIndex(int index, Permutation cycle) {
        int cycleSize = cycle.size();
        int output = 0;
        for (int i = 0; i < cycleSize; ++i) {
            if (cycle.get(i) != index) continue;
            output = i;
            break;
        }
        return output;
    }

    public int[] cloneArray(int[] array) {
        return (int[])array.clone();
    }

    public Permutation getCanonicalPermutation(int[] originalRow, int[] rowToCheck, int[] partition) {
        int[] cycles = this.getCanonicalPermutation2(partition, originalRow, rowToCheck);
        int[] perm = new int[this.size];
        for (int i = 0; i < this.size; ++i) {
            for (int j = 0; j < this.size; ++j) {
                if (i != cycles[j]) continue;
                perm[i] = j;
            }
        }
        return new Permutation(perm);
    }

    public int[] getCanonicalPermutation2(int[] partition, int[] max, int[] check) {
        int[] values = this.idValues(this.sum(partition));
        int i = 0;
        if (this.equalSetCheck(max, check, partition)) {
            int limit = this.findZeros(partition);
            for (int s = 0; s < limit; ++s) {
                int[] can = this.getBlocks(max, i, partition[s] + i);
                int[] non = this.getBlocks(check, i, partition[s] + i);
                values = this.getCyclesList(can, non, i, values);
                i += partition[s];
            }
        }
        return values;
    }

    public int[] getCyclesList(int[] max, int[] non, int index, int[] values) {
        for (int i = 0; i < max.length && max[i] != 0; ++i) {
            if (max[i] == non[i]) continue;
            int permutationIndex = this.findMatch(max, non, max[i], i);
            if (i != permutationIndex) {
                non = this.permuteArray(non, i, permutationIndex);
            }
            int temp = values[i + index];
            values[i + index] = values[permutationIndex + index];
            values[permutationIndex + index] = temp;
        }
        return values;
    }

    public int findMatch(int[] max, int[] non, int value, int start) {
        int length = non.length;
        int index = start;
        for (int i = start; i < length; ++i) {
            if (non[i] != value || max[i] == non[i]) continue;
            index = i;
            break;
        }
        return index;
    }

    public Permutation getEqualPerm(Permutation cycleTransposition, int index, int[][] a, int[] newPartition) {
        int[] check = this.row2compare(index, a, cycleTransposition);
        return this.getCanonicalPermutation(a[index], check, newPartition);
    }

    public Permutation getCanonicalCycle(int index, int total, int[][] a, int[] newPartition, Permutation cycleTransposition) {
        Permutation canonicalPermutation = this.idPermutation(total);
        if (!this.equalRowsCheck(index, a, cycleTransposition, canonicalPermutation)) {
            canonicalPermutation = this.getEqualPerm(cycleTransposition, index, a, newPartition);
        }
        return canonicalPermutation;
    }

    public boolean check(int index, int total, int[][] a, int[] newPartition, List<ArrayList<Permutation>> formerPermutations) {
        boolean check = true;
        ArrayList<Permutation> formerList = new ArrayList<Permutation>();
        ArrayList<Permutation> form = formerPermutations.get(index);
        for (Permutation permutation : form) {
            boolean biggest = this.setBiggest(index, a, permutation, newPartition);
            if (biggest) {
                Permutation canonicalPermutation = this.getCanonicalCycle(index, total, a, newPartition, permutation);
                int[] test = this.row2compare(index, a, permutation);
                if (this.descendingOrderUpperMatrixCheck(index, newPartition, a[index], test = this.actArray(test, canonicalPermutation))) {
                    if (canonicalPermutation.isIdentity()) {
                        if (!this.equalSetCheck2(newPartition, a[index], test)) continue;
                        formerList.add(permutation);
                        continue;
                    }
                    Permutation newPermutation = canonicalPermutation.multiply(permutation);
                    formerList.add(newPermutation);
                    continue;
                }
                formerList.clear();
                check = false;
                break;
            }
            formerList.clear();
            check = false;
            break;
        }
        if (check) {
            formerPermutations.get(index).clear();
            formerPermutations.set(index, formerList);
        }
        return check;
    }

    public List<Permutation> cycleTranspositions(int index, int[] partition) {
        ArrayList<Permutation> perms = new ArrayList<Permutation>();
        int lValue = this.lValue(partition, index);
        for (int i = 0; i < lValue; ++i) {
            int[] values = this.idValues(this.size);
            int former = values[index];
            values[index] = values[index + i];
            values[index + i] = former;
            Permutation p = new Permutation(values);
            perms.add(p);
        }
        return perms;
    }

    public int lValue(int[] partEx, int degree) {
        return this.sum(partEx, degree) - degree;
    }

    public int[] canonicalPartition(int i, int[] partition) {
        return this.partitionCriteria(partition, i + 1);
    }

    public void addOnes(int[] list, int number) {
        for (int i = 0; i < number; ++i) {
            list[i] = 1;
        }
    }

    public int findZeros(int[] array) {
        int index = this.size;
        for (int i = 0; i < this.size; ++i) {
            if (array[i] != 0) continue;
            index = i;
            break;
        }
        return index;
    }

    public int[] partitionCriteria(int[] partEx, int degree) {
        int[] partNew = new int[this.size];
        int limit = this.findZeros(partEx);
        if (this.zero(partEx)) {
            this.addOnes(partNew, degree);
            int index = degree;
            int oldValue = partEx[degree - 1];
            if (oldValue > 1) {
                partNew[index] = oldValue - 1;
                ++index;
                for (int k = degree; k < limit; ++k) {
                    partNew[index] = partEx[k];
                    ++index;
                }
            } else if (oldValue == 1) {
                for (int k = degree; k < limit; ++k) {
                    partNew[index] = partEx[k];
                    ++index;
                }
            }
            return partNew;
        }
        return partEx;
    }

    public void orderDegreeSymbols(int[] degree, String[] symbol, int index0, int index1, int[] hydrogens) {
        for (int i = index0; i < index1; ++i) {
            for (int j = i + 1; j < index1; ++j) {
                if (degree[i] <= degree[j]) continue;
                this.swap(symbol, i, j);
                int temp = degree[i];
                degree[i] = degree[j];
                degree[j] = temp;
                int temp2 = hydrogens[i];
                hydrogens[i] = hydrogens[j];
                hydrogens[j] = temp2;
            }
        }
    }

    public void swap(String[] array, int i, int j) {
        String temp = array[i];
        array[i] = array[j];
        array[j] = temp;
    }

    public void swap(int[] array, int i, int j) {
        int swapString = array[i];
        array[i] = array[j];
        array[j] = swapString;
    }

    public int[] sortWithPartition(int[] partitionList, int[] degrees, String[] symbols, int[] hydrogens) {
        int[] partition = this.buildArray(partitionList);
        int localSize = partition.length;
        for (int n = 0; n < localSize; ++n) {
            for (int m = 0; m < localSize - 1 - n; ++m) {
                if (partition[m] <= partition[m + 1]) continue;
                this.swap(partition, m, m + 1);
                this.swap(degrees, m, m + 1);
                this.swap(hydrogens, m, m + 1);
                this.swap(symbols, m, m + 1);
            }
        }
        this.reOrder(partition, degrees, symbols, hydrogens);
        return this.initialPartition(partition);
    }

    public int[] initialPartition(int[] partition) {
        int part;
        int index2 = 0;
        int[] init = new int[this.size];
        for (int index = 0; index != this.hIndex; index += part) {
            part = partition[index];
            init[index2++] = part;
        }
        return init;
    }

    public int[] buildArray(int[] partition) {
        int[] partitionArray = new int[this.sum(partition)];
        int index = 0;
        for (int p : partition) {
            for (int i = 0; i < p; ++i) {
                partitionArray[index] = p;
                ++index;
            }
        }
        return partitionArray;
    }

    public void reOrder(int[] partition, int[] degrees, String[] symbols, int[] hydrogens) {
        int part;
        for (int index = 0; index != this.hIndex; index += part) {
            part = partition[index];
            this.orderDegreeSymbols(degrees, symbols, index, index + part, hydrogens);
        }
    }

    public Map<String, Integer[]> getFuzzyFormulaRanges(String localFormula, List<String> symbolList) {
        String[] atoms = localFormula.split(LETTERS_FROM_A_TO_Z);
        HashMap<String, Integer[]> symbolsMap = new HashMap<String, Integer[]>();
        for (String atom : atoms) {
            String symbol;
            String[] info = atom.split("\\[");
            Integer[] n = new Integer[2];
            if (info.length == 1) {
                String[] info2 = info[0].split(NUMBERS_FROM_0_TO_9, 2);
                symbol = info2[0];
                if (info2.length == 1) {
                    n[0] = 1;
                    n[1] = 1;
                } else {
                    n[0] = Integer.valueOf(info2[1]);
                    n[1] = Integer.valueOf(info2[1]);
                }
            } else {
                symbol = info[0];
                String[] info3 = info[1].split("-");
                n[0] = Integer.valueOf(info3[0]);
                n[1] = Integer.valueOf(info3[1].split("]")[0]);
            }
            symbolList.add(symbol);
            symbolsMap.put(symbol, n);
        }
        return symbolsMap;
    }

    public Map<String, Integer[]> getFuzzyFormulaRangesWithNewElements(String localFormula, List<String> symbolList) {
        String[] atoms = localFormula.split(LETTERS_FROM_A_TO_Z);
        HashMap<String, Integer[]> symbolsMap = new HashMap<String, Integer[]>();
        for (String atom : atoms) {
            String symbol;
            String[] info = atom.split("\\(val=");
            Integer[] n = new Integer[2];
            if (info.length != 1) {
                symbol = this.getSymbol(info, n);
            } else {
                String[] info4 = info[0].split(NUMBERS_FROM_0_TO_9);
                symbol = info4[0];
                if (info4.length == 1) {
                    n[0] = 1;
                    n[1] = 1;
                } else {
                    n[0] = Integer.valueOf(info4[1]);
                    n[1] = Integer.valueOf(info4[1]);
                }
            }
            symbolList.add(symbol);
            symbolsMap.put(symbol, n);
        }
        return symbolsMap;
    }

    public String getSymbol(String[] info, Integer[] n) {
        String symbol = info[0];
        String[] info2 = info[1].split("\\)");
        symbol = symbol + "(" + info2[0] + ")";
        if (info2.length == 1) {
            n[0] = 1;
            n[1] = 1;
        } else {
            String[] info3 = info2[1].split("-");
            if (info3.length == 1) {
                n[0] = Integer.valueOf(info3[0]);
                n[1] = Integer.valueOf(info3[0]);
            } else {
                n[0] = Integer.valueOf(info3[0].split("\\[")[1]);
                n[1] = Integer.valueOf(info3[1].split("]")[0]);
            }
        }
        return symbol;
    }

    public void generateFormulae(List<String> result, List<String> symbolList, Map<String, Integer[]> symbols, String localFormula, int index) {
        if (index == symbols.size()) {
            result.add(localFormula);
        } else {
            String symbol = symbolList.get(index);
            Integer[] range = symbols.get(symbol);
            for (int i = range[0].intValue(); i <= range[1]; ++i) {
                this.generateFormulae(result, symbolList, symbols, this.extendFormula(localFormula, i, symbol), index + 1);
            }
        }
    }

    public String extendFormula(String localFormula, int number, String symbol) {
        String newFormula = localFormula;
        if (number == 1) {
            newFormula = newFormula + symbol;
        } else if (number > 1) {
            newFormula = newFormula + symbol + number;
        }
        return newFormula;
    }

    public List<String> getFormulaList(String normalizedLocalFuzzyFormula) {
        ArrayList<String> result = new ArrayList<String>();
        CharSequence[] unsupportedSymbols = null;
        if (!this.setElement) {
            unsupportedSymbols = this.validateFuzzyFormula(normalizedLocalFuzzyFormula);
        }
        if (unsupportedSymbols != null && unsupportedSymbols.length > 0) {
            if (this.verbose) {
                this.logger.info((Object)("The input fuzzyFormula consists user defined element types: " + String.join((CharSequence)", ", unsupportedSymbols)));
            }
        } else {
            ArrayList<String> symbolList = new ArrayList<String>();
            Map<String, Integer[]> localSymbols = this.setElement ? this.getFuzzyFormulaRangesWithNewElements(normalizedLocalFuzzyFormula, symbolList) : this.getFuzzyFormulaRanges(normalizedLocalFuzzyFormula, symbolList);
            String newFormula = "";
            this.generateFormulae(result, symbolList, localSymbols, newFormula, 0);
        }
        return result;
    }

    public void emit(IAtomContainer mol) throws CDKException, IOException {
        this.consumer.consume(mol);
    }

    public void initSingleAC() {
        this.atomContainer = this.builder.newAtomContainer();
        for (String s : this.symbolArray) {
            IAtom atom = this.builder.newAtom();
            atom.setSymbol(s);
            this.atomContainer.addAtom(atom);
        }
        for (IAtom atom : this.atomContainer.atoms()) {
            atom.setImplicitHydrogenCount(Integer.valueOf(0));
        }
    }

    public void intAC(String formula) {
        String[] atoms = formula.split(LETTERS_FROM_A_TO_Z);
        ArrayList<String> symbolList = new ArrayList<String>();
        for (String atom : atoms) {
            String[] info = atom.split(NUMBERS_FROM_0_TO_9, 2);
            String symbol = info[0].split("\\(")[0];
            int occur = this.atomOccurrence(info);
            for (int i = 0; i < occur; ++i) {
                symbolList.add(symbol);
            }
        }
        this.atomContainer = this.builder.newAtomContainer();
        for (String s : symbolList) {
            IAtom atom = this.builder.newAtom();
            atom.setSymbol(s);
            this.atomContainer.addAtom(atom);
        }
        for (IAtom atom : this.atomContainer.atoms()) {
            atom.setImplicitHydrogenCount(Integer.valueOf(0));
        }
    }

    public IAtomContainer initAC(IAtomContainer ac, String[] symbolArrayCopy) {
        for (String s : symbolArrayCopy) {
            IAtom atom = this.builder.newAtom();
            atom.setSymbol(s.split(NUMBERS_FROM_0_TO_9)[0]);
            ac.addAtom(atom);
        }
        for (IAtom atom : ac.atoms()) {
            atom.setImplicitHydrogenCount(Integer.valueOf(0));
        }
        return ac;
    }

    public void initAC(String symbol) {
        this.atomContainer = this.builder.newAtomContainer();
        for (int i = 0; i < this.matrixSize; ++i) {
            IAtom atom = this.builder.newAtom();
            atom.setSymbol(symbol);
            this.atomContainer.addAtom(atom);
        }
        for (IAtom atom : this.atomContainer.atoms()) {
            atom.setImplicitHydrogenCount(Integer.valueOf(0));
        }
    }

    public IAtomContainer buildAtomContainerFromMatrix(int[][] mat, IAtomContainer atomContainer) {
        for (int i = 0; i < mat.length; ++i) {
            for (int j = i + 1; j < mat.length; ++j) {
                if (mat[i][j] == 1) {
                    atomContainer.addBond(i, j, IBond.Order.SINGLE);
                    continue;
                }
                if (mat[i][j] == 2) {
                    atomContainer.addBond(i, j, IBond.Order.DOUBLE);
                    continue;
                }
                if (mat[i][j] != 3) continue;
                atomContainer.addBond(i, j, IBond.Order.TRIPLE);
            }
        }
        return AtomContainerManipulator.suppressHydrogens((IAtomContainer)atomContainer);
    }

    public IAtomContainer buildContainer4SDF(IAtomContainer ac, int[][] mat) throws CloneNotSupportedException {
        IAtomContainer ac2 = ac.clone();
        for (int i = 0; i < mat.length; ++i) {
            for (int j = i + 1; j < mat.length; ++j) {
                if (mat[i][j] == 1) {
                    ac2.addBond(i, j, IBond.Order.SINGLE);
                    continue;
                }
                if (mat[i][j] == 2) {
                    ac2.addBond(i, j, IBond.Order.DOUBLE);
                    continue;
                }
                if (mat[i][j] != 3) continue;
                ac2.addBond(i, j, IBond.Order.TRIPLE);
            }
        }
        return AtomContainerManipulator.suppressHydrogens((IAtomContainer)ac2);
    }

    public IAtomContainer buildContainer4SDF(int[][] mat) throws CloneNotSupportedException {
        IAtomContainer ac2 = this.atomContainer.clone();
        for (int i = 0; i < mat.length; ++i) {
            for (int j = i + 1; j < mat.length; ++j) {
                if (mat[i][j] == 1) {
                    ac2.addBond(i, j, IBond.Order.SINGLE);
                    continue;
                }
                if (mat[i][j] == 2) {
                    ac2.addBond(i, j, IBond.Order.DOUBLE);
                    continue;
                }
                if (mat[i][j] != 3) continue;
                ac2.addBond(i, j, IBond.Order.TRIPLE);
            }
        }
        return AtomContainerManipulator.suppressHydrogens((IAtomContainer)ac2);
    }

    public IAtomContainer buildContainer4SDF(String[] symbols) throws CloneNotSupportedException {
        IAtomContainer ac = this.builder.newAtomContainer();
        for (String s : symbols) {
            String symbol = s.split(NUMBERS_FROM_0_TO_9)[0];
            IAtom atom = this.builder.newAtom();
            atom.setSymbol(symbol);
            ac.addAtom(atom);
        }
        for (IAtom atom : ac.atoms()) {
            atom.setImplicitHydrogenCount(Integer.valueOf(0));
        }
        return this.buildContainer4SDF(ac, this.generateOnSmMat());
    }

    public int[][] generateOnSmMat() {
        int[][] ring = new int[this.matrixSize][this.matrixSize];
        ring[0][1] = 1;
        ring[0][this.matrixSize - 1] = 1;
        for (int i = 1; i < this.matrixSize - 1; ++i) {
            ring[i][i + 1] = 1;
        }
        return ring;
    }

    public void degree2graph() throws IOException, CDKException, CloneNotSupportedException {
        int[][] mat = new int[this.matrixSize][this.matrixSize];
        mat[0][1] = 1;
        mat[0][2] = 1;
        for (int i = 1; i < this.matrixSize - 2; ++i) {
            mat[i][i + 2] = 1;
        }
        mat[this.matrixSize - 2][this.matrixSize - 1] = 1;
        this.count.incrementAndGet();
        String symbol = this.oxygen == 0 ? "S" : "O";
        this.initAC(symbol);
        this.emit(this.buildContainer4SDF(mat));
    }

    public void getHigherValences(String localFormula) {
        String[] atoms;
        for (String atom : atoms = localFormula.split(LETTERS_FROM_A_TO_Z)) {
            String[] info = atom.split("\\(");
            if (info.length == 1) continue;
            String symbol = info[0];
            String[] info2 = info[1].split("\\)");
            String valence = info2[0];
            this.valences.put(symbol + valence, Integer.valueOf(valence));
        }
    }

    public int reverseComparison(int length, int index) {
        for (int i = index + 1; i <= (length + 1) / 2; ++i) {
            if (this.nodeLabels[i] < this.nodeLabels[length - i + 1]) {
                return 0;
            }
            if (this.nodeLabels[i] <= this.nodeLabels[length - i + 1]) continue;
            return -1;
        }
        return 1;
    }

    public String[] buildSymbolArray() {
        String[] arr = new String[this.graphSize];
        for (int i = 1; i < this.graphSize + 1; ++i) {
            arr[i - 1] = this.nodeLabels[i] == 0 ? "O" : "S";
        }
        return arr;
    }

    public void distributeSymbols(int oxy, int sul, int nextSize, int currentSize, int reversedLength, int leftEquivalents, int rightEquivalents, boolean reversalIsSmaller) throws CDKException, CloneNotSupportedException, IOException {
        if (2 * (nextSize - 1) > this.graphSize + reversedLength) {
            reversalIsSmaller = this.isReversalIsSmaller(nextSize, reversedLength, reversalIsSmaller);
        }
        if (nextSize > this.graphSize) {
            this.distributeSymbolsNextSizeAboveGraphSize(currentSize, reversalIsSmaller);
        } else {
            int oxy2 = oxy;
            int sul2 = sul;
            this.nodeLabels[nextSize] = this.nodeLabels[nextSize - currentSize];
            if (this.nodeLabels[nextSize] == 0) {
                --oxy2;
            } else {
                --sul2;
            }
            rightEquivalents = this.nodeLabels[nextSize] == this.nodeLabels[1] ? ++rightEquivalents : 0;
            if (leftEquivalents == nextSize - 1 && this.nodeLabels[nextSize - 1] == this.nodeLabels[1]) {
                ++leftEquivalents;
            }
            if (oxy2 >= 0 && sul2 >= 0 && (nextSize != this.graphSize || leftEquivalents == this.graphSize || this.nodeLabels[this.graphSize] != this.nodeLabels[1])) {
                this.doDistributeSymbols(nextSize, currentSize, reversedLength, leftEquivalents, rightEquivalents, reversalIsSmaller, oxy2, sul2);
            }
            if (leftEquivalents == nextSize) {
                --leftEquivalents;
            }
            this.runDistributeSymbolsCheckNodeLabels(oxy, sul, nextSize, currentSize, reversedLength, leftEquivalents, reversalIsSmaller);
        }
    }

    private void doDistributeSymbols(int nextSize, int currentSize, int reversedLength, int leftEquivalents, int rightEquivalents, boolean reversalIsSmaller, int oxy2, int sul2) throws CDKException, CloneNotSupportedException, IOException {
        if (leftEquivalents == rightEquivalents) {
            int reverse = this.reverseComparison(nextSize, leftEquivalents);
            this.runDistributeSymbols(nextSize, currentSize, reversedLength, leftEquivalents, rightEquivalents, reversalIsSmaller, oxy2, sul2, reverse);
        } else {
            this.distributeSymbols(oxy2, sul2, nextSize + 1, currentSize, reversedLength, leftEquivalents, rightEquivalents, reversalIsSmaller);
        }
    }

    public void runDistributeSymbolsCheckNodeLabels(int oxy, int sul, int nextSize, int currentSize, int reversedLength, int leftEquivalents, boolean reversalIsSmaller) throws CDKException, CloneNotSupportedException, IOException {
        if (this.nodeLabels[nextSize - currentSize] == 0 && sul > 0) {
            this.nodeLabels[nextSize] = 1;
            if (nextSize == 1) {
                this.distributeSymbols(oxy, sul - 1, nextSize + 1, nextSize, 1, 1, 1, reversalIsSmaller);
            } else {
                this.distributeSymbols(oxy, sul - 1, nextSize + 1, nextSize, reversedLength, leftEquivalents, 0, reversalIsSmaller);
            }
        }
    }

    public void runDistributeSymbols(int nextSize, int currentSize, int reversedLength, int leftEquivalents, int rightEquivalents, boolean reversalIsSmaller, int oxy2, int sul2, int reverse) throws CDKException, CloneNotSupportedException, IOException {
        if (reverse == 0) {
            this.distributeSymbols(oxy2, sul2, nextSize + 1, currentSize, reversedLength, leftEquivalents, rightEquivalents, reversalIsSmaller);
        } else if (reverse == 1) {
            this.distributeSymbols(oxy2, sul2, nextSize + 1, currentSize, nextSize, leftEquivalents, rightEquivalents, false);
        }
    }

    public void distributeSymbolsNextSizeAboveGraphSize(int currentSize, boolean reversalIsSmaller) throws CloneNotSupportedException, CDKException, IOException {
        if (!reversalIsSmaller && this.graphSize % currentSize == 0) {
            this.count.incrementAndGet();
            this.emit(this.buildContainer4SDF(this.buildSymbolArray()));
        }
    }

    public boolean isReversalIsSmaller(int nextSize, int reversedLength, boolean reversalIsSmaller) {
        if (this.nodeLabels[nextSize - 1] > this.nodeLabels[this.graphSize - nextSize + 2 + reversedLength]) {
            reversalIsSmaller = false;
        } else if (this.nodeLabels[nextSize - 1] < this.nodeLabels[this.graphSize - nextSize + 2 + reversedLength]) {
            reversalIsSmaller = true;
        }
        return reversalIsSmaller;
    }

    public void distributeSulfurOxygen(String localFormula) throws CDKException, CloneNotSupportedException, IOException {
        this.graphSize = this.oxygen + this.sulfur;
        this.nodeLabels = new int[this.graphSize + 1];
        this.nodeLabels[0] = 0;
        this.intAC(localFormula);
        this.distributeSymbols(this.oxygen, this.sulfur, 1, 1, 0, 0, 0, false);
    }

    public static interface Consumer
    extends Closeable {
        public void consume(IAtomContainer var1);

        default public void configure(String name) {
        }

        @Override
        default public void close() throws IOException {
        }
    }
}

