/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.types.tests;

import cc.mallet.types.Alphabet;
import cc.mallet.types.FeatureSequence;
import cc.mallet.types.Multinomial;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class TestMultinomial
extends TestCase {
    public TestMultinomial(String name) {
        super(name);
    }

    public void testMultinomial() {
        double[] c = new double[]{0.2, 0.3, 0.1, 0.4};
        Multinomial m = new Multinomial(c);
        TestMultinomial.assertTrue(m.probability(0) == 0.2);
    }

    public void testEstimating() {
        Alphabet dict = new Alphabet();
        Multinomial.LaplaceEstimator e = new Multinomial.LaplaceEstimator(dict);
        FeatureSequence fs = new FeatureSequence(dict);
        fs.add(dict.lookupIndex("a"));
        fs.add(dict.lookupIndex("n"));
        fs.add(dict.lookupIndex("d"));
        fs.add(dict.lookupIndex("r"));
        fs.add(dict.lookupIndex("e"));
        fs.add(dict.lookupIndex("w"));
        fs.add(dict.lookupIndex("m"));
        fs.add(dict.lookupIndex("c"));
        fs.add(dict.lookupIndex("c"));
        fs.add(dict.lookupIndex("a"));
        fs.add(dict.lookupIndex("l"));
        fs.add(dict.lookupIndex("l"));
        fs.add(dict.lookupIndex("u"));
        fs.add(dict.lookupIndex("m"));
        e.increment(fs);
        TestMultinomial.assertTrue(e.size() == 10);
        Multinomial m = ((Multinomial.Estimator)e).estimate();
        TestMultinomial.assertTrue(m.size() == 10);
        TestMultinomial.assertTrue(m.probability(dict.lookupIndex("a")) == 0.125);
        TestMultinomial.assertTrue(m.probability("w") == 0.08333333333333333);
        Multinomial.Logged ml = new Multinomial.Logged(m);
        TestMultinomial.assertTrue(m.logProbability("w") == ml.logProbability("w"));
    }

    public static Test suite() {
        return new TestSuite((Class<?>)TestMultinomial.class);
    }

    @Override
    protected void setUp() {
    }

    public static void main(String[] args) {
        TestRunner.run(TestMultinomial.suite());
    }
}

