/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.pipe;

import cc.mallet.pipe.Pipe;
import cc.mallet.types.Alphabet;
import cc.mallet.types.FeatureVector;
import cc.mallet.types.Instance;
import java.io.Serializable;
import java.util.Arrays;

public class TargetStringToFeatures
extends Pipe
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final int CURRENT_SERIAL_VERSION = 0;

    public TargetStringToFeatures() {
        super(null, new Alphabet());
    }

    @Override
    public Instance pipe(Instance carrier) {
        if (!(carrier.getTarget() instanceof String)) {
            throw new IllegalArgumentException("Target must be of type String");
        }
        String featuresLine = (String)carrier.getTarget();
        Object[] features = featuresLine.split(",?\\s+");
        double[] values = new double[features.length];
        Arrays.fill(values, 1.0);
        for (int i = 0; i < features.length; ++i) {
            if (features[i].indexOf("=") != -1) {
                String[] keyValuePair = ((String)features[i]).split("=");
                features[i] = keyValuePair[0];
                values[i] = Double.parseDouble(keyValuePair[1]);
            }
            this.getTargetAlphabet().lookupIndex(features[i], true);
        }
        FeatureVector target = new FeatureVector(this.getTargetAlphabet(), features, values);
        carrier.setTarget(target);
        return carrier;
    }
}

