/*
 * Decompiled with CFR 0.152.
 */
package org.af.gMCP.gui.power;

import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;

public class HorizontalButtonPane
extends JPanel {
    protected final String[] cmds;
    protected final JButton[] buttons;
    protected final boolean rightSpace;
    public static final String OK_CMD = "OK";
    public static final String CANCEL_CMD = "CANCEL";
    public static final String APPLY_CMD = "APPLY";

    public HorizontalButtonPane(List<String> captions, List<String> cmds) {
        this(captions.toArray(new String[1]), cmds.toArray(new String[1]));
    }

    public HorizontalButtonPane(List<JButton> buttons, boolean rightSpace) {
        this(buttons.toArray(new JButton[1]), rightSpace);
    }

    public HorizontalButtonPane(JButton[] buttons, boolean rightSpace) {
        this.buttons = buttons;
        this.cmds = new String[buttons.length];
        this.rightSpace = rightSpace;
        this.setLayout();
    }

    public HorizontalButtonPane(String[] captions, String[] cmds) {
        this.cmds = cmds;
        this.buttons = new JButton[cmds.length];
        for (int i = 0; i < this.buttons.length; ++i) {
            this.buttons[i] = new JButton(captions[i]);
            this.buttons[i].setActionCommand(cmds[i]);
        }
        this.rightSpace = true;
        this.setLayout();
    }

    private void setLayout() {
        this.setLayout(new BoxLayout(this, 0));
        this.add(Box.createHorizontalGlue());
        for (int i = 0; i < this.buttons.length; ++i) {
            this.add(this.buttons[i]);
            if (!this.rightSpace && i == this.buttons.length - 1) continue;
            this.add(Box.createHorizontalStrut(5));
        }
    }

    public void addActionListener(ActionListener al) {
        for (JButton b : this.buttons) {
            b.addActionListener(al);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        for (JButton b : this.buttons) {
            b.setEnabled(enabled);
        }
    }

    public void setEnabled(int i, boolean enabled) {
        this.buttons[i].setEnabled(enabled);
    }

    public void setText(int i, String text) {
        this.buttons[i].setText(text);
    }
}

