/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Neural_Networks.NNEP_Common.data;

import java.io.BufferedReader;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import keel.Algorithms.Neural_Networks.NNEP_Common.data.AttributeType;
import keel.Algorithms.Neural_Networks.NNEP_Common.data.CategoricalAttribute;
import keel.Algorithms.Neural_Networks.NNEP_Common.data.DatasetException;
import keel.Algorithms.Neural_Networks.NNEP_Common.data.IDataset;
import keel.Algorithms.Neural_Networks.NNEP_Common.data.IMetadata;
import net.sf.jclec.IConfigure;
import org.apache.commons.configuration.Configuration;

public class DoubleTransposedDataSet
implements IConfigure {
    private static final long serialVersionUID = -7161371989002786655L;
    String fileName;
    protected int nofobservations = -1;
    protected int nofvariables = -1;
    protected int nofinputs = -1;
    protected int nofoutputs = -1;
    protected double[][] array;
    protected double[] outputMeans;
    protected double maximumDistance;

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public int getNofinputs() {
        return this.nofinputs;
    }

    public void setNofinputs(int nofinputs) {
        this.nofinputs = nofinputs;
        if (this.nofoutputs != -1 && this.nofobservations != -1) {
            this.init();
        }
    }

    public int getNofobservations() {
        return this.nofobservations;
    }

    public void setNofobservations(int nofobservations) {
        this.nofobservations = nofobservations;
        if (this.nofoutputs != -1 && this.nofinputs != -1) {
            this.init();
        }
    }

    public int getNofvariables() {
        return this.nofvariables;
    }

    public void setNofvariables(int nofvariables) {
        this.nofvariables = nofvariables;
    }

    public int getNofoutputs() {
        return this.nofoutputs;
    }

    public void setNofoutputs(int nofoutputs) {
        this.nofoutputs = nofoutputs;
        if (this.nofinputs != -1 && this.nofobservations != -1) {
            this.init();
        }
    }

    public double[] getObservation(int nofobservation) {
        double[] observation = new double[this.nofvariables];
        for (int i = 0; i < this.nofvariables; ++i) {
            observation[i] = this.array[i][nofobservation];
        }
        return observation;
    }

    public void setObservation(int nofobservation, double[] observation) {
        for (int i = 0; i < this.nofvariables; ++i) {
            this.array[i][nofobservation] = observation[i];
        }
    }

    public double[] getOutputs(int nofobservation) {
        double[] outputs = new double[this.nofoutputs];
        for (int i = this.nofinputs; i < this.nofvariables; ++i) {
            outputs[i - this.nofinputs] = this.array[i][nofobservation];
        }
        return outputs;
    }

    public double[][] getAllOutputs() {
        double[][] outputs = new double[this.nofoutputs][this.nofobservations];
        for (int i = this.nofinputs; i < this.nofvariables; ++i) {
            outputs[i - this.nofinputs] = this.array[i];
        }
        return outputs;
    }

    public double[] getInputs(int nofobservation) {
        double[] inputs = new double[this.nofinputs];
        for (int i = 0; i < this.nofinputs; ++i) {
            inputs[i] = this.array[i][nofobservation];
        }
        return inputs;
    }

    public double[][] getAllInputs() {
        double[][] inputs = new double[this.nofinputs][this.nofobservations];
        for (int i = 0; i < this.nofinputs; ++i) {
            inputs[i] = this.array[i];
        }
        return inputs;
    }

    public double[] getOutput(int nofoutput) {
        return this.array[this.nofinputs + nofoutput];
    }

    public void setOutput(int nofoutput, double[] values) {
        this.array[this.nofinputs + nofoutput] = values;
    }

    public double[] getObservationsOf(int nofvariable) {
        return this.array[nofvariable];
    }

    public void setObservationsOf(int nofvariable, double[] values) {
        this.array[nofvariable] = values;
    }

    public double getOutputMean(int index) {
        return this.outputMeans[index];
    }

    public double getMaxValueOf(int index) {
        double max = this.array[index][0];
        for (int i = 0; i < this.nofobservations; ++i) {
            if (!(this.array[index][i] > max)) continue;
            max = this.array[index][i];
        }
        return max;
    }

    public double getMinValueOf(int index) {
        double min = this.array[index][0];
        for (int i = 0; i < this.nofobservations; ++i) {
            if (!(this.array[index][i] < min)) continue;
            min = this.array[index][i];
        }
        return min;
    }

    public double getMaximumDistance() {
        return this.maximumDistance;
    }

    public void setMaximumDistance(double maximumDistance) {
        this.maximumDistance = maximumDistance;
    }

    public void read(byte[] schema, IDataset dataset) throws DatasetException {
        dataset.open();
        this.setNofobservations(dataset.numberOfInstances());
        int nOfInputs = 0;
        int nOfOutputs = 0;
        for (int i = 0; i < schema.length; ++i) {
            if (schema[i] == 1) {
                ++nOfInputs;
                continue;
            }
            if (schema[i] != 2) continue;
            ++nOfOutputs;
        }
        IMetadata metadata = dataset.getMetadata();
        for (int i = 0; i < metadata.numberOfAttributes(); ++i) {
            if (metadata.getAttribute(i).getType() != AttributeType.Categorical) continue;
            int numberCategories = ((CategoricalAttribute)metadata.getAttribute(i)).getNumberCategories();
            if (numberCategories == 2 && schema[i] == 1) {
                numberCategories = 1;
            }
            if (schema[i] == 1) {
                nOfInputs += numberCategories - 1;
                continue;
            }
            if (schema[i] != 2) continue;
            nOfOutputs += numberCategories - 1;
        }
        this.setNofinputs(nOfInputs);
        this.setNofoutputs(nOfOutputs);
        int inputCounter = 0;
        int outputCounter = 0;
        int instanceCounter = 0;
        while (dataset.next()) {
            IDataset.IInstance instancia = dataset.read();
            boolean lostValues = false;
            for (int i = 0; i < schema.length; ++i) {
                int j;
                double value = instancia.getValue(i);
                if (Double.isNaN(value)) {
                    lostValues = true;
                }
                if (metadata.getAttribute(i).getType() != AttributeType.Categorical) {
                    if (schema[i] == 1) {
                        this.array[inputCounter++][instanceCounter] = value;
                        continue;
                    }
                    if (schema[i] != 2) continue;
                    this.array[nOfInputs + outputCounter++][instanceCounter] = value;
                    continue;
                }
                CategoricalAttribute attribute = (CategoricalAttribute)metadata.getAttribute(i);
                int numberCategories = attribute.getNumberCategories();
                if (numberCategories == 2 && schema[i] == 1) {
                    numberCategories = 1;
                }
                if (schema[i] == 1) {
                    for (j = 1; j <= numberCategories; ++j) {
                        this.array[inputCounter++][instanceCounter] = value == (double)j ? 1 : 0;
                    }
                    continue;
                }
                if (schema[i] != 2) continue;
                for (j = 1; j <= numberCategories; ++j) {
                    this.array[nOfInputs + outputCounter++][instanceCounter] = value == (double)j ? 1 : 0;
                }
            }
            if (!lostValues) {
                ++instanceCounter;
            }
            inputCounter = 0;
            outputCounter = 0;
        }
        if (instanceCounter < this.nofobservations) {
            this.nofobservations = instanceCounter;
            double[][] auxArray = this.array;
            this.array = new double[this.nofvariables][this.nofobservations];
            for (int i = 0; i < this.array.length; ++i) {
                System.arraycopy(auxArray[i], 0, this.array[i], 0, this.array[i].length);
            }
        }
        dataset.close();
        this.calculateMeans();
    }

    public void read() throws IOException, NumberFormatException {
        try {
            BufferedReader reader = new BufferedReader(new FileReader(this.fileName));
            String[] values = reader.readLine().split("[\\s\\t]");
            if (values.length < 3) {
                throw new IOException("Illegal Text Format");
            }
            this.setNofobservations(Integer.parseInt(values[0]));
            this.setNofinputs(Integer.parseInt(values[1]));
            this.setNofoutputs(Integer.parseInt(values[2]));
            values = reader.readLine().split("[\\s\\t]");
            int nofrealvariables = 0;
            for (int i = 0; i < values.length; ++i) {
                if (Byte.parseByte(values[i]) != 1 && Byte.parseByte(values[i]) != 2) continue;
                ++nofrealvariables;
            }
            if (nofrealvariables != this.nofvariables) {
                throw new IOException("Illegal Text Format");
            }
            byte[] iSchema = new byte[values.length];
            for (int i = 0; i < iSchema.length; ++i) {
                iSchema[i] = Byte.parseByte(values[i]);
            }
            int ic = 0;
            int oc = 0;
            for (int i = 0; i < this.nofobservations; ++i) {
                values = reader.readLine().split("[\\s\\t]");
                if (values.length < iSchema.length) {
                    throw new IOException("Illegal Text Format");
                }
                for (int j = 0; j < iSchema.length; ++j) {
                    double value = Double.parseDouble(values[j]);
                    if (iSchema[j] == 1) {
                        this.array[ic % this.nofinputs][i] = value;
                        ++ic;
                    }
                    if (iSchema[j] != 2) continue;
                    this.array[this.nofinputs + oc % this.nofoutputs][i] = value;
                    ++oc;
                }
            }
        }
        catch (EOFException e) {
            System.out.println("Illegal Text Format");
            throw new IOException("Illegal Text Format");
        }
        catch (NumberFormatException e) {
            System.out.println("Number format exception");
            throw e;
        }
        catch (FileNotFoundException e) {
            System.out.println("File not found");
            throw e;
        }
        this.calculateMeans();
    }

    public void calculateMeans() {
        int j;
        if (this.outputMeans == null) {
            this.outputMeans = new double[this.nofoutputs];
        }
        for (j = 0; j < this.nofoutputs; ++j) {
            this.outputMeans[j] = 0.0;
        }
        for (int i = 0; i < this.nofobservations; ++i) {
            for (int j2 = 0; j2 < this.nofoutputs; ++j2) {
                int n = j2;
                this.outputMeans[n] = this.outputMeans[n] + this.array[this.nofinputs + j2][i];
            }
        }
        j = 0;
        while (j < this.nofoutputs) {
            int n = j++;
            this.outputMeans[n] = this.outputMeans[n] / (double)this.nofobservations;
        }
        this.obtainMaximumDistance();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("<DataSet>\n");
        sb.append("<nofobservations>" + this.nofobservations + "</nofobservations>\n");
        sb.append("<nofinputs>" + this.nofinputs + "</nofinputs>\n");
        sb.append("<nofoutputs>" + this.nofoutputs + "</nofoutputs>\n");
        sb.append("<observations>\n");
        for (int i = 0; i < this.nofobservations; ++i) {
            for (int j = 0; j < this.nofvariables; ++j) {
                sb.append(this.array[j][i] + " ");
            }
            sb.append("\n");
        }
        sb.append("</observations>\n");
        sb.append("</DataSet>");
        return sb.toString();
    }

    public DoubleTransposedDataSet copy() {
        DoubleTransposedDataSet result = new DoubleTransposedDataSet();
        result.fileName = this.fileName;
        result.setNofobservations(this.nofobservations);
        result.setNofinputs(this.nofinputs);
        result.setNofoutputs(this.nofoutputs);
        for (int i = 0; i < this.nofvariables; ++i) {
            System.arraycopy(this.array[i], 0, result.array[i], 0, this.nofobservations);
        }
        result.calculateMeans();
        return result;
    }

    public boolean[] obtainConstantsInputs() {
        boolean[] toRemove = new boolean[this.nofinputs];
        for (int i = 0; i < this.nofinputs; ++i) {
            int j;
            toRemove[i] = false;
            double value = this.array[i][0];
            for (j = 1; j < this.nofobservations && this.array[i][j] == value; ++j) {
            }
            if (j != this.nofobservations) continue;
            toRemove[i] = true;
        }
        return toRemove;
    }

    public void removeInputs(boolean[] toRemove, int newNofinputs) {
        DoubleTransposedDataSet aux = this.copy();
        this.setNofinputs(newNofinputs);
        int j = 0;
        for (int i = 0; i < aux.nofvariables; ++i) {
            if (i < aux.nofinputs && (i >= aux.nofinputs || toRemove[i])) continue;
            System.arraycopy(aux.array[i], 0, this.array[j], 0, this.nofobservations);
            ++j;
        }
    }

    private void init() {
        this.setNofvariables(this.nofinputs + this.nofoutputs);
        this.array = new double[this.nofvariables][this.nofobservations];
    }

    private void obtainMaximumDistance() {
        this.maximumDistance = 0.0;
        for (int i = 0; i < this.getNofobservations(); ++i) {
            for (int j = i + 1; j < this.getNofobservations(); ++j) {
                double distance = 0.0;
                for (int k = 0; k < this.getNofinputs(); ++k) {
                    double firstComponent = this.getInputs(i)[k];
                    double secondComponent = this.getInputs(j)[k];
                    distance += Math.pow(firstComponent - secondComponent, 2.0);
                }
                if (!((distance = Math.sqrt(distance)) > this.maximumDistance)) continue;
                this.maximumDistance = distance;
            }
        }
    }

    @Override
    public void configure(Configuration settings) {
        this.fileName = settings.getString("[@file-name]");
    }
}

