/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jclec.exprtree;

import javolution.xml.XmlElement;
import javolution.xml.XmlFormat;
import net.sf.jclec.IFitness;
import net.sf.jclec.IIndividual;
import net.sf.jclec.base.AbstractIndividual;
import net.sf.jclec.exprtree.ExprTree;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExprTreeIndividual
extends AbstractIndividual<ExprTree[]> {
    protected static final XmlFormat<ExprTreeIndividual> INDIVIDUAL_XML = new XmlFormat<ExprTreeIndividual>(ExprTreeIndividual.class){

        @Override
        public void format(ExprTreeIndividual source, XmlElement xml) {
            ExprTreeIndividual.access$0().format(source, xml);
            xml.add(source.genotype, "genotype", GENOTYPE_XML);
        }

        @Override
        public ExprTreeIndividual parse(XmlElement xml) {
            ExprTreeIndividual result = (ExprTreeIndividual)ExprTreeIndividual.access$0().parse(xml);
            result.genotype = (ExprTree[])xml.get("genotype", GENOTYPE_XML);
            return result;
        }

        @Override
        public String defaultName() {
            return "expr-tree-individual";
        }
    };
    protected static final XmlFormat<ExprTree[]> GENOTYPE_XML = new XmlFormat<ExprTree[]>(ExprTree[].class){

        @Override
        public void format(ExprTree[] source, XmlElement xml) {
            int numberOfExpr = source.length;
            xml.setAttribute("number-of-expressions", numberOfExpr);
            int i = 0;
            while (i < numberOfExpr) {
                xml.add(source[i], "expression", ExprTree.EXPR_TREE_XML);
                ++i;
            }
        }

        @Override
        public ExprTree[] parse(XmlElement xml) {
            int numberOfExpressions = xml.getAttribute("number-of-expressions", 0);
            ExprTree[] result = new ExprTree[numberOfExpressions];
            int i = 0;
            while (i < numberOfExpressions) {
                result[i] = (ExprTree)xml.get("expression", ExprTree.EXPR_TREE_XML);
                ++i;
            }
            return result;
        }
    };
    private static final long serialVersionUID = 5269312474198753496L;

    public ExprTreeIndividual() {
    }

    public ExprTreeIndividual(ExprTree[] genotype) {
        super(genotype);
    }

    public ExprTreeIndividual(ExprTree[] genotype, IFitness fitness) {
        super(genotype, fitness);
    }

    @Override
    public double distance(IIndividual other) {
        return 0.0;
    }

    @Override
    public IIndividual copy() {
        int gl = ((ExprTree[])this.genotype).length;
        ExprTree[] genotypeCopy = new ExprTree[gl];
        int i = 0;
        while (i < gl) {
            genotypeCopy[i] = ((ExprTree[])this.genotype)[i].copy();
            ++i;
        }
        return new ExprTreeIndividual(genotypeCopy);
    }

    public boolean equals(Object other) {
        if (other instanceof ExprTreeIndividual) {
            ExprTreeIndividual cother = (ExprTreeIndividual)other;
            EqualsBuilder eb = new EqualsBuilder();
            eb.append((Object[])this.genotype, (Object[])cother.genotype);
            return eb.isEquals();
        }
        return false;
    }

    public String toString() {
        ToStringBuilder tsb = new ToStringBuilder(this);
        tsb.append("genotype", (Object[])this.genotype);
        tsb.append("fitness", this.fitness);
        return tsb.toString();
    }

    static /* synthetic */ XmlFormat access$0() {
        return AbstractIndividual.XML;
    }
}

