/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.UnsupervisedLearning.AssociationRules.IntervalRuleLearning.MOPNAR;

import keel.Algorithms.UnsupervisedLearning.AssociationRules.IntervalRuleLearning.MOPNAR.myDataset;
import org.core.Randomize;

public class Gene {
    public static final int NOT_INVOLVED = -1;
    public static final int ANTECEDENT = 0;
    public static final int CONSEQUENT = 1;
    private int attr;
    private int ac;
    private boolean pn;
    private double lb;
    private double ub;
    private double min_attr;
    private double max_attr;
    private int type;

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public Gene copy() {
        Gene gene = new Gene();
        gene.attr = this.attr;
        gene.ac = this.ac;
        gene.pn = this.pn;
        gene.lb = this.lb;
        gene.ub = this.ub;
        gene.type = this.type;
        gene.min_attr = this.min_attr;
        gene.max_attr = this.max_attr;
        return gene;
    }

    public void invert(int type, double min_attr, double max_attr) {
        switch (this.ac) {
            case -1: {
                this.ac = 0;
                break;
            }
            case 0: {
                this.ac = 1;
                break;
            }
            case 1: {
                this.ac = -1;
            }
        }
        boolean bl = this.pn = !this.pn;
        if (type != 0) {
            if (type == 2) {
                this.lb = Randomize.RandClosed() * (this.lb - min_attr) + min_attr;
                this.ub = Randomize.RandClosed() * (max_attr - this.ub) + this.ub;
            } else {
                this.lb = Randomize.RandintClosed((int)min_attr, (int)this.lb);
                this.ub = Randomize.RandintClosed((int)this.ub, (int)max_attr);
            }
        } else if (this.lb == max_attr) {
            this.lb = this.ub = min_attr;
        } else {
            this.lb += 1.0;
            this.ub += 1.0;
        }
    }

    public int getActAs() {
        return this.ac;
    }

    public void setActAs(int ac) {
        this.ac = ac;
    }

    public boolean getIsPositiveInterval() {
        return this.pn;
    }

    public void setIsPositiveInterval(boolean pn) {
        this.pn = pn;
    }

    public double getLowerBound() {
        return this.lb;
    }

    public void setLowerBound(double lb) {
        this.lb = lb;
    }

    public double getUpperBound() {
        return this.ub;
    }

    public void setUpperBound(double ub) {
        this.ub = ub;
    }

    public boolean equals(Gene g) {
        if (g.attr == this.attr && g.ac == this.ac) {
            if (g.pn == this.pn) {
                if (Math.abs(g.lb - this.lb) <= 1.0E-5 && Math.abs(g.ub - this.ub) <= 1.0E-5) {
                    return true;
                }
            } else if (!g.pn) {
                double ub_posit;
                double lb_posit;
                if (g.lb == this.min_attr) {
                    lb_posit = g.ub;
                    ub_posit = this.max_attr;
                    lb_posit = this.type == 2 ? (lb_posit += 1.0E-4) : (lb_posit += 1.0);
                    if (Math.abs(lb_posit - this.lb) <= 1.0E-5 && Math.abs(ub_posit - this.ub) <= 1.0E-5) {
                        return true;
                    }
                }
                if (g.ub == this.max_attr) {
                    lb_posit = this.min_attr;
                    ub_posit = g.lb;
                    ub_posit = this.type == 2 ? (ub_posit -= 1.0E-4) : (ub_posit -= 1.0);
                    if (Math.abs(lb_posit - this.lb) <= 1.0E-5 && Math.abs(ub_posit - this.ub) <= 1.0E-5) {
                        return true;
                    }
                }
            } else if (!this.pn) {
                double ub_posit;
                double lb_posit;
                if (this.lb == this.min_attr) {
                    lb_posit = this.ub;
                    ub_posit = this.max_attr;
                    lb_posit = this.type == 2 ? (lb_posit += 1.0E-4) : (lb_posit += 1.0);
                    if (Math.abs(lb_posit - g.lb) <= 1.0E-5 && Math.abs(ub_posit - g.ub) <= 1.0E-5) {
                        return true;
                    }
                }
                if (this.ub == this.max_attr) {
                    lb_posit = this.min_attr;
                    ub_posit = this.lb;
                    ub_posit = this.type == 2 ? (ub_posit -= 1.0E-4) : (ub_posit -= 1.0);
                    if (Math.abs(lb_posit - g.lb) <= 1.0E-5 && Math.abs(ub_posit - g.ub) <= 1.0E-5) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public String toString() {
        return "Attr: " + this.attr + "AC: " + this.ac + "; PN: " + this.pn + "; LB: " + this.lb + "; UB: " + this.ub;
    }

    public int getAttr() {
        return this.attr;
    }

    public void setAttr(int var) {
        this.attr = var;
    }

    public int randAct() {
        return Randomize.RandintClosed(-1, 1);
    }

    public void tuneInterval(myDataset dataset, int[] covered) {
        int nData = dataset.getnTrans();
        if (this.pn) {
            double min = this.ub;
            double max = this.lb;
            for (int i = 0; i < nData; ++i) {
                if (covered[i] <= 0) continue;
                double[] example = dataset.getExample(i);
                if (example[this.attr] < min) {
                    min = example[this.attr];
                }
                if (!(example[this.attr] > max)) continue;
                max = example[this.attr];
            }
            this.ub = max;
            this.lb = min;
        } else {
            double delta = dataset.getAttributeType(this.attr) == 2 ? 1.0E-4 : 1.0;
            double min = dataset.getMax(this.attr) + delta;
            double max = dataset.getMin(this.attr) - delta;
            for (int r = 0; r < nData; ++r) {
                if (covered[r] <= 0) continue;
                double[] example = dataset.getExample(r);
                if (example[this.attr] < min && example[this.attr] > this.ub) {
                    min = example[this.attr];
                }
                if (!(example[this.attr] > max) || !(example[this.attr] < this.lb)) continue;
                max = example[this.attr];
            }
            this.lb = max + delta;
            this.ub = min - delta;
        }
    }

    public boolean isCover(int var, double value) {
        if (this.attr != var) {
            return false;
        }
        boolean covered = true;
        if (this.pn) {
            if (value < this.lb || value > this.ub) {
                covered = false;
            }
        } else if (value >= this.lb && value <= this.ub) {
            covered = false;
        }
        return covered;
    }

    public boolean isSubGen(Gene g) {
        if (this.attr != g.attr) {
            return false;
        }
        if (this.ac != g.ac) {
            return false;
        }
        if (this.pn && g.pn) {
            if (Math.abs(g.lb - this.lb) > 1.0E-5) {
                return false;
            }
            if (Math.abs(g.ub - this.ub) > 1.0E-5) {
                return false;
            }
        } else if (!this.pn && !g.pn) {
            if (Math.abs(g.lb - this.lb) > 1.0E-5) {
                return false;
            }
            if (Math.abs(g.ub - this.ub) > 1.0E-5) {
                return false;
            }
        } else if (!g.pn) {
            double ub_posit;
            double lb_posit;
            if (g.lb == this.min_attr) {
                lb_posit = g.ub;
                ub_posit = this.max_attr;
                lb_posit = this.type == 2 ? (lb_posit += 1.0E-4) : (lb_posit += 1.0);
                if (Math.abs(lb_posit - this.lb) > 1.0E-5) {
                    return false;
                }
                if (Math.abs(ub_posit - this.ub) > 1.0E-5) {
                    return false;
                }
            }
            if (g.ub == this.max_attr) {
                lb_posit = this.min_attr;
                ub_posit = g.lb;
                ub_posit = this.type == 2 ? (ub_posit -= 1.0E-4) : (ub_posit -= 1.0);
                if (Math.abs(lb_posit - this.lb) > 1.0E-5) {
                    return false;
                }
                if (Math.abs(ub_posit - this.ub) > 1.0E-5) {
                    return false;
                }
            }
        } else if (!this.pn) {
            double ub_posit;
            double lb_posit;
            if (this.lb == this.min_attr) {
                lb_posit = this.ub;
                ub_posit = this.max_attr;
                lb_posit = this.type == 2 ? (lb_posit += 1.0E-4) : (lb_posit += 1.0);
                if (Math.abs(lb_posit - g.lb) > 1.0E-5) {
                    return false;
                }
                if (Math.abs(ub_posit - this.ub) > 1.0E-5) {
                    return false;
                }
            }
            if (this.ub == this.max_attr) {
                lb_posit = this.min_attr;
                ub_posit = this.lb;
                ub_posit = this.type == 2 ? (ub_posit -= 1.0E-4) : (ub_posit -= 1.0);
                if (Math.abs(lb_posit - g.lb) > 1.0E-5) {
                    return false;
                }
                if (Math.abs(ub_posit - this.ub) > 1.0E-5) {
                    return false;
                }
            }
        }
        return true;
    }

    public double getMax_attr() {
        return this.max_attr;
    }

    public void setMax_attr(double max_attr) {
        this.max_attr = max_attr;
    }

    public double getMin_attr() {
        return this.min_attr;
    }

    public void setMin_attr(double min_attr) {
        this.min_attr = min_attr;
    }
}

