library(CARMS)

# usage: carms.make(title, diagram_grid=c(11,12),...)
SySoft<-carms.make(title="System      Software/Hardware",diagram_grid=c(13, 14))

# carms.state(x, prob,  name, size=4, h2w=21/24, Pfunction=NULL, plot.line.color=NULL, position,  description="")
SySoft<-carms.state(SySoft, prob= 1, name="Working", size=7, h2w=17/31, position= c(2, 6) )
SySoft<-carms.state(SySoft, prob= 0, name="Major problem", size=7, h2w=17/31, position= c(7, 2) )
SySoft<-carms.state(SySoft, prob= 0, name="HW error", size=7, h2w=17/31, position= c(7, 4) )
SySoft<-carms.state(SySoft, prob= 0, name="SW error", size=7, h2w=17/31, position= c(8, 8) )
SySoft<-carms.state(SySoft, prob= 0, name="Fault located", size=7, h2w=17/31, position= c(8, 11) )
SySoft<-carms.state(SySoft, prob= 0, name="Diagnosis", size=7, h2w=17/31, position= c(13, 6) )

# carms.base<-function(x, value, base_label=NULL, description="")
SySoft<-carms.base(SySoft, 1, time_units="hours", base_label="overhaul", description="overhaul / replace rate")
SySoft<-carms.base(SySoft, 2, base_label="repair",  description="repair / replace rate")
SySoft<-carms.base(SySoft, 3e-1, base_label="HWfailure",  description="HWfailure rate")
SySoft<-carms.base(SySoft, 4, base_label="restart",  description="restart rate")
SySoft<-carms.base(SySoft, 1e-1, base_label="SWfailure",  description="SWfailure rate")
SySoft<-carms.base(SySoft, 4e-1, base_label="redesign",  description="redesign / test rate")
SySoft<-carms.base(SySoft, 1e-1, base_label="HWdebug1",  description="HWdebug1 rate (difficult)")
SySoft<-carms.base(SySoft, 8, base_label="HWdebug2",  description="HWdebug2 rate (simple)")
SySoft<-carms.base(SySoft, 5e-2, base_label="unknown",  description="unknown failure rate")
SySoft<-carms.base(SySoft,2, base_label="SWdebug1",  description="SWdebug1 rate (difficult)")
SySoft<-carms.base(SySoft,2, base_label="SWdebug2",  description="SWdebug1 rate (difficult)")

# carms.arrow(x, from, to, rate, arc=0.35, arrow.position=0.5, label="")
SySoft<-carms.arrow(SySoft, 2, 1, rate="overhaul", arc=-.3, label="overhaul")
SySoft<-carms.arrow(SySoft, 3, 1, rate="repair", arc=-.05, label="repair")
SySoft<-carms.arrow(SySoft, 1, 3, rate="HWfailure", arc=.25, label="HWfailure")
SySoft<-carms.arrow(SySoft, 1, 6, rate="unknown", arc=-.05, label="unknown")
SySoft<-carms.arrow(SySoft, 4, 1, rate="restart", arc=.1, label="restart")
SySoft<-carms.arrow(SySoft, 1, 4, rate="SWfailure", arc=-.38, label="SWfailure")
SySoft<-carms.arrow(SySoft, 5, 1, rate="redesign", arc=.3, label="redesign")
SySoft<-carms.arrow(SySoft, 6, 2, rate="HWdebug1", arc=-.3, label="HWdebug1")
SySoft<-carms.arrow(SySoft, 6, 3, rate="HWdebug2", arc=-.25, label="HWdebug2")
SySoft<-carms.arrow(SySoft, 6, 4, rate="SWdebug1", arc=.35, label="SWdebug1")
SySoft<-carms.arrow(SySoft, 6, 5, rate="SWdebug2", arc=.3, label="SWdebug2")
	dev.new(width=20, height=15, unit="in")
	diagram(SySoft, rate.text.y.shift=0.7,shadow=FALSE )
# usage: simulate.carms(x, solution, mission_time, intervals=50, cycles=2000)
SySoft<-simulate(SySoft, "rk", mission_time=2, intervals=20)

	plot(SySoft, smooth.curve=F)
