library(CARMS)

# usage carms.make<-function(title, diagram_grid=c(12,12),...)
St2MMF<-carms.make(title="Standby        Multiple monitor failure modes", diagram_grid=c(210,210))
#usage carms.state<-function(x, prob,  name, size=4, h2w=21/24, position, plot.color=NULL,  description="")
St2MMF<-carms.state(St2MMF, prob=1, name="Fully operational state", size=7, h2w=22/34, position=c(30,30) )
St2MMF<-carms.state(St2MMF, prob=0, name="Primary failed, detected, switch to backup", size=7, h2w=22/34, position=c(100,30) )
St2MMF<-carms.state(St2MMF, prob=0, name="Monitor fail, no switch", size=7, h2w=22/34, position=c(95,55) )
St2MMF<-carms.state(St2MMF, prob=0, name="Monitor failed, switched", size=7, h2w=22/34, position=c(97,80) )
St2MMF<-carms.state(St2MMF, prob=0, name="Backup failed in standby", size=7, h2w=22/34, position=c(40,105) )
St2MMF<-carms.state(St2MMF, prob=0, name="Monitor failure", size=7, h2w=22/34, position=c(150,115) )
St2MMF<-carms.state(St2MMF, prob=0, name="System failure", size=7, h2w=22/34, position=c(180, 35) )
St2MMF<-carms.state(St2MMF, prob=1, name="Dual", size=7, h2w=22/34, position=c(35,155) )
St2MMF<-carms.state(St2MMF, prob=0, name="Single", size=7, h2w=22/34, position=c(100,155) )
St2MMF<-carms.state(St2MMF, prob=0, name="Failed", size=7, h2w=22/34, position=c(180,155) )
St2MMF<-carms.state(St2MMF, prob=0, name="NCF", size=7, h2w=22/34, position=c(45,195) )
St2MMF<-carms.state(St2MMF, prob=0, name="Failed or NCF", size=8, h2w=22/34, position=c(140,198),
Pfunction="P[,12]<-P[,10] + P[,11]")


# carms.base(x, value, time_units=NULL, base_label=NULL, description="")
St2MMF<-carms.base(St2MMF, 1, time_units="hours",base_label="IB", description="Backup failure rate")
St2MMF<-carms.base(St2MMF, 1, base_label="IA", description="Primary failure rate")
St2MMF<-carms.base(St2MMF, 1e-4, base_label="IAN", description="Primary failure not detected")
St2MMF<-carms.base(St2MMF, 0.9999, base_label="IAD", description="Primary failure detected")
St2MMF<-carms.base(St2MMF, 1e-3, base_label="IMA", description="Monitor can not switch")
St2MMF<-carms.base(St2MMF, 9.9e-2, base_label="IMB", description="False monitor switch")
St2MMF<-carms.base(St2MMF, 5e-2, base_label="IBST", description="Standby failure rate")
St2MMF<-carms.base(St2MMF, 0.9999, base_label="C", description="Coverage")

# carms.arrow(x, from, to, rate, arc=0.35, arrow.position=0.5, label="")
St2MMF<-carms.arrow(St2MMF, from=1, to=7, rate="IAN", arc=.1, label="IAN")
St2MMF<-carms.arrow(St2MMF, from=1, to=2, rate="IAD", arc=.05, label="IAD")
St2MMF<-carms.arrow(St2MMF, from=1, to=3, rate="IMA", arc=-.2, label="IMA")
St2MMF<-carms.arrow(St2MMF, from=3, to=7, rate="IA", arc=-.2, label="IA")
St2MMF<-carms.arrow(St2MMF, from=1, to=4, rate="IMB", arc=-.2, label="IMB")
St2MMF<-carms.arrow(St2MMF, from=4, to=7, rate="IB", arc=-.2, label="IB")
St2MMF<-carms.arrow(St2MMF, from=6, to=7, rate="IA", arc=-.2, label="IA")
St2MMF<-carms.arrow(St2MMF, from=5, to=7, rate="IA+IMB", arc=-.2, label="IA+IMB")
St2MMF<-carms.arrow(St2MMF, from=5, to=6, rate="IMA", arc=-.2, label="IMA")
St2MMF<-carms.arrow(St2MMF, from=1, to=5, rate="IBST", arc=-.2, label="IBST")
St2MMF<-carms.arrow(St2MMF, from=2, to=7, rate="IB", arc=-.05, label="IB")
St2MMF<-carms.arrow(St2MMF, from=8, to=9, rate="IA*C", arc=.2, label="IA*C")
St2MMF<-carms.arrow(St2MMF, from=9, to=10, rate="IB", arc=.2, label="IB")
St2MMF<-carms.arrow(St2MMF, from=8, to=11, rate="IA*(1-C)", arc=.2, label="IA*(1-C)")
	dev.new(width=30, height=30, unit="in")
	diagram(St2MMF, rate.text.y.shift=0.5)

# usage: simulate.carms(x, solution, mission_time, intervals=50, cycles=2000)
St2MMF<-simulate.carms(St2MMF, "rk", mission_time=5, intervals=50)

plot(St2MMF)

