/*
 * Decompiled with CFR 0.152.
 */
package blbutil;

import java.util.Arrays;

public class IntSet {
    private static final int NIL = -1;
    private static final float loadFactor = 0.75f;
    private int size;
    private int nBuckets;
    private int[] next;
    private int[] data;
    private int[] list;
    private int firstFreeIndex;

    public IntSet(int n) {
        if (n < 0 || n > 0x40000000) {
            throw new IllegalArgumentException(String.valueOf(n));
        }
        int n2 = (int)Math.ceil((float)n / 0.75f);
        this.allocateArrays(n, n2);
        this.initializeFields(n);
    }

    private void allocateArrays(int n, int n2) {
        this.next = new int[n2 + n];
        this.data = new int[n2 + n];
        this.list = new int[n];
    }

    private void initializeFields(int n) {
        this.size = 0;
        this.firstFreeIndex = this.nBuckets = n;
        Arrays.fill(this.next, 0, this.nBuckets, -1);
        for (int i = this.nBuckets; i < this.next.length; ++i) {
            this.next[i] = i + 1;
        }
    }

    private void rehash(int n) {
        if (n > this.size) {
            int n2 = this.size;
            int[] nArray = this.list;
            int n3 = (int)Math.ceil((float)n / 0.75f);
            this.allocateArrays(n, n3);
            this.initializeFields(n3);
            for (int i = 0; i < n2; ++i) {
                this.add(nArray[i]);
            }
        }
    }

    public boolean contains(int n) {
        int n2 = this.next[this.bucket(n)];
        while (n2 != -1 && this.list[this.data[n2]] < n) {
            n2 = this.next[n2];
        }
        return n2 != -1 && this.list[this.data[n2]] == n;
    }

    public boolean add(int n) {
        int n2 = this.prevIndex(n);
        int n3 = this.next[n2];
        if (n3 == -1 || this.list[this.data[n3]] != n) {
            int n4 = this.firstFreeIndex;
            this.firstFreeIndex = this.next[this.firstFreeIndex];
            this.next[n2] = n4;
            this.data[n4] = this.size;
            this.next[n4] = n3;
            this.list[this.size++] = n;
            if (this.size == this.list.length) {
                int n5 = 3 * this.list.length / 2 + 1;
                this.rehash(n5);
            }
            return true;
        }
        return false;
    }

    public boolean remove(int n) {
        int n2 = this.prevIndex(n);
        int n3 = this.next[n2];
        if (n3 == -1 || this.list[this.data[n3]] != n) {
            return false;
        }
        int n4 = this.data[n3];
        this.next[n2] = this.next[n3];
        this.next[n3] = this.firstFreeIndex;
        this.firstFreeIndex = n3;
        --this.size;
        if (n4 != this.size) {
            n3 = this.index(this.list[this.size]);
            this.data[n3] = n4;
            this.list[n4] = this.list[this.size];
        }
        return true;
    }

    private int bucket(int n) {
        return Math.abs(71 * n % this.nBuckets);
    }

    private int prevIndex(int n) {
        int n2 = this.bucket(n);
        int n3 = this.next[n2];
        while (n3 != -1 && this.list[this.data[n3]] < n) {
            n2 = n3;
            n3 = this.next[n3];
        }
        return n2;
    }

    private int index(int n) {
        int n2 = this.next[this.bucket(n)];
        while (n2 != -1 && this.list[this.data[n2]] < n) {
            n2 = this.next[n2];
        }
        return n2 != -1 && this.list[this.data[n2]] == n ? n2 : -1;
    }

    public int elementWithIndex(int n) {
        if (n >= this.size) {
            throw new IndexOutOfBoundsException(String.valueOf(n));
        }
        return this.list[n];
    }

    public void clear() {
        this.initializeFields(this.nBuckets);
    }

    public int size() {
        return this.size;
    }

    public int capacity() {
        return this.list.length;
    }

    public void setCapacity(int n) {
        if (n < this.size) {
            throw new IllegalArgumentException(String.valueOf(n));
        }
        if (n != this.list.length) {
            this.rehash(n);
        }
    }

    public int[] toArray() {
        return Arrays.copyOf(this.list, this.size);
    }

    public String toString() {
        return Arrays.toString(this.toArray());
    }
}

