## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(spect)

## -----------------------------------------------------------------------------

set.seed(42)

data <- create_synthetic_data()
head(data)


## -----------------------------------------------------------------------------

data <- create_synthetic_data(sample_size = 500
                      , minimum_income = 10000
                      , median_income = 40000
                      , income_variance = 10000
                      , min_watchhours = 2
                      , max_watchhours = 10
                      , censor_percentage = .2
                      , min_censor_amount = 3
                      , max_censor_amount = 3
                      , study_time_in_months = 60
                      , perturbation_shift = 5
                      )

head(data)

## -----------------------------------------------------------------------------
plot_synthetic_data(data)

