/*
 * Decompiled with CFR 0.152.
 */
package dmLab.utils;

import dmLab.utils.StringUtils;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public final class FileUtils {
    /*
     * WARNING - void declaration
     */
    public static String getFileExtension(String fileName) {
        void var1_1;
        String extension = "";
        int index = fileName.lastIndexOf(46);
        if (index > 0 && index < fileName.length() - 1) {
            void var2_2;
            String string;
            extension = string.substring((int)(var2_2 + true)).toLowerCase();
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static String dropFileExtension(File label) {
        void var1_2;
        String string;
        String name = label.getName();
        String ext = FileUtils.getFileExtension(name);
        int index = name.lastIndexOf(ext);
        string = string.substring(0, (int)(var1_2 - true));
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean saveString(String fileName, String data) {
        FileWriter file;
        File fileDir = new File(fileName).getParentFile();
        if (!fileDir.exists()) {
            fileDir.mkdir();
        }
        try {
            file = new FileWriter(fileName, false);
        }
        catch (IOException iOException) {
            System.err.println("Error opening file: " + fileName);
            return false;
        }
        try {
            void var2_2;
            void var1_1;
            file.write((String)var1_1);
            var2_2.close();
        }
        catch (IOException iOException) {
            String string;
            System.err.println("Error writing or closing file: " + string);
            return false;
        }
        return true;
    }

    public static boolean deleteFile(String fileName) {
        File file = new File(fileName);
        if (file.exists()) {
            File file2;
            file2.delete();
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static int deleteFiles(ArrayList<String> files) {
        void var1_1;
        int cnt = 0;
        for (int i = 0; i < files.size(); ++i) {
            if (!FileUtils.deleteFile(files.get(i))) continue;
            ++cnt;
        }
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static void addFileToZip(String fileName, ZipOutputStream zos) throws IOException {
        File file = new File(fileName);
        if (file.exists()) {
            void var2_2;
            void var1_1;
            int length;
            FileInputStream fis = new FileInputStream(file);
            File zipEntry = new ZipEntry(file.getName());
            zos.putNextEntry((ZipEntry)((Object)zipEntry));
            File bytes = (File)new byte[4096];
            while ((length = fis.read((byte[])bytes)) >= 0) {
                void var3_3;
                zos.write((byte[])bytes, 0, (int)var3_3);
            }
            var1_1.closeEntry();
            var2_2.close();
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void mkdirs(File outdir, String path) {
        void var1_1;
        File d = new File(outdir, (String)var1_1);
        if (!d.exists()) {
            File file;
            file.mkdirs();
        }
    }

    /*
     * WARNING - void declaration
     */
    public static File[] extract(File zipfile, File outdir, String fileNamePrefix) {
        File[] fileArray;
        void var3_3;
        File[] zin;
        ArrayList<File> extracted = new ArrayList<File>();
        try {
            Object entry;
            zin = new ZipInputStream(new FileInputStream(zipfile));
            while ((entry = zin.getNextEntry()) != null) {
                int n;
                String name = ((ZipEntry)entry).getName();
                if (((ZipEntry)entry).isDirectory()) {
                    FileUtils.mkdirs(outdir, name);
                    continue;
                }
                entry = name;
                int n2 = ((String)entry).lastIndexOf(File.separatorChar);
                String dir = n2 == -1 ? null : ((String)entry).substring(0, n2);
                if (dir != null) {
                    FileUtils.mkdirs(outdir, dir);
                } else {
                    FileUtils.mkdirs(outdir, "");
                }
                if (fileNamePrefix.length() <= 0 || !name.toLowerCase().startsWith(fileNamePrefix.toLowerCase())) continue;
                String string = name;
                Object object = outdir;
                File[] fileArray2 = zin;
                byte[] byArray = new byte[4096];
                object = new BufferedOutputStream(new FileOutputStream(new File((File)object, string)));
                while ((n = fileArray2.read(byArray)) != -1) {
                    ((BufferedOutputStream)object).write(byArray, 0, n);
                }
                ((FilterOutputStream)object).close();
                extracted.add(new File(name));
            }
            zin.close();
        }
        catch (IOException iOException) {
            zin = iOException;
            iOException.printStackTrace();
        }
        if (extracted.size() == 0) {
            return null;
        }
        File[] f = new File[1];
        return var3_3.toArray(fileArray);
    }

    /*
     * WARNING - void declaration
     */
    public static BufferedWriter openFileWriter(File file) {
        void var1_1;
        try {
            BufferedWriter fileWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file.toString()), "utf-8"));
        }
        catch (Exception exception) {
            File file2;
            System.err.println("Error opening file. File: " + file2.toString());
            return null;
        }
        return var1_1;
    }

    public static boolean closeFileWriter(BufferedWriter fileWriter) {
        try {
            if (fileWriter != null) {
                BufferedWriter bufferedWriter;
                bufferedWriter.close();
            }
        }
        catch (Exception exception) {
            System.err.println("Error closing file.");
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public static BufferedReader openFile(File file) {
        void var1_1;
        if (!file.exists()) {
            System.err.println("File does not exist. File: " + file.toString());
            return null;
        }
        try {
            BufferedReader fileReader = new BufferedReader(new FileReader(file));
        }
        catch (Exception exception) {
            File file2;
            System.err.println("Error opening file. File: " + file2.toString());
            return null;
        }
        return var1_1;
    }

    public static boolean closeFile(BufferedReader fileReader) {
        try {
            if (fileReader != null) {
                BufferedReader bufferedReader;
                bufferedReader.close();
            }
        }
        catch (Exception exception) {
            System.err.println("Error closing file.");
            return false;
        }
        return true;
    }

    public static String getTmpDir(String prefix, int length) {
        Object object;
        File tmpPath = new File(System.getProperty("java.io.tmpdir") + File.separator);
        Object tmpDir = new File(tmpPath.getAbsolutePath() + File.separator + prefix + "_" + StringUtils.getRandomString(10));
        while (((File)tmpDir).exists()) {
            tmpDir = new File(tmpPath.getAbsolutePath() + StringUtils.getRandomString(10));
        }
        return ((File)object).getAbsolutePath() + File.separator;
    }

    public static boolean deleteDir(File dir) {
        File file;
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                boolean bl = FileUtils.deleteDir(new File(dir, children[i]));
                if (bl) continue;
                return false;
            }
        }
        return file.delete();
    }
}

