/*
 * Decompiled with CFR 0.152.
 */
package jdr.spec.tramoseats;

import ec.tstoolkit.modelling.RegressionTestType;
import ec.tstoolkit.modelling.TradingDaysSpecType;
import ec.tstoolkit.modelling.arima.tramo.TradingDaysSpec;
import ec.tstoolkit.modelling.arima.tramo.TramoSpecification;
import ec.tstoolkit.timeseries.calendars.TradingDaysType;
import jdr.spec.tramoseats.BaseTramoSpec;

public class TradingDaysSpec
extends BaseTramoSpec {
    private ec.tstoolkit.modelling.arima.tramo.TradingDaysSpec inner() {
        return this.core.getRegression().getCalendar().getTradingDays();
    }

    public TradingDaysSpec(TramoSpecification spec) {
        super(spec);
    }

    public String getOption() {
        ec.tstoolkit.modelling.arima.tramo.TradingDaysSpec spec = this.inner();
        if (spec.isUsed()) {
            if (spec.isStockTradingDays()) {
                return TradingDaysSpecType.Stock.name();
            }
            if (spec.getHolidays() != null) {
                return TradingDaysSpecType.Holidays.name();
            }
            if (spec.getUserVariables() != null) {
                return TradingDaysSpecType.UserDefined.name();
            }
            if (spec.isUsed()) {
                return TradingDaysSpecType.Default.name();
            }
        }
        return TradingDaysSpecType.None.name();
    }

    public void setOption(String nvalue) {
        ec.tstoolkit.modelling.arima.tramo.TradingDaysSpec spec = this.inner();
        TradingDaysSpecType value = TradingDaysSpecType.valueOf((String)nvalue);
        switch (value) {
            case None: {
                spec.disable();
                break;
            }
            case Default: {
                spec.setTradingDaysType(TradingDaysType.TradingDays);
                spec.setLeapYear(true);
                spec.setHolidays(null);
                spec.setTest(true);
                break;
            }
            case Stock: {
                spec.setStockTradingDays(31);
                spec.setTest(true);
                break;
            }
            case Holidays: {
                spec.setTradingDaysType(TradingDaysType.TradingDays);
                spec.setLeapYear(true);
                spec.setHolidays("Default");
                spec.setTest(true);
                break;
            }
            case UserDefined: {
                spec.setUserVariables(new String[0]);
                spec.setTest(true);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Not supported yet.");
            }
        }
    }

    public String getRegressionTestType() {
        return this.inner().getRegressionTestType().name();
    }

    public void setRegressionTestType(String value) {
        this.inner().setRegressionTestType(RegressionTestType.valueOf((String)value));
    }

    public int getW() {
        return this.inner().getStockTradingDays();
    }

    public void setW(int w) {
        this.inner().setStockTradingDays(w);
    }

    public String getTradingDays() {
        return this.inner().getTradingDaysType().toString();
    }

    public void setTradingDays(String value) {
        this.inner().setTradingDaysType(TradingDaysType.valueOf((String)value));
    }

    public boolean getLeapYear() {
        return this.inner().isLeapYear();
    }

    public void setLeapYear(boolean value) {
        this.inner().setLeapYear(value);
    }

    public String[] getUserVariables() {
        return this.inner().getUserVariables();
    }

    public void setUserVariables(String[] vars) {
        this.inner().setUserVariables(vars);
    }

    public String getAutomatic() {
        return this.inner().getAutomaticMethod().name();
    }

    public void setAutomatic(String value) {
        this.inner().setAutomaticMethod(TradingDaysSpec.AutoMethod.valueOf((String)value));
    }

    public double getPftd() {
        return this.inner().getProbabibilityForFTest();
    }

    public void setPftd(double value) {
        this.inner().setProbabibilityForFTest(value);
    }
}

