/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.timeseries.regression;

import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.timeseries.Day;
import ec.tstoolkit.timeseries.regression.AbstractSingleTsVariable;
import ec.tstoolkit.timeseries.simplets.TsDomain;
import ec.tstoolkit.timeseries.simplets.TsFrequency;
import ec.tstoolkit.timeseries.simplets.TsPeriod;

public class LinearTrend
extends AbstractSingleTsVariable {
    private Day m_start;

    public LinearTrend(Day start) {
        this.m_start = start;
    }

    @Override
    public void data(TsPeriod start, DataBlock data) {
        TsPeriod s = new TsPeriod(start.getFrequency(), this.m_start);
        int val = start.minus(s);
        for (int i = 0; i < data.getLength(); ++i) {
            data.set(i, val + i);
        }
    }

    @Override
    public String getDescription(TsFrequency context) {
        return "Trend";
    }

    @Override
    public boolean isSignificant(TsDomain domain) {
        return true;
    }

    @Override
    public String getName() {
        return "trend";
    }
}

